/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.cmdline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.clapper.util.cmdline.OptionComparator;
import org.clapper.util.cmdline.OptionInfo;

public final class UsageInfo {
    public static final char NO_SHORT_OPTION = '\u0000';
    public static final char SHORT_OPTION_PREFIX = '-';
    public static final String LONG_OPTION_PREFIX = "--";
    private Map<Character, OptionInfo> shortOptionMap = new HashMap<Character, OptionInfo>();
    private Map<String, OptionInfo> longOptionMap = new HashMap<String, OptionInfo>();
    private Set<OptionInfo> allOptions = new TreeSet<OptionInfo>(new OptionComparator());
    private Map<String, String> paramMap = new HashMap<String, String>();
    private Set<String> requiredParams = new HashSet<String>();
    private List<String> paramNames = new ArrayList<String>();
    private String usagePrologue = null;
    private String usageTrailer = null;
    private String commandName = null;

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String string) {
        this.commandName = string;
    }

    public void addOption(char c, String string, String string2) {
        this.addOption(c, string, null, string2);
    }

    public void addOption(char c, String string, String string2, String string3) {
        if (string != null && string.charAt(0) == '-') {
            throw new IllegalArgumentException("(BUG) Long option \"" + string + "\", registered via UsageInfo.addOption(), starts with \"-\".");
        }
        if (c == '\u0000' && string == null) {
            throw new IllegalArgumentException("(BUG) shortOption parameter is NO_SHORT_OPTION, and longOption parameter is null.");
        }
        OptionInfo optionInfo = new OptionInfo(c, string, string2, string3);
        if (c != '\u0000') {
            this.shortOptionMap.put(Character.valueOf(c), optionInfo);
        }
        if (string != null) {
            this.longOptionMap.put(string, optionInfo);
        }
        this.allOptions.add(optionInfo);
    }

    public void addParameter(String string, String string2, boolean bl) {
        if (string.charAt(0) == '-') {
            throw new IllegalArgumentException("(BUG) Option \"" + string + "\" registered via UsageInfo.addParameter(), instead of via UsageInfo.addOption().");
        }
        this.paramMap.put(string, string2);
        this.paramNames.add(string);
        if (bl) {
            this.requiredParams.add(string);
        }
    }

    public void addUsagePrologue(String string) {
        this.usagePrologue = string;
    }

    public void addUsageTrailer(String string) {
        this.usageTrailer = string;
    }

    String[] getParameterNames() {
        String[] stringArray = new String[this.paramNames.size()];
        int n = 0;
        Iterator<String> iterator = this.paramNames.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next();
            ++n;
        }
        return stringArray;
    }

    boolean parameterIsRequired(String string) {
        return this.requiredParams.contains(string);
    }

    String getParameterExplanation(String string) {
        return this.paramMap.get(string);
    }

    OptionInfo getOptionInfo(char c) {
        return this.shortOptionMap.get(Character.valueOf(c));
    }

    OptionInfo getOptionInfo(String string) {
        return this.longOptionMap.get(string);
    }

    OptionInfo[] getOptions() {
        OptionInfo[] optionInfoArray = new OptionInfo[this.allOptions.size()];
        int n = 0;
        Iterator<OptionInfo> iterator = this.allOptions.iterator();
        while (iterator.hasNext()) {
            optionInfoArray[n] = iterator.next();
            ++n;
        }
        Arrays.sort(optionInfoArray, new OptionComparator(true));
        return optionInfoArray;
    }

    String getUsagePrologue() {
        return this.usagePrologue;
    }

    String getUsageTrailer() {
        return this.usageTrailer;
    }
}

