/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.clapper.util.config.ConfigurationException;
import org.clapper.util.config.EnvSection;
import org.clapper.util.config.NoSuchSectionException;
import org.clapper.util.config.NoSuchVariableException;
import org.clapper.util.config.ProgramSection;
import org.clapper.util.config.Section;
import org.clapper.util.config.SectionExistsException;
import org.clapper.util.config.SystemSection;
import org.clapper.util.config.ValueSegment;
import org.clapper.util.config.Variable;
import org.clapper.util.io.FileUtil;
import org.clapper.util.logging.Logger;
import org.clapper.util.text.TextUtil;
import org.clapper.util.text.UnixShellVariableSubstituter;
import org.clapper.util.text.VariableDereferencer;
import org.clapper.util.text.VariableNameChecker;
import org.clapper.util.text.VariableSubstituter;
import org.clapper.util.text.VariableSubstitutionException;
import org.clapper.util.text.XStringBuffer;

public class Configuration
implements VariableDereferencer,
VariableNameChecker {
    private static final String COMMENT_CHARS = "#!";
    private static final char SECTION_START = '[';
    private static final char SECTION_END = ']';
    private static final String INCLUDE = "%include";
    private static final int MAX_INCLUDE_NESTING_LEVEL = 50;
    private static final String SYSTEM_SECTION_NAME = "system";
    private static final String PROGRAM_SECTION_NAME = "program";
    private static final String ENV_SECTION_NAME = "env";
    private static final int SYSTEM_SECTION_ID = 0;
    private static final int PROGRAM_SECTION_ID = 1;
    private static final int ENV_SECTION_ID = 2;
    private static final int FIRST_CONFIG_SECTION_ID = 3;
    private URL configURL = null;
    private List<Section> sectionsInOrder = new ArrayList<Section>();
    private Map<String, Section> sectionsByName = new HashMap<String, Section>();
    private static Section systemSection;
    private Section programSection;
    private Section envSection;
    private int nextSectionIDValue = 3;
    private static final Logger log;
    private boolean abortOnUndefinedVariable = true;
    private UnixShellVariableSubstituter varSubstituter = new UnixShellVariableSubstituter();

    public void addSection(String string) throws SectionExistsException {
        if (this.sectionsByName.get(string) != null) {
            throw new SectionExistsException(string);
        }
        this.makeNewSection(string);
    }

    public void clear() {
        this.sectionsInOrder.clear();
        this.sectionsByName.clear();
        this.configURL = null;
    }

    public final boolean containsSection(String string) {
        return this.sectionsByName.get(string) != null;
    }

    public URL getConfigurationFileURL() {
        return this.configURL;
    }

    public Collection<String> getSectionNames(Collection<String> collection) {
        for (Section section : this.sectionsInOrder) {
            collection.add(section.getName());
        }
        return collection;
    }

    public Collection<String> getSectionNames() {
        return this.getSectionNames(new ArrayList<String>());
    }

    public Collection<String> getVariableNames(String string, Collection<String> collection) throws NoSuchSectionException {
        Section section = this.sectionsByName.get(string);
        if (section == null) {
            throw new NoSuchSectionException(string);
        }
        collection.addAll(section.getVariableNames());
        return collection;
    }

    public Collection<String> getVariableNames(String string) throws NoSuchSectionException {
        return this.getVariableNames(string, new ArrayList<String>());
    }

    public String getConfigurationValue(String string, String string2) throws NoSuchSectionException, NoSuchVariableException {
        Section section = this.sectionsByName.get(string);
        if (section == null) {
            throw new NoSuchSectionException(string);
        }
        Variable variable = null;
        try {
            variable = section.getVariable(string2);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (variable == null) {
            throw new NoSuchVariableException(string, string2);
        }
        return variable.getCookedValue();
    }

    public String getRawValue(String string, String string2) throws NoSuchSectionException, NoSuchVariableException {
        Section section = this.sectionsByName.get(string);
        if (section == null) {
            throw new NoSuchSectionException(string);
        }
        Variable variable = null;
        try {
            variable = section.getVariable(string2);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (variable == null) {
            throw new NoSuchVariableException(string, string2);
        }
        return variable.getRawValue();
    }

    public String[] getConfigurationTokens(String string, String string2) throws ConfigurationException {
        Section section = this.sectionsByName.get(string);
        if (section == null) {
            throw new NoSuchSectionException(string);
        }
        Variable variable = null;
        try {
            variable = section.getVariable(string2);
        }
        catch (ConfigurationException configurationException) {
            log.error("Can't get value for variable \"" + string2 + "\" in section \"" + string + "\"", configurationException);
        }
        if (variable == null) {
            throw new NoSuchVariableException(string, string2);
        }
        ValueSegment[] valueSegmentArray = variable.getCookedSegments();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (valueSegmentArray != null) {
            for (ValueSegment valueSegment : valueSegmentArray) {
                String[] stringArray;
                String string3 = valueSegment.toString();
                if (valueSegment.isLiteral || valueSegment.isWhiteSpaceEscaped) {
                    arrayList.add(string3);
                    continue;
                }
                for (String string4 : stringArray = TextUtil.split(string3)) {
                    arrayList.add(string4);
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public int getOptionalIntegerValue(String string, String string2, int n) throws ConfigurationException {
        int n2 = n;
        try {
            n2 = this.getRequiredIntegerValue(string, string2);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            // empty catch block
        }
        return n2;
    }

    public int getRequiredIntegerValue(String string, String string2) throws ConfigurationException {
        String string3 = this.getConfigurationValue(string, string2);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badNumericValue", "Bad numeric value \"{0}\" for variable \"{1}\" in section \"{2}\"", new Object[]{string3, string2, string});
        }
    }

    public int getOptionalCardinalValue(String string, String string2, int n) throws ConfigurationException {
        assert (n >= 0);
        int n2 = n;
        try {
            n2 = this.getRequiredCardinalValue(string, string2);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            // empty catch block
        }
        return n2;
    }

    public int getRequiredCardinalValue(String string, String string2) throws ConfigurationException {
        String string3 = this.getConfigurationValue(string, string2);
        int n = this.getRequiredIntegerValue(string, string2);
        if (n < 0) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.negativeCardinalValue", "Bad negative numeric value \"{0}\" for variable \"{1}\" in section \"{2}\"", new Object[]{string3, string2, string});
        }
        return n;
    }

    public double getOptionalDoubleValue(String string, String string2, double d) throws ConfigurationException {
        double d2 = d;
        try {
            d2 = this.getRequiredDoubleValue(string, string2);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            // empty catch block
        }
        return d2;
    }

    public double getRequiredDoubleValue(String string, String string2) throws ConfigurationException {
        String string3 = this.getConfigurationValue(string, string2);
        try {
            return Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badFloatValue", "Bad floating point value \"{0}\" for variable \"{1}\" in section \"{2}\"", new Object[]{string3, string2, string});
        }
    }

    public boolean getOptionalBooleanValue(String string, String string2, boolean bl) throws ConfigurationException {
        boolean bl2;
        try {
            String string3 = this.getConfigurationValue(string, string2);
            bl2 = TextUtil.stringIsEmpty(string3) ? bl : TextUtil.booleanFromString(string3);
        }
        catch (NoSuchVariableException noSuchVariableException) {
            bl2 = bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConfigurationException(illegalArgumentException.getMessage());
        }
        return bl2;
    }

    public boolean getRequiredBooleanValue(String string, String string2) throws ConfigurationException {
        String string3 = this.getConfigurationValue(string, string2);
        try {
            return TextUtil.booleanFromString(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badBooleanValue", "Bad boolean value \"{0}\" for variable \"{1}\" in section \"{2}\".\n", new Object[]{string3, string2, string});
        }
    }

    public String getOptionalStringValue(String string, String string2, String string3) throws ConfigurationException {
        String string4;
        try {
            string4 = this.getConfigurationValue(string, string2);
            if (TextUtil.stringIsEmpty(string4)) {
                string4 = string3;
            }
        }
        catch (NoSuchVariableException noSuchVariableException) {
            string4 = string3;
        }
        return string4;
    }

    @Override
    public String getVariableValue(String string, Object object) throws VariableSubstitutionException {
        String string2;
        Section section;
        String string3 = null;
        SubstitutionContext substitutionContext = (SubstitutionContext)object;
        try {
            this.checkVariableName(string);
        }
        catch (ConfigurationException configurationException) {
            throw new VariableSubstitutionException(configurationException);
        }
        Variable variable = substitutionContext.currentVariable;
        if (variable.getName().equals(string)) {
            throw new VariableSubstitutionException("org.clapper.util.config.Bundle", "Configuration.recursiveSubst", "Attempt to substitute value for variable \"{0}\" within itself.", new Object[]{string});
        }
        Section section2 = substitutionContext.currentVariable.getSection();
        int n = string.indexOf(58);
        if (n == -1) {
            section = section2;
            string2 = section.getName();
        } else {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
            section = string2.equals(SYSTEM_SECTION_NAME) ? systemSection : (string2.equals(PROGRAM_SECTION_NAME) ? this.programSection : (string2.equals(ENV_SECTION_NAME) ? this.envSection : this.sectionsByName.get(string2)));
        }
        if (section == null) {
            if (this.abortOnUndefinedVariable) {
                throw new VariableSubstitutionException("org.clapper.util.config.Bundle", "Configuration.nonExistentSection", "Reference to variable \"{0}\" in nonexistent section \"{1}\".", new Object[]{string, string2});
            }
        } else {
            Variable variable2;
            if (section2.getID() < section.getID()) {
                String string4 = section2.getName();
                String string5 = section.getName();
                throw new VariableSubstitutionException("org.clapper.util.config.Bundle", "Configuration.badSectionRef", "Variable \"{0}\" in section \"{1}\" cannot substitute the value of variable \"{2}\" from section \"{3}\", because section \"{3}\" appears after section \"{1}\" in the configuration file.", new Object[]{substitutionContext.currentVariable.getName(), string4, string, string5, string5, string4});
            }
            try {
                variable2 = section.getVariable(string);
            }
            catch (ConfigurationException configurationException) {
                throw new VariableSubstitutionException(configurationException.getMessage());
            }
            if (variable2 != null) {
                string3 = variable2.getCookedValue();
            }
        }
        ++substitutionContext.totalSubstitutions;
        return string3;
    }

    @Override
    public boolean legalVariableCharacter(char c) {
        return !UnixShellVariableSubstituter.isVariableMetacharacter(c);
    }

    public void load(File file) throws IOException, ConfigurationException {
        this.load(file, null);
    }

    public void load(File file, String string) throws IOException, ConfigurationException {
        this.clear();
        URL uRL = file.toURI().toURL();
        this.parse(new FileInputStream(file), string, uRL);
        this.configURL = uRL;
    }

    public void load(String string) throws IOException, ConfigurationException {
        this.load(string, null);
    }

    public void load(String string, String string2) throws IOException, ConfigurationException {
        this.clear();
        URL uRL = new File(string).toURI().toURL();
        this.parse(new FileInputStream(string), string2, uRL);
        this.configURL = uRL;
    }

    public void load(URL uRL) throws IOException, ConfigurationException {
        this.load(uRL, null);
    }

    public void load(URL uRL, String string) throws IOException, ConfigurationException {
        this.clear();
        this.parse(uRL.openStream(), string, uRL);
        this.configURL = uRL;
    }

    public void load(InputStream inputStream) throws IOException, ConfigurationException {
        this.load(inputStream, null);
    }

    public void load(InputStream inputStream, String string) throws IOException, ConfigurationException {
        this.clear();
        this.parse(inputStream, string, null);
    }

    public void setVariable(String string, String string2, String string3, boolean bl) throws NoSuchSectionException, VariableSubstitutionException {
        Variable variable;
        Section section = this.sectionsByName.get(string);
        if (section == null) {
            throw new NoSuchSectionException(string);
        }
        try {
            variable = section.getVariable(string2);
            if (variable != null) {
                variable.setValue(string3);
            } else {
                variable = section.addVariable(string2, string3);
            }
        }
        catch (ConfigurationException configurationException) {
            throw new VariableSubstitutionException(configurationException.getMessage());
        }
        if (bl) {
            try {
                this.substituteVariables(variable, this.varSubstituter, true);
            }
            catch (ConfigurationException configurationException) {
                throw new VariableSubstitutionException(configurationException.getMessage());
            }
        }
    }

    public boolean getAbortOnUndefinedVariable() {
        return this.abortOnUndefinedVariable;
    }

    public void setAbortOnUndefinedVariable(boolean bl) {
        this.abortOnUndefinedVariable = bl;
        this.varSubstituter.setAbortOnUndefinedVariable(bl);
    }

    public void write(PrintWriter printWriter) throws ConfigurationException {
        XStringBuffer xStringBuffer = new XStringBuffer();
        boolean bl = true;
        printWriter.print(COMMENT_CHARS.charAt(0));
        printWriter.print(" Written by ");
        printWriter.println(this.getClass().getName());
        printWriter.print(COMMENT_CHARS.charAt(0));
        printWriter.print(" on ");
        printWriter.println(new Date().toString());
        printWriter.println();
        for (Section section : this.sectionsInOrder) {
            if (!bl) {
                printWriter.println();
            }
            printWriter.println('[' + section.getName() + ']');
            bl = false;
            for (String string : section.getVariableNames()) {
                Variable variable = section.getVariable(string);
                xStringBuffer.setLength(0);
                xStringBuffer.append(variable.getRawValue());
                printWriter.println(string + ": " + xStringBuffer.toString());
            }
        }
    }

    public void write(PrintStream printStream) throws ConfigurationException {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.write(printWriter);
        printWriter.flush();
    }

    private synchronized void parse(InputStream inputStream, String string, URL uRL) throws ConfigurationException, UnsupportedEncodingException {
        this.loadConfiguration(inputStream, string, uRL, new ParseContext());
    }

    private void loadConfiguration(InputStream inputStream, String string, URL uRL, ParseContext parseContext) throws ConfigurationException, UnsupportedEncodingException {
        Line line = new Line();
        String string2 = uRL.toExternalForm();
        this.programSection = new ProgramSection(PROGRAM_SECTION_NAME, 1);
        systemSection = new SystemSection(SYSTEM_SECTION_NAME, 0);
        this.envSection = new EnvSection(ENV_SECTION_NAME, 2);
        if (parseContext.openURLs.contains(string2)) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.recursiveInclude", "{0}, line {1}: Attempt to include \"{2}\" from itself, either directly or indirectly.", new Object[]{uRL.toExternalForm(), String.valueOf(line.number), string2});
        }
        parseContext.openURLs.add(string2);
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        block8: while (this.readLogicalLine(bufferedReader, line)) {
            try {
                switch (line.type) {
                    case COMMENT: 
                    case BLANK: {
                        continue block8;
                    }
                    case INCLUDE: {
                        this.handleInclude(line, uRL, string, parseContext);
                        continue block8;
                    }
                    case SECTION: {
                        parseContext.currentSection = this.handleNewSection(line, uRL);
                        continue block8;
                    }
                    case VARIABLE: {
                        if (parseContext.currentSection == null) {
                            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.varBeforeSection", "{0}, line {1}: Variable assignment before first section.", new Object[]{uRL.toExternalForm(), String.valueOf(line.number)});
                        }
                        this.handleVariable(line, uRL, parseContext);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Bug: line.type=" + (Object)((Object)line.type));
            }
            catch (IOException iOException) {
                throw new ConfigurationException(this.getExceptionPrefix(line, uRL) + iOException.toString());
            }
        }
        parseContext.openURLs.remove(string2);
    }

    private Section handleNewSection(Line line, URL uRL) throws ConfigurationException {
        String string = line.buffer.toString().trim();
        if (string.charAt(0) != '[') {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badSectionBegin", "{0}, line {1}: Section does not begin with \"{2}\"", new Object[]{uRL.toExternalForm(), String.valueOf(line.number), String.valueOf('[')});
        }
        if (string.charAt(string.length() - 1) != ']') {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badSectionEnd", "{0}, line {1}: Section does not end with \"{2}\"", new Object[]{uRL.toExternalForm(), String.valueOf(line.number), String.valueOf(']')});
        }
        return this.makeNewSection(string.substring(1, string.length() - 1));
    }

    private void handleVariable(Line line, URL uRL, ParseContext parseContext) throws ConfigurationException {
        int n;
        char[] cArray = line.buffer.toString().toCharArray();
        for (n = 0; n < cArray.length && cArray[n] != ':' && cArray[n] != '='; ++n) {
        }
        if (n == cArray.length) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.missingAssignOp", "{0}, line {1}: Missing \"=\" or \":\" for variable definition.", new Object[]{uRL.toExternalForm(), String.valueOf(line.number)});
        }
        if (n == 0) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.noVariablName", "{0}, line {1}: Missing variable name for variable definition.", new Object[]{uRL.toExternalForm(), String.valueOf(line.number)});
        }
        int n2 = 0;
        int n3 = n - 1;
        while (Character.isWhitespace(cArray[n2])) {
            ++n2;
        }
        while (Character.isWhitespace(cArray[n3])) {
            --n3;
        }
        if (n2 > n3) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.noVariablName", "{0}, line {1}: Missing variable name for variable definition.", new Object[]{uRL.toExternalForm(), String.valueOf(line.number)});
        }
        String string = new String(cArray, n2, n3 - n2 + 1);
        if (string.length() == 0) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.noVariablName", "{0}, line {1}: Missing variable name for variable definition.", new Object[]{uRL.toExternalForm(), String.valueOf(line.number)});
        }
        this.checkVariableName(string);
        n2 = this.skipWhitespace(cArray, n + 1);
        n3 = cArray.length - n2;
        Section section = parseContext.currentSection;
        String string2 = new String(cArray, n2, n3);
        Variable variable = section.getVariable(string);
        if (variable != null) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.duplicateVar", "{0}, line {1}: Section \"{2}\" has a duplicate definition for variable \"{3}\". The first instance was defined on line {4}.", new Object[]{uRL.toExternalForm(), String.valueOf(line.number), section.getName(), string, String.valueOf(variable.getLineWhereDefined())});
        }
        Variable variable2 = section.addVariable(string, string2, line.number);
        try {
            variable2.segmentValue();
            this.decodeMetacharacters(variable2);
            this.substituteVariables(variable2, this.varSubstituter, false);
            variable2.reassembleCookedValueFromSegments();
        }
        catch (VariableSubstitutionException variableSubstitutionException) {
            throw new ConfigurationException(variableSubstitutionException.getMessage());
        }
    }

    private void checkVariableName(String string) throws ConfigurationException {
        for (char c : string.toCharArray()) {
            if (this.legalVariableCharacter(c)) continue;
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.badVariableName", "\"{0}\" is an illegal variable name", new Object[]{string});
        }
    }

    private void handleInclude(Line line, URL uRL, String string, ParseContext parseContext) throws IOException, ConfigurationException {
        if (parseContext.includeFileNestingLevel >= 50) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.maxNestedIncludeExceeded", "{0}, line {1}: Exceeded maximum nested include level of {2}.", new Object[]{uRL.toExternalForm(), String.valueOf(line.number), String.valueOf(50)});
        }
        ++parseContext.includeFileNestingLevel;
        String string2 = line.buffer.toString();
        String string3 = string2.substring(INCLUDE.length() + 1).trim();
        int n = string3.length();
        if (n < 2 || !string3.startsWith("\"") || !string3.endsWith("\"")) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.malformedDirective", "{0}, line {1}: Malformed \"{2}\" directive", new Object[]{uRL.toExternalForm(), String.valueOf(line.number), INCLUDE});
        }
        if ((string3 = string3.substring(1, n - 1)).length() == 0) {
            throw new ConfigurationException("org.clapper.util.config.Bundle", "Configuration.includeMissingFile", "{0}, line {1}: Missing file name or URL in \"{2}\" directive", new Object[]{uRL.toExternalForm(), String.valueOf(line.number), INCLUDE});
        }
        try {
            this.loadInclude(new URL(string3), string, parseContext);
        }
        catch (MalformedURLException malformedURLException) {
            if (FileUtil.isAbsolutePath(string3)) {
                this.loadInclude(new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string3), string, parseContext);
            }
            if (uRL == null) {
                this.loadInclude(new File(string3).toURI().toURL(), string, parseContext);
            }
            String string4 = new File(uRL.getFile()).getParent();
            if (string4 == null) {
                string4 = "";
            }
            this.loadInclude(new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string4 + "/" + string3), string, parseContext);
        }
        --parseContext.includeFileNestingLevel;
    }

    private void loadInclude(URL uRL, String string, ParseContext parseContext) throws IOException, ConfigurationException {
        this.loadConfiguration(uRL.openStream(), string, uRL, parseContext);
    }

    private boolean readLogicalLine(BufferedReader bufferedReader, Line line) throws ConfigurationException {
        boolean bl;
        block4: {
            String string;
            boolean bl2 = false;
            bl = false;
            line.newLine();
            while (true) {
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    throw new ConfigurationException(iOException.toString());
                }
                if (string == null) break block4;
                bl = true;
                ++line.number;
                char[] cArray = string.toCharArray();
                int n = this.skipWhitespace(cArray, 0);
                string = n < cArray.length ? string.substring(n) : "";
                if (!bl2) {
                    line.type = string.length() == 0 ? LineType.BLANK : (COMMENT_CHARS.indexOf(string.charAt(0)) != -1 ? LineType.COMMENT : (string.charAt(0) == '[' ? LineType.SECTION : (new StringTokenizer(string).nextToken().equals(INCLUDE) ? LineType.INCLUDE : LineType.VARIABLE)));
                }
                if (line.type != LineType.VARIABLE || !this.hasContinuationMark(string)) break;
                bl2 = true;
                line.buffer.append(string.substring(0, string.length() - 1));
            }
            line.buffer.append(string);
        }
        return bl;
    }

    private boolean hasContinuationMark(String string) {
        char[] cArray;
        boolean bl = false;
        if (string.length() > 0 && (cArray = string.toCharArray())[cArray.length - 1] == '\\') {
            int n = 0;
            for (int i = cArray.length - 1; i >= 0 && cArray[i] == '\\'; --i) {
                ++n;
            }
            bl = n % 2 == 1;
        }
        return bl;
    }

    private String getExceptionPrefix(Line line, URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        if (uRL != null) {
            stringBuffer.append(uRL.toExternalForm());
            stringBuffer.append(", line ");
        } else {
            stringBuffer.append("Line ");
        }
        stringBuffer.append(line.number);
        stringBuffer.append(": ");
        return stringBuffer.toString();
    }

    private void decodeMetacharacters(Variable variable) throws VariableSubstitutionException, ConfigurationException {
        ValueSegment[] valueSegmentArray;
        for (ValueSegment valueSegment : valueSegmentArray = variable.getCookedSegments()) {
            if (valueSegment.isLiteral) continue;
            valueSegment.segmentBuf.decodeMetacharacters();
        }
    }

    private void substituteVariables(Variable variable, VariableSubstituter variableSubstituter, boolean bl) throws VariableSubstitutionException, ConfigurationException {
        ValueSegment[] valueSegmentArray = variable.getCookedSegments();
        SubstitutionContext substitutionContext = new SubstitutionContext(variable);
        for (ValueSegment valueSegment : valueSegmentArray) {
            if (valueSegment.isLiteral) continue;
            String string = valueSegment.segmentBuf.toString();
            do {
                substitutionContext.totalSubstitutions = 0;
                string = variableSubstituter.substitute(string, this, this, substitutionContext);
            } while (substitutionContext.totalSubstitutions > 0);
            valueSegment.segmentBuf.setLength(0);
            valueSegment.segmentBuf.append(string);
        }
        if (bl) {
            variable.reassembleCookedValueFromSegments();
        }
    }

    private int skipWhitespace(char[] cArray, int n) {
        while (n < cArray.length && Character.isWhitespace(cArray[n])) {
            ++n;
        }
        return n;
    }

    private Section makeNewSection(String string) {
        int n = this.nextSectionID();
        Section section = new Section(string, n);
        this.sectionsInOrder.add(section);
        this.sectionsByName.put(string, section);
        return section;
    }

    private synchronized int nextSectionID() {
        return ++this.nextSectionIDValue;
    }

    static {
        log = new Logger(Configuration.class);
    }

    private class ParseContext {
        Section currentSection = null;
        Variable currentVariable = null;
        int includeFileNestingLevel = 0;
        Set<String> openURLs = new HashSet<String>();

        ParseContext() {
        }
    }

    private class SubstitutionContext {
        Variable currentVariable;
        int totalSubstitutions = 0;

        SubstitutionContext(Variable variable) {
            this.currentVariable = variable;
        }
    }

    private static class Line {
        int number = 0;
        LineType type = LineType.COMMENT;
        XStringBuffer buffer = new XStringBuffer();

        Line() {
        }

        void newLine() {
            this.buffer.setLength(0);
        }
    }

    private static enum LineType {
        COMMENT,
        INCLUDE,
        SECTION,
        VARIABLE,
        BLANK;

    }
}

