/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.config;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.clapper.util.config.ConfigurationException;
import org.clapper.util.config.Section;
import org.clapper.util.config.Variable;
import org.clapper.util.text.TextUtil;

class ProgramSection
extends Section {
    static final String PROGRAM_NOW_VAR = "now";
    static final String PROGRAM_CWD_VAR = "cwd";
    static final String PROGRAM_CWD_URL_VAR = "cwd.url";

    ProgramSection(String string, int n) throws ConfigurationException {
        super(string, n);
        this.loadProgramSectionStaticValues();
    }

    @Override
    Variable getVariable(String string) throws ConfigurationException {
        Variable variable = string.startsWith(PROGRAM_NOW_VAR) ? new Variable(string, this.substituteDatetime(string), this, 0) : super.getVariable(string);
        return variable;
    }

    private void loadProgramSectionStaticValues() throws ConfigurationException {
        try {
            File file = new File(".");
            String string = file.getCanonicalPath();
            this.addVariable(PROGRAM_CWD_VAR, string);
            string = file.getCanonicalFile().toURI().toURL().toString();
            if (string.charAt(string.length() - 1) == '/') {
                string = string.substring(0, string.length() - 1);
            }
            this.addVariable(PROGRAM_CWD_URL_VAR, string);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException);
        }
    }

    private String substituteDatetime(String string) throws ConfigurationException {
        String string2 = "";
        Date date = new Date();
        if (string.equals(PROGRAM_NOW_VAR)) {
            string2 = date.toString();
        } else {
            char c = string.charAt(PROGRAM_NOW_VAR.length());
            String[] stringArray = TextUtil.split(string, c);
            if (stringArray.length != 2 && stringArray.length != 4) {
                throw new ConfigurationException("org.clapper.util.config.Bundle", "ProgramSection.badNowFieldCount", "Section \"{0}\", variable reference \"{1}\": Incorrect number of fields in extended version of \"{2}\" variable. Found {3} fields, expected either {4} or {5}.", new Object[]{this.getName(), string, PROGRAM_NOW_VAR, String.valueOf(stringArray.length), "2", "4"});
            }
            Locale locale = null;
            locale = stringArray.length == 2 ? Locale.getDefault() : new Locale(stringArray[2], stringArray[3]);
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[1], locale);
                string2 = simpleDateFormat.format(date);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigurationException(illegalArgumentException.toString());
            }
        }
        return string2;
    }
}

