/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clapper.util.config.ConfigurationException;
import org.clapper.util.config.Variable;
import org.clapper.util.text.XStringBuilder;

class Section {
    private String name;
    private List<String> variableNames = new ArrayList<String>();
    private Map<String, Variable> valueMap = new HashMap<String, Variable>();
    private int id = 0;

    Section(String string, int n) {
        this.name = string;
        this.id = n;
    }

    int getID() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    Collection<String> getVariableNames() {
        return Collections.unmodifiableList(this.variableNames);
    }

    Variable getVariable(String string) throws ConfigurationException {
        return this.valueMap.get(string);
    }

    Variable addVariable(String string, String string2) {
        Variable variable = new Variable(string, string2, this);
        this.valueMap.put(string, variable);
        this.variableNames.add(string);
        return variable;
    }

    Variable addVariable(String string, String string2, int n) {
        Variable variable = this.addVariable(string, string2);
        variable.setLineWhereDefined(n);
        return variable;
    }

    void addVariables(Map<String, String> map) {
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            this.addVariable(string, string2);
        }
    }

    protected Map<String, String> escapeEmbeddedBackslashes(Map<String, String> map) {
        XStringBuilder xStringBuilder = new XStringBuilder();
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            if (string2.indexOf(92) == -1) continue;
            xStringBuilder.clear();
            xStringBuilder.append(string2);
            xStringBuilder.replaceAll("\\", "\\\\\\\\");
            map.put(string, xStringBuilder.toString());
        }
        return map;
    }
}

