/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.config;

import java.util.ArrayList;
import java.util.Iterator;
import org.clapper.util.config.ConfigurationException;
import org.clapper.util.config.Section;
import org.clapper.util.config.ValueSegment;

class Variable {
    private static final char LITERAL_QUOTE = '\'';
    private static final char SUBST_QUOTE = '\"';
    private String name;
    private String cookedValue;
    private String[] cookedTokens = null;
    private String rawValue;
    private int lineWhereDefined = 0;
    private ValueSegment[] rawSegments = null;
    private ValueSegment[] cookedSegments = null;
    private Section parentSection;

    Variable(String string, String string2, Section section, int n) {
        this.name = string;
        this.parentSection = section;
        this.lineWhereDefined = n;
        this.setValue(string2);
    }

    Variable(String string, String string2, Section section) {
        this(string, string2, section, 0);
    }

    String getName() {
        return this.name;
    }

    Section getSection() {
        return this.parentSection;
    }

    String getRawValue() {
        return this.rawValue;
    }

    String getCookedValue() {
        return this.cookedValue;
    }

    String[] getCookedTokens() {
        return this.cookedTokens;
    }

    void setCookedValue(String string) {
        this.cookedValue = string;
    }

    ValueSegment[] getCookedSegments() throws ConfigurationException {
        this.segmentValue();
        return this.cookedSegments;
    }

    ValueSegment[] getRawSegments() throws ConfigurationException {
        this.segmentValue();
        return this.rawSegments;
    }

    void segmentValue() throws ConfigurationException {
        if (this.rawSegments == null) {
            int n;
            ArrayList<ValueSegment> arrayList = new ArrayList<ValueSegment>();
            ValueSegment valueSegment = new ValueSegment();
            char[] cArray = this.rawValue.toCharArray();
            char c = '\u0000';
            valueSegment.isLiteral = false;
            valueSegment.isWhiteSpaceEscaped = false;
            for (n = 0; n < cArray.length; ++n) {
                char c2 = cArray[n];
                switch (c2) {
                    case '\'': {
                        if (c == '\\' || valueSegment.isWhiteSpaceEscaped) {
                            valueSegment.append(c2);
                            break;
                        }
                        if (valueSegment.isLiteral) {
                            if (valueSegment.length() > 0) {
                                arrayList.add(valueSegment);
                                valueSegment = new ValueSegment();
                            }
                            valueSegment.isLiteral = false;
                            break;
                        }
                        if (valueSegment.length() > 0) {
                            arrayList.add(valueSegment);
                            valueSegment = new ValueSegment();
                        }
                        valueSegment.isLiteral = true;
                        break;
                    }
                    case '\"': {
                        if (c == '\\' || valueSegment.isLiteral) {
                            valueSegment.append(c2);
                            break;
                        }
                        if (valueSegment.isWhiteSpaceEscaped) {
                            if (valueSegment.length() > 0) {
                                arrayList.add(valueSegment);
                                valueSegment = new ValueSegment();
                            }
                            valueSegment.isWhiteSpaceEscaped = false;
                            break;
                        }
                        if (valueSegment.length() > 0) {
                            arrayList.add(valueSegment);
                            valueSegment = new ValueSegment();
                        }
                        valueSegment.isWhiteSpaceEscaped = true;
                        break;
                    }
                    default: {
                        valueSegment.append(c2);
                    }
                }
                c = c2;
            }
            if (valueSegment.isLiteral) {
                throw new ConfigurationException("Unmatched ' in variable \"" + this.name + "\"");
            }
            if (valueSegment.isWhiteSpaceEscaped) {
                throw new ConfigurationException("Unmatched \" in variable \"" + this.name + "\"");
            }
            if (valueSegment.length() > 0) {
                arrayList.add(valueSegment);
            }
            if (arrayList.size() > 0) {
                this.rawSegments = new ValueSegment[arrayList.size()];
                this.cookedSegments = new ValueSegment[arrayList.size()];
                n = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ValueSegment valueSegment2;
                    this.rawSegments[n] = valueSegment2 = (ValueSegment)iterator.next();
                    this.cookedSegments[n] = valueSegment2.makeCopy();
                    ++n;
                }
            }
        }
    }

    void reassembleCookedValueFromSegments() {
        if (this.cookedSegments != null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.cookedTokens = new String[this.cookedSegments.length];
            int n = 0;
            for (ValueSegment valueSegment : this.cookedSegments) {
                String string = valueSegment.segmentBuf.toString();
                stringBuilder.append(string);
                this.cookedTokens[n++] = string;
            }
            this.cookedValue = stringBuilder.toString();
        }
    }

    final void setValue(String string) {
        this.rawValue = string;
        this.cookedValue = string;
    }

    int getLineWhereDefined() {
        return this.lineWhereDefined;
    }

    void setLineWhereDefined(int n) {
        this.lineWhereDefined = n;
    }
}

