/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.html;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.text.TextUtil;
import org.clapper.util.text.XStringBufBase;
import org.clapper.util.text.XStringBuffer;
import org.clapper.util.text.XStringBuilder;

public final class HTMLUtil {
    private static final String BUNDLE_NAME = "org.clapper.util.html.HTMLUtil";
    private static ResourceBundle resourceBundle = null;
    private static Pattern entityPattern = null;

    private HTMLUtil() {
    }

    public static String stripHTMLTags(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = false;
        XStringBuilder xStringBuilder = new XStringBuilder();
        block4: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '<': {
                    bl = true;
                    continue block4;
                }
                case '>': {
                    if (bl) {
                        bl = false;
                        continue block4;
                    }
                    xStringBuilder.append(cArray[i]);
                    continue block4;
                }
                default: {
                    if (bl) continue block4;
                    xStringBuilder.append(cArray[i]);
                }
            }
        }
        return xStringBuilder.toString();
    }

    public static String escapeHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block5: for (char c : string.toCharArray()) {
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block5;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertCharacterEntities(String string) {
        Object object = HTMLUtil.class;
        synchronized (HTMLUtil.class) {
            block14: {
                try {
                    if (entityPattern == null) {
                        entityPattern = Pattern.compile("&(#?[^;\\s&]+);?");
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = new XStringBuffer();
            Matcher matcher = null;
            Object object2 = HTMLUtil.class;
            synchronized (HTMLUtil.class) {
                matcher = entityPattern.matcher(string);
                // ** MonitorExit[var3_5] (shouldn't be in output)
                while (true) {
                    object2 = null;
                    String string2 = null;
                    String string3 = null;
                    if (!matcher.find()) break;
                    object2 = matcher.group(1);
                    string2 = string.substring(0, matcher.start(1) - 1);
                    if (string2 != null) {
                        ((XStringBufBase)object).append(string2);
                    }
                    if (string.charAt(matcher.end() - 1) != ';') {
                        ((XStringBufBase)object).append(string.substring(matcher.start(), matcher.end()));
                        string3 = string.substring(matcher.end(1));
                    } else {
                        string3 = string.substring(matcher.end(1) + 1);
                        ((XStringBufBase)object).append(HTMLUtil.convertEntity((String)object2));
                    }
                    if (string3 == null) break;
                    string = string3;
                    matcher.reset(string);
                }
                if (string.length() > 0) {
                    ((XStringBufBase)object).append(string);
                }
                return ((XStringBufBase)object).toString();
            }
        }
    }

    public static String makeCharacterEntities(String string) {
        char c;
        Object object;
        ResourceBundle resourceBundle = HTMLUtil.getResourceBundle();
        HashMap<Character, String> hashMap = new HashMap<Character, String>();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        XStringBuffer xStringBuffer = new XStringBuffer();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            String string2 = resourceBundle.getString((String)object);
            c = string2.charAt(0);
            xStringBuffer.clear();
            xStringBuffer.append((String)object);
            xStringBuffer.delete("html_");
            hashMap.put(Character.valueOf(c), xStringBuffer.toString());
        }
        object = string.toCharArray();
        xStringBuffer.clear();
        for (int i = 0; i < ((char[])object).length; ++i) {
            c = object[i];
            String string3 = (String)hashMap.get(Character.valueOf(c));
            if (string3 == null) {
                if (!TextUtil.isPrintable(c)) {
                    xStringBuffer.append("&#");
                    xStringBuffer.append((Object)c);
                    xStringBuffer.append(';');
                    continue;
                }
                xStringBuffer.append(c);
                continue;
            }
            xStringBuffer.append('&');
            xStringBuffer.append(string3);
            xStringBuffer.append(';');
        }
        return xStringBuffer.toString();
    }

    public static String textFromHTML(String string) {
        String string2 = HTMLUtil.convertCharacterEntities(HTMLUtil.stripHTMLTags(string));
        char[] cArray = string2.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        block9: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\u2018': 
                case '\u2019': {
                    stringBuilder.append('\'');
                    continue block9;
                }
                case '\u201c': 
                case '\u201d': {
                    stringBuilder.append('\"');
                    continue block9;
                }
                case '\u2014': {
                    stringBuilder.append("--");
                    continue block9;
                }
                case '\u2011': 
                case '\u2013': {
                    stringBuilder.append('-');
                    continue block9;
                }
                case '\u200c': 
                case '\u200d': {
                    continue block9;
                }
                case '\u2122': {
                    stringBuilder.append("[TM]");
                    continue block9;
                }
                case '\u00a0': 
                case '\u2002': 
                case '\u2003': 
                case '\u2009': 
                case '\u200a': {
                    stringBuilder.append(' ');
                    continue block9;
                }
                default: {
                    stringBuilder.append(cArray[i]);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String convertEntity(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        ResourceBundle resourceBundle = HTMLUtil.getResourceBundle();
        if (string.charAt(0) == '#') {
            if (string.length() == 1) {
                stringBuilder.append('#');
            } else {
                boolean bl = string.length() > 2 && string.charAt(1) == 'x';
                boolean bl2 = false;
                try {
                    int n = bl ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
                    if (Character.isDefined((char)n)) {
                        stringBuilder.append((char)n);
                        bl2 = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!bl2) {
                    stringBuilder.append("&#");
                    if (bl) {
                        stringBuilder.append('x');
                    }
                    stringBuilder.append(string + ";");
                }
            }
        } else {
            try {
                stringBuilder.append(resourceBundle.getString("html_" + string));
            }
            catch (MissingResourceException missingResourceException) {
                stringBuilder.append("&" + string + ";");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getResourceBundle() {
        Class<HTMLUtil> clazz = HTMLUtil.class;
        synchronized (HTMLUtil.class) {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return resourceBundle;
        }
    }
}

