/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.clapper.util.io.CombinationFilterMode;

public class CombinationFileFilter
implements FileFilter {
    public static final CombinationFilterMode AND_FILTERS = CombinationFilterMode.AND_FILTERS;
    public static final CombinationFilterMode OR_FILTERS = CombinationFilterMode.OR_FILTERS;
    private List<FileFilter> filters = new LinkedList<FileFilter>();
    private CombinationFilterMode mode = AND_FILTERS;

    public CombinationFileFilter() {
        this(AND_FILTERS);
    }

    public CombinationFileFilter(CombinationFilterMode combinationFilterMode) {
        this.setMode(combinationFilterMode);
    }

    public CombinationFilterMode getMode() {
        return this.mode;
    }

    public void setMode(CombinationFilterMode combinationFilterMode) {
        this.mode = combinationFilterMode;
    }

    public void addFilter(FileFilter fileFilter) {
        this.filters.add(fileFilter);
    }

    public void removeFilter(FileFilter fileFilter) {
        this.filters.remove(fileFilter);
    }

    @Override
    public boolean accept(File file) {
        boolean bl = false;
        Iterator<FileFilter> iterator = this.filters.iterator();
        if (this.mode == AND_FILTERS) {
            bl = true;
            while (bl && iterator.hasNext()) {
                FileFilter fileFilter = iterator.next();
                bl = fileFilter.accept(file);
            }
        } else {
            bl = false;
            while (!bl && iterator.hasNext()) {
                FileFilter fileFilter = iterator.next();
                bl = fileFilter.accept(file);
            }
        }
        return bl;
    }
}

