/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.clapper.util.io.CombinationFilterMode;

public class CombinationFilenameFilter
implements FilenameFilter {
    public static final CombinationFilterMode AND_FILTERS = CombinationFilterMode.AND_FILTERS;
    public static final CombinationFilterMode OR_FILTERS = CombinationFilterMode.OR_FILTERS;
    private List<FilenameFilter> filters = new LinkedList<FilenameFilter>();
    private CombinationFilterMode mode = AND_FILTERS;

    public CombinationFilenameFilter() {
        this(AND_FILTERS);
    }

    public CombinationFilenameFilter(CombinationFilterMode combinationFilterMode) {
        this.setMode(combinationFilterMode);
    }

    public CombinationFilterMode getMode() {
        return this.mode;
    }

    public void setMode(CombinationFilterMode combinationFilterMode) {
        this.mode = combinationFilterMode;
    }

    public void addFilter(FilenameFilter filenameFilter) {
        this.filters.add(filenameFilter);
    }

    public void removeFilter(FilenameFilter filenameFilter) {
        this.filters.remove(filenameFilter);
    }

    @Override
    public boolean accept(File file, String string) {
        boolean bl = false;
        Iterator<FilenameFilter> iterator = this.filters.iterator();
        if (this.mode == AND_FILTERS) {
            bl = true;
            while (bl && iterator.hasNext()) {
                FilenameFilter filenameFilter = iterator.next();
                bl = filenameFilter.accept(file, string);
            }
        } else {
            bl = false;
            while (!bl && iterator.hasNext()) {
                FilenameFilter filenameFilter = iterator.next();
                bl = filenameFilter.accept(file, string);
            }
        }
        return bl;
    }
}

