/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class FileUtil {
    private FileUtil() {
    }

    public static boolean isAbsolutePath(String string) throws IOException {
        boolean bl = false;
        String string2 = System.getProperty("file.separator");
        if (string2.equals("/")) {
            bl = string.startsWith("/");
        } else if (string2.equals("\\")) {
            bl = Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' && string.charAt(2) == '\\';
        } else {
            throw new IOException("Can't determine operating system from file separator \"" + string2 + "\"");
        }
        return bl;
    }

    public static int copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        return FileUtil.copyStream(inputStream, outputStream, -1);
    }

    public static int copyStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        int n3 = 0;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = n > 0 ? new BufferedInputStream(inputStream, n) : new BufferedInputStream(inputStream);
        }
        if (!(outputStream instanceof BufferedOutputStream)) {
            outputStream = n > 0 ? new BufferedOutputStream(outputStream, n) : new BufferedOutputStream(outputStream);
        }
        while ((n2 = inputStream.read()) != -1) {
            outputStream.write(n2);
            ++n3;
        }
        outputStream.flush();
        return n3;
    }

    public static int copyReader(Reader reader, Writer writer, int n) throws IOException {
        int n2;
        if (!(reader instanceof BufferedReader)) {
            reader = n > 0 ? new BufferedReader(reader, n) : new BufferedReader(reader);
        }
        if (!(writer instanceof BufferedWriter)) {
            writer = n > 0 ? new BufferedWriter(writer, n) : new BufferedWriter(writer);
        }
        int n3 = 0;
        while ((n2 = reader.read()) != -1) {
            writer.write(n2);
            ++n3;
        }
        writer.flush();
        return n3;
    }

    public static int copyReader(Reader reader, Writer writer) throws IOException {
        return FileUtil.copyReader(reader, writer, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyFile(File file, File file2) throws IOException {
        int n = 0;
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            n = FileUtil.copyStream(fileInputStream, outputStream);
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return n;
    }

    public static int copyTextFile(File file, String string, File file2, String string2) throws IOException {
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        InputStreamReader inputStreamReader = string != null ? new InputStreamReader((InputStream)new FileInputStream(file), string) : new FileReader(file);
        OutputStreamWriter outputStreamWriter = string2 != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string2) : new FileWriter(file2);
        int n = FileUtil.copyReader(inputStreamReader, outputStreamWriter);
        ((Reader)inputStreamReader).close();
        ((Writer)outputStreamWriter).close();
        return n;
    }

    public static String getDefaultEncoding() {
        return Charset.defaultCharset().name();
    }

    public static String getFileNameExtension(File file) {
        return FileUtil.getFileNameExtension(file.getName());
    }

    public static String getFileNameExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n != -1 && n != string.length() - 1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static String getFileNameNoExtension(File file) {
        return FileUtil.getFileNameNoExtension(file.getAbsolutePath());
    }

    public static String getFileNameNoExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String dirname(String string) {
        return FileUtil.dirname(new File(string));
    }

    public static String dirname(File file) {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        return string.substring(0, n);
    }

    public static String basename(String string) {
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String basename(File file) {
        return FileUtil.basename(file.getName());
    }
}

