/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.clapper.util.io.JustifyStyle;
import org.clapper.util.text.TextUtil;

public class JustifyTextWriter
extends PrintWriter {
    public static final int DEFAULT_LINE_LENGTH = 80;
    private PrintWriter writer = null;
    private int lineLength = 80;
    private StringBuffer buffer = new StringBuffer();
    private JustifyStyle justification = JustifyStyle.LEFT_JUSTIFY;

    public JustifyTextWriter(Writer writer, JustifyStyle justifyStyle) {
        this(new PrintWriter(writer), justifyStyle, 80);
    }

    public JustifyTextWriter(PrintWriter printWriter, JustifyStyle justifyStyle) {
        this(printWriter, justifyStyle, 80);
    }

    public JustifyTextWriter(OutputStream outputStream, JustifyStyle justifyStyle) {
        this(outputStream, justifyStyle, 80);
    }

    public JustifyTextWriter(Writer writer, JustifyStyle justifyStyle, int n) {
        this(new PrintWriter(writer), justifyStyle, n);
    }

    public JustifyTextWriter(PrintWriter printWriter, JustifyStyle justifyStyle, int n) {
        super(printWriter);
        this.writer = printWriter;
        this.setLineLength(n);
        this.setJustification(justifyStyle);
    }

    public JustifyTextWriter(OutputStream outputStream, JustifyStyle justifyStyle, int n) {
        super(outputStream);
        this.writer = new PrintWriter(outputStream);
        this.setLineLength(n);
        this.setJustification(justifyStyle);
    }

    @Override
    public boolean checkError() {
        return super.checkError();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void flush() {
        this.flushBufferedLine();
        this.writer.flush();
    }

    public JustifyStyle getJustification() {
        return this.justification;
    }

    public void setJustification(JustifyStyle justifyStyle) {
        this.justification = justifyStyle;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Line length of " + n + " is negative.");
        }
        this.lineLength = n;
    }

    @Override
    public void print(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.write(bl2.toString());
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void print(double d) {
        Double d2 = new Double(d);
        this.write(d2.toString());
    }

    @Override
    public void print(float f) {
        Float f2 = new Float(f);
        this.write(f2.toString());
    }

    @Override
    public void print(int n) {
        Integer n2 = new Integer(n);
        this.write(n2.toString());
    }

    @Override
    public void print(long l) {
        Long l2 = new Long(l);
        this.write(l2.toString());
    }

    public void print(short s) {
        Short s2 = new Short(s);
        this.write(s2.toString());
    }

    @Override
    public void print(String string) {
        this.write(string);
    }

    @Override
    public void print(Object object) {
        this.write(object.toString());
    }

    @Override
    public void println() {
        this.flushBufferedLine();
        this.writer.println();
    }

    @Override
    public void println(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.println(bl2.toString());
    }

    @Override
    public void println(char c) {
        this.println(c);
    }

    @Override
    public void println(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.print(cArray[i]);
        }
        this.println();
    }

    @Override
    public void println(double d) {
        Double d2 = new Double(d);
        this.println(d2.toString());
    }

    @Override
    public void println(float f) {
        Float f2 = new Float(f);
        this.println(f2.toString());
    }

    @Override
    public void println(int n) {
        Integer n2 = new Integer(n);
        this.println(n2.toString());
    }

    @Override
    public void println(long l) {
        Long l2 = new Long(l);
        this.println(l2.toString());
    }

    public void println(short s) {
        Short s2 = new Short(s);
        this.println(s2.toString());
    }

    @Override
    public void println(String string) {
        this.print(string);
        this.println();
    }

    @Override
    public void println(Object object) {
        this.println(object.toString());
    }

    @Override
    public void write(int n) {
        this.buffer.append((char)n);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        while (n < cArray.length && n2 > 0) {
            this.write(cArray[n]);
            --n2;
            ++n;
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        char[] cArray = string.toCharArray();
        this.write(cArray, n, n2);
    }

    @Override
    public void write(String string) {
        char[] cArray = string.toCharArray();
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    private synchronized void flushBufferedLine() {
        if (this.buffer.length() > 0) {
            String string = this.buffer.toString();
            switch (this.justification) {
                case LEFT_JUSTIFY: {
                    this.writer.print(string);
                    break;
                }
                case RIGHT_JUSTIFY: {
                    this.writer.print(TextUtil.rightJustifyString(string, this.lineLength));
                    break;
                }
                case CENTER: {
                    this.writer.print(TextUtil.centerString(string, this.lineLength));
                }
            }
            this.buffer.setLength(0);
        }
    }
}

