/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MultipleRegexFilenameFilter
implements FilenameFilter {
    private Collection<Pattern> acceptPatterns = null;
    private Collection<Pattern> rejectPatterns = null;
    private int regexOptions;
    private MatchType matchType = MatchType.FILENAME;

    public MultipleRegexFilenameFilter(MatchType matchType) {
        this.matchType = matchType;
        this.regexOptions = 2;
        this.acceptPatterns = new ArrayList<Pattern>();
        this.rejectPatterns = new ArrayList<Pattern>();
    }

    public void addAcceptPattern(String string) throws PatternSyntaxException {
        this.acceptPatterns.add(Pattern.compile(string, this.regexOptions));
    }

    public void addRejectPattern(String string) throws PatternSyntaxException {
        this.rejectPatterns.add(Pattern.compile(string, this.regexOptions));
    }

    @Override
    public boolean accept(File file, String string) {
        Matcher matcher;
        boolean bl = false;
        boolean bl2 = false;
        if (this.matchType == MatchType.PATH) {
            string = file.getPath() + System.getProperty("file.separator") + string;
        }
        for (Pattern pattern : this.rejectPatterns) {
            matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            bl = false;
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (this.acceptPatterns.size() == 0) {
                bl = true;
            } else {
                for (Pattern pattern : this.acceptPatterns) {
                    matcher = pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public static enum MatchType {
        FILENAME,
        PATH;

    }
}

