/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.io.FileFilterMatchType;

public class RegexFileFilter
implements FileFilter {
    private FileFilterMatchType matchType = FileFilterMatchType.PATH;
    private Pattern pattern;

    public RegexFileFilter(String string, FileFilterMatchType fileFilterMatchType) throws PatternSyntaxException {
        this.matchType = fileFilterMatchType;
        this.pattern = Pattern.compile(string);
    }

    public RegexFileFilter(String string, int n, FileFilterMatchType fileFilterMatchType) throws PatternSyntaxException {
        this.matchType = fileFilterMatchType;
        this.pattern = Pattern.compile(string, n);
    }

    @Override
    public boolean accept(File file) {
        String string = null;
        switch (this.matchType) {
            case PATH: {
                string = file.getPath();
                break;
            }
            case FILENAME: {
                string = file.getName();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return this.pattern.matcher(string).find();
    }
}

