/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.io.FileFilterMatchType;

public class RegexFilenameFilter
implements FilenameFilter {
    private FileFilterMatchType matchType = FileFilterMatchType.PATH;
    private Pattern pattern;

    public RegexFilenameFilter(String string) throws PatternSyntaxException {
        this(string, FileFilterMatchType.FILENAME);
    }

    public RegexFilenameFilter(String string, FileFilterMatchType fileFilterMatchType) throws PatternSyntaxException {
        this.matchType = fileFilterMatchType;
        this.pattern = Pattern.compile(string);
    }

    public RegexFilenameFilter(String string, int n, FileFilterMatchType fileFilterMatchType) throws PatternSyntaxException {
        this.matchType = fileFilterMatchType;
        this.pattern = Pattern.compile(string, n);
    }

    @Override
    public boolean accept(File file, String string) {
        if (this.matchType == FileFilterMatchType.PATH) {
            string = new File(file, string).getPath();
        }
        return this.pattern.matcher(string).find();
    }
}

