/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.zip.GZIPOutputStream;
import org.clapper.util.io.FileUtil;
import org.clapper.util.io.IOExceptionExt;
import org.clapper.util.logging.Logger;
import org.clapper.util.text.UnixShellVariableSubstituter;
import org.clapper.util.text.VariableDereferencer;
import org.clapper.util.text.VariableSubstitutionException;

public class RollingFileWriter
extends PrintWriter {
    public static final String INDEX_PATTERN = "${n}";
    private static final String GZIP_EXTENSION = ".gz";
    private File primaryFile = null;
    private String filePattern = null;
    private String charsetName = null;
    private long maxRolledFileSize = 0L;
    private int maxRolledOverFiles = 0;
    private Compression compressionType = Compression.COMPRESS_BACKUPS;
    private RolloverCallback callback = null;
    private static String newline = System.getProperty("line.separator");
    private static Logger log = new Logger(RollingFileWriter.class);

    public RollingFileWriter(String string) throws IOExceptionExt {
        this(string, null, Compression.DONT_COMPRESS_BACKUPS);
    }

    public RollingFileWriter(String string, Compression compression) throws IOExceptionExt {
        this(string, null, compression);
    }

    public RollingFileWriter(String string, String string2, Compression compression) throws IOExceptionExt {
        this(string, string2, 0L, 0, compression, null);
    }

    public RollingFileWriter(String string, String string2, long l, int n) throws IOExceptionExt {
        this(string, string2, l, n, Compression.DONT_COMPRESS_BACKUPS, null);
    }

    public RollingFileWriter(String string, long l, int n, Compression compression) throws IOExceptionExt {
        this(string, null, l, n, compression, null);
    }

    public RollingFileWriter(String string, String string2, long l, int n, Compression compression, RolloverCallback rolloverCallback) throws IOExceptionExt {
        super(RollingFileWriter.openPrimaryFile(string, string2, n, compression, rolloverCallback), true);
        this.filePattern = string;
        this.compressionType = compression;
        this.primaryFile = RollingFileWriter.resolveFilePattern(string, null, n, null);
        this.callback = rolloverCallback;
        this.charsetName = string2;
        this.compressionType = compression;
        this.maxRolledFileSize = l;
        this.maxRolledOverFiles = n;
    }

    public String getPathName() {
        return this.primaryFile.getPath();
    }

    @Override
    public synchronized void flush() {
        super.flush();
    }

    @Override
    public synchronized void println() {
        super.println();
        try {
            this.checkForRollOver();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void println(boolean bl) {
        this.print(bl);
        this.println();
    }

    @Override
    public synchronized void println(char c) {
        this.print(c);
        this.println();
    }

    @Override
    public synchronized void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    @Override
    public synchronized void println(double d) {
        this.print(d);
        this.println();
    }

    @Override
    public synchronized void println(float f) {
        this.print(f);
        this.println();
    }

    @Override
    public synchronized void println(int n) {
        this.print(n);
        this.println();
    }

    @Override
    public synchronized void println(long l) {
        super.print(l);
        this.println();
    }

    public synchronized void println(short s) {
        super.print(s);
        this.println();
    }

    @Override
    public synchronized void println(String string) {
        super.print(string);
        this.println();
    }

    @Override
    public synchronized void println(Object object) {
        super.print(object);
        this.println();
    }

    private void printlnNoRoll(String string) {
        super.write(string);
        super.write(newline);
        super.flush();
    }

    private synchronized void checkForRollOver() throws IOExceptionExt {
        long l;
        if (this.maxRolledFileSize > 0L && this.maxRolledOverFiles > 0 && (l = this.primaryFile.length()) >= this.maxRolledFileSize) {
            log.debug("fileSize=" + l + ", maxSize=" + this.maxRolledFileSize + " -> must roll files over.");
            this.out = RollingFileWriter.rollFilesOver(this.primaryFile, this.filePattern, this.charsetName, this.maxRolledOverFiles, this.compressionType, this, this.callback);
        }
    }

    private static void renameFile(File file, File file2) throws IOExceptionExt {
        log.debug("Moving file \"" + file.getName() + "\" to \"" + file2.getName() + "\"");
        try {
            if (!file.renameTo(file2)) {
                throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantMoveFile", "Unable to move file \"{0}\" to \"{1}\"", new Object[]{file.getPath(), file2.getPath()});
            }
        }
        catch (SecurityException securityException) {
            throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantMoveFile", "Unable to move file \"{0}\" to \"{1}\"", new Object[]{file.getPath(), file2.getPath()}, securityException);
        }
    }

    private static Writer openPrimaryFile(String string, String string2, int n, Compression compression, RolloverCallback rolloverCallback) throws IOExceptionExt {
        File file = RollingFileWriter.resolveFilePattern(string, null, n, null);
        log.debug("primaryFile=" + file.getPath());
        Writer writer = null;
        if (file.exists()) {
            log.debug("Primary file exists. Rolling...");
            writer = RollingFileWriter.rollFilesOver(file, string, string2, n, compression, null, rolloverCallback);
        } else {
            log.debug("Primary file does not exist.");
            writer = RollingFileWriter.openFile(file, string2);
        }
        return writer;
    }

    private static Writer openFile(File file, String string) throws IOExceptionExt {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = string != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), string) : new FileWriter(file);
        }
        catch (IOException iOException) {
            throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantOpenFile", "Unable to open file \"{0}\"", new Object[]{file.getPath()});
        }
        return outputStreamWriter;
    }

    private static File resolveFilePattern(String string, Integer n, int n2, Compression compression) throws IOExceptionExt {
        try {
            BackupIndexDereferencer backupIndexDereferencer = new BackupIndexDereferencer(n, n2);
            UnixShellVariableSubstituter unixShellVariableSubstituter = new UnixShellVariableSubstituter();
            unixShellVariableSubstituter.setHonorEscapes(false);
            String string2 = unixShellVariableSubstituter.substitute(string, backupIndexDereferencer, null, string);
            if (!backupIndexDereferencer.patternIsLegal()) {
                throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.badPattern", "File pattern \"{0}\" is missing the \"$'{n}'\" marker.", new Object[]{string});
            }
            if (compression == Compression.COMPRESS_BACKUPS) {
                string2 = string2 + GZIP_EXTENSION;
            }
            return new File(string2);
        }
        catch (VariableSubstitutionException variableSubstitutionException) {
            throw new IOExceptionExt(variableSubstitutionException);
        }
    }

    private static Writer rollFilesOver(File file, String string, String string2, int n, Compression compression, RollingFileWriter rollingFileWriter, RolloverCallback rolloverCallback) throws IOExceptionExt {
        File file2;
        Object object;
        int n2;
        log.debug("rolling \"" + file.getPath() + "\"");
        int n3 = -1;
        int n4 = n - 1;
        for (n2 = 0; n2 < n; ++n2) {
            object = RollingFileWriter.resolveFilePattern(string, n2, n, compression);
            if (((File)object).exists()) continue;
            n3 = n2;
            break;
        }
        log.debug("firstGap(1)=" + n3);
        if (n3 == -1) {
            n3 = n4;
        }
        log.debug("firstGap(2)=" + n3);
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            object = RollingFileWriter.resolveFilePattern(string, n2 + 1, n, compression);
            file2 = RollingFileWriter.resolveFilePattern(string, n2, n, compression);
            if (((File)object).exists()) {
                log.debug("Removing file \"" + ((File)object).getPath() + "\"");
                try {
                    ((File)object).delete();
                }
                catch (SecurityException securityException) {
                    throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantDeleteFile", "Can't delete file \"{0}\"", new Object[]{((File)object).getPath()});
                }
            }
            RollingFileWriter.renameFile(file2, (File)object);
        }
        object = null;
        if (rollingFileWriter != null) {
            if (rolloverCallback != null && (object = rolloverCallback.getRollOverMessage()) != null) {
                log.debug("Appending roll-over message \"" + (String)object + "\" to full primary file \"" + file + "\"");
                rollingFileWriter.printlnNoRoll((String)object);
            }
            log.debug("Closing full primary file \"" + file + "\".");
            rollingFileWriter.flush();
            rollingFileWriter.close();
        }
        file2 = RollingFileWriter.resolveFilePattern(string, 0, n, null);
        RollingFileWriter.renameFile(file, file2);
        if (compression == Compression.COMPRESS_BACKUPS) {
            RollingFileWriter.gzipFile(file2);
        }
        log.debug("Reopening \"" + file + "\"");
        Writer writer = RollingFileWriter.openFile(file, string2);
        if (object != null) {
            try {
                log.debug("Writing roll-over message \"" + (String)object + "\" to top of new primary file \"" + file + "\"");
                writer.write((String)object);
                writer.write(newline);
                writer.flush();
            }
            catch (IOException iOException) {
                throw new IOExceptionExt(iOException);
            }
        }
        return writer;
    }

    private static void gzipFile(File file) throws IOExceptionExt {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file.getPath() + GZIP_EXTENSION));
            FileUtil.copyStream(fileInputStream, gZIPOutputStream);
            ((InputStream)fileInputStream).close();
            ((OutputStream)gZIPOutputStream).close();
            if (!file.delete()) {
                throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantDeleteFile", "Can't delete file \"{0}\"", new Object[]{file.getPath()});
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionExt("org.clapper.util.io.Bundle", "RollingFileWriter.cantGzipFile", "Can't gzip file \"{0}\"", new Object[]{file.getPath()});
        }
    }

    private static class BackupIndexDereferencer
    implements VariableDereferencer {
        private Integer index;
        private DecimalFormat indexFormat;
        private boolean legal = false;

        BackupIndexDereferencer(Integer n, int n2) {
            this.index = n;
            this.indexFormat = this.indexFormat;
            String string = String.valueOf(n2 - 1);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                stringBuilder.append('0');
            }
            this.indexFormat = new DecimalFormat(stringBuilder.toString());
        }

        @Override
        public String getVariableValue(String string, Object object) throws VariableSubstitutionException {
            if (!string.equals("n")) {
                throw new VariableSubstitutionException("org.clapper.util.io.Bundle", "RollingFileWriter.unknownVariable", "Unknown variable \"{0}\" in file pattern \"{1}\"", new Object[]{string, object});
            }
            this.legal = true;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.index != null) {
                stringBuilder.append(".");
                stringBuilder.append(this.indexFormat.format(this.index));
            }
            return stringBuilder.toString();
        }

        boolean patternIsLegal() {
            return this.legal;
        }
    }

    public static enum Compression {
        COMPRESS_BACKUPS,
        DONT_COMPRESS_BACKUPS;

    }

    public static interface RolloverCallback {
        public String getRollOverMessage();
    }
}

