/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;

public class WordWrapWriter
extends PrintWriter {
    public static final int DEFAULT_LINE_LENGTH = 80;
    static final char NEWLINE_MARKER = '\n';
    private PrintWriter writer = null;
    private int lineLength = 80;
    private StringBuffer buffer = null;
    private int indentation = 0;
    private char indentChar = (char)32;
    private String prefix = null;
    private boolean emittedPrefix = false;

    public WordWrapWriter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public WordWrapWriter(PrintWriter printWriter) {
        this(printWriter, 80);
    }

    public WordWrapWriter(OutputStream outputStream) {
        this(outputStream, 80);
    }

    public WordWrapWriter(Writer writer, int n) {
        this(new PrintWriter(writer), n);
    }

    public WordWrapWriter(PrintWriter printWriter, int n) {
        this(printWriter, n, 0);
    }

    public WordWrapWriter(OutputStream outputStream, int n) {
        this(outputStream, n, 0);
    }

    public WordWrapWriter(Writer writer, int n, int n2) {
        this(new PrintWriter(writer), n, n2);
    }

    public WordWrapWriter(PrintWriter printWriter, int n, int n2) {
        super(printWriter);
        this.writer = printWriter;
        this.setLineLength(n);
        this.setIndentation(n2);
    }

    public WordWrapWriter(OutputStream outputStream, int n, int n2) {
        this(new OutputStreamWriter(outputStream), n, n2);
    }

    @Override
    public boolean checkError() {
        return super.checkError();
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public synchronized void flush() {
        if (this.buffer != null && this.buffer.length() > 0) {
            this.flushBuffer(this.buffer);
            this.buffer.setLength(0);
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public char getIndentationChar() {
        return this.indentChar;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setIndentation(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indentation of " + n + " is negative.");
        }
        this.indentation = n;
    }

    public void setIndentationChar(char c) {
        this.indentChar = c;
    }

    public void setLineLength(int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Line length of " + n + " is negative.");
        }
        this.lineLength = n;
    }

    public String setPrefix(String string) {
        String string2 = this.prefix;
        this.prefix = string;
        this.emittedPrefix = false;
        return string2;
    }

    @Override
    public void print(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.write(bl2.toString());
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void print(double d) {
        Double d2 = new Double(d);
        this.write(d2.toString());
    }

    @Override
    public void print(float f) {
        Float f2 = new Float(f);
        this.write(f2.toString());
    }

    @Override
    public void print(int n) {
        Integer n2 = new Integer(n);
        this.write(n2.toString());
    }

    @Override
    public void print(long l) {
        Long l2 = new Long(l);
        this.write(l2.toString());
    }

    public void print(short s) {
        Short s2 = new Short(s);
        this.write(s2.toString());
    }

    @Override
    public void print(String string) {
        this.write(string);
    }

    @Override
    public void print(Object object) {
        this.write(object.toString());
    }

    @Override
    public void println() {
        this.write(10);
    }

    @Override
    public void println(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.println(bl2.toString());
    }

    @Override
    public void println(char c) {
        this.println(c);
    }

    @Override
    public void println(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.print(cArray[i]);
        }
        this.println();
    }

    @Override
    public void println(double d) {
        Double d2 = new Double(d);
        this.println(d2.toString());
    }

    @Override
    public void println(float f) {
        Float f2 = new Float(f);
        this.println(f2.toString());
    }

    @Override
    public void println(int n) {
        Integer n2 = new Integer(n);
        this.println(n2.toString());
    }

    @Override
    public void println(long l) {
        Long l2 = new Long(l);
        this.println(l2.toString());
    }

    public void println(short s) {
        Short s2 = new Short(s);
        this.println(s2.toString());
    }

    @Override
    public void println(String string) {
        this.print(string);
        this.println();
    }

    @Override
    public void println(Object object) {
        this.println(object.toString());
    }

    @Override
    public synchronized void write(int n) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(this.lineLength * 2);
        }
        this.buffer.append((char)n);
        if (n == 10) {
            this.flush();
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        while (n < cArray.length && n2 > 0) {
            this.write(cArray[n]);
            --n2;
            ++n;
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        char[] cArray = string.toCharArray();
        this.write(cArray, n, n2);
    }

    @Override
    public void write(String string) {
        char[] cArray = string.toCharArray();
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    private void flushBuffer(StringBuffer stringBuffer) {
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n", true);
        String string = this.prefix == null ? "" : this.prefix;
        int n = 0;
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1 && string2.charAt(0) == '\n') {
                this.writer.println();
                bl = true;
                n = 0;
                continue;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                int n2 = string3.length();
                if (n2 + n + 1 > this.lineLength && !bl) {
                    this.writer.println();
                    n = 0;
                    bl = true;
                }
                if (bl) {
                    n += this.indent();
                    bl = false;
                } else {
                    this.writer.print(' ');
                    ++n;
                }
                this.writer.print(string3);
                n += n2;
            }
        }
        if (n > 0) {
            this.writer.println();
        }
        this.writer.flush();
    }

    private int indent() {
        int n;
        int n2 = 0;
        if (this.prefix != null) {
            int n3 = this.prefix.length();
            if (!this.emittedPrefix) {
                this.writer.write(this.prefix);
                this.emittedPrefix = true;
            } else {
                for (n = 0; n < n3; ++n) {
                    this.writer.write(this.indentChar);
                }
            }
            n2 += n3;
        }
        for (n = 0; n < this.indentation; ++n) {
            this.writer.write(this.indentChar);
            ++n2;
        }
        return n2;
    }
}

