/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class XMLWriter
extends Writer {
    private PrintWriter out;
    private char prev = '\u0000';
    private int indentation = 0;
    private boolean lastWasPI = true;

    public XMLWriter(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public XMLWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        while (n < n2) {
            char c = cArray[n++];
            switch (c) {
                case '<': {
                    break;
                }
                case '>': {
                    if (this.prev == '/') {
                        --this.indentation;
                    }
                    this.lastWasPI = this.prev == '?';
                    this.out.write(c);
                    this.out.write(10);
                    break;
                }
                default: {
                    if (this.prev == '<') {
                        if (c == '/') {
                            --this.indentation;
                        } else if (!this.lastWasPI) {
                            ++this.indentation;
                        }
                        this.indent(this.indentation);
                        this.out.write(this.prev);
                    }
                    this.out.write(c);
                }
            }
            this.prev = c;
        }
    }

    private void indent(int n) throws IOException {
        while (n-- > 0) {
            this.out.write("    ");
        }
    }
}

