/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.clapper.util.io.FileUtil;

public class Zipper {
    private static final int OUTPUT_BUF_SIZE = 8192;
    private File zipFile = null;
    private boolean isJar = false;
    private ZipOutputStream zipStream = null;
    private Manifest manifest = null;
    private boolean flatten = false;
    private int totalEntriesWritten = 0;
    private Set<String> tableOfContents = new HashSet<String>();

    public Zipper(String string, boolean bl) throws IOException {
        this(new File(string), bl);
    }

    public Zipper(String string, Manifest manifest, boolean bl) throws IOException {
        this(new File(string), manifest, bl);
    }

    public Zipper(File file, boolean bl) throws IOException {
        this(file, null, bl);
    }

    public Zipper(File file, Manifest manifest, boolean bl) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("File \"" + file.getPath() + "\" is a directory.");
        }
        this.zipFile = file;
        this.flatten = bl;
        String string = FileUtil.getFileNameExtension(file.getName());
        if (string.equals(".jar")) {
            this.isJar = true;
            this.manifest = manifest;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void close() throws IOException {
        if (this.zipStream != null) {
            this.zipStream.close();
            this.zipStream = null;
        }
    }

    public synchronized boolean containsEntry(String string) {
        return this.tableOfContents.contains(this.convertName(string));
    }

    public File getFile() {
        return this.zipFile;
    }

    public int getTotalEntries() {
        return this.totalEntriesWritten;
    }

    public void put(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File \"" + file.getPath() + "\" does not exist.");
        }
        if (!file.isDirectory() && !file.canRead()) {
            throw new IOException("Cannot read file \"" + file.getPath() + "\".");
        }
        if (file.isDirectory()) {
            this.writeDirectory(file);
        } else {
            this.write(file);
        }
    }

    public void put(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.write(fileInputStream, string);
        fileInputStream.close();
    }

    public void put(String string) throws IOException {
        this.put(new File(string));
    }

    public void put(InputStream inputStream, String string) throws IOException {
        this.write(inputStream, string);
    }

    public void put(byte[] byArray, String string) throws IOException {
        this.write(byArray, string);
    }

    public void put(URL uRL, String string) throws IOException {
        this.write(uRL.openConnection().getInputStream(), string);
    }

    private void write(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.write(fileInputStream, file.getPath());
        fileInputStream.close();
    }

    private void write(InputStream inputStream, String string) throws IOException {
        int n;
        this.open();
        string = this.convertName(string);
        ZipEntry zipEntry = this.getZipEntry(string);
        this.zipStream.putNextEntry(zipEntry);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            this.zipStream.write(byArray, 0, n);
        }
        this.zipStream.closeEntry();
        ++this.totalEntriesWritten;
        this.tableOfContents.add(string);
    }

    private void write(byte[] byArray, String string) throws IOException {
        this.open();
        string = this.convertName(string);
        ZipEntry zipEntry = this.getZipEntry(string);
        this.zipStream.putNextEntry(zipEntry);
        this.zipStream.write(byArray, 0, byArray.length);
        this.zipStream.closeEntry();
        ++this.totalEntriesWritten;
        this.tableOfContents.add(string);
    }

    public void writeDirectory(File file) throws IOException {
        this.open();
        String string = this.convertName(file.getPath());
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        ZipEntry zipEntry = this.getZipEntry(string);
        this.zipStream.putNextEntry(zipEntry);
        this.zipStream.closeEntry();
        ++this.totalEntriesWritten;
        this.tableOfContents.add(string);
    }

    private String convertName(String string) {
        if (this.flatten) {
            string = new File(string).getName();
        } else {
            File[] fileArray = File.listRoots();
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].getPath();
                if (!string.toLowerCase().startsWith(string2.toLowerCase())) continue;
                string = string.substring(string2.length());
                break;
            }
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
        }
        return string;
    }

    private ZipEntry getZipEntry(String string) {
        return this.isJar ? new ZipEntry(string) : new JarEntry(string);
    }

    private synchronized void open() throws IOException {
        if (this.zipStream == null) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.zipFile));
            this.zipStream = this.isJar ? (this.manifest != null ? new JarOutputStream((OutputStream)bufferedOutputStream, this.manifest) : new JarOutputStream(bufferedOutputStream)) : new ZipOutputStream(bufferedOutputStream);
        }
    }
}

