/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JavaUtilLoggingTextFormatter
extends Formatter {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    @Override
    public String format(LogRecord logRecord) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string = logRecord.getLoggerName();
        Throwable throwable = logRecord.getThrown();
        String string2 = super.formatMessage(logRecord);
        printWriter.print(DATE_FORMAT.format(new Date(logRecord.getMillis())));
        printWriter.print(' ');
        printWriter.print(logRecord.getLevel().toString());
        printWriter.print(" (");
        int n = string.lastIndexOf(".");
        if (n != -1 && n < string.length() - 1) {
            string = string.substring(n + 1);
        }
        printWriter.print(string);
        printWriter.print(") ");
        if (string2 != null && string2.trim().length() > 0) {
            printWriter.println(string2);
        }
        if (throwable != null) {
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }
}

