/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.logging;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.clapper.util.logging.LogLevel;

public class Logger {
    public static LogLevel LEVEL_DEBUG = LogLevel.DEBUG;
    public static LogLevel LEVEL_ERROR = LogLevel.ERROR;
    public static LogLevel LEVEL_FATAL = LogLevel.FATAL;
    public static LogLevel LEVEL_INFO = LogLevel.INFO;
    public static LogLevel LEVEL_TRACE = LogLevel.TRACE;
    public static LogLevel LEVEL_WARNING = LogLevel.WARNING;
    private Log realLogger = null;
    private String className = null;
    private static Collection<Logger> loggers = new ArrayList<Logger>();
    private static boolean enabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger(String string) {
        this.className = string;
        Collection<Logger> collection = loggers;
        synchronized (collection) {
            loggers.add(this);
            if (enabled) {
                Logger.enableLogger(this);
            }
        }
    }

    public Logger(Class clazz) {
        this(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableLogging() throws UnsupportedOperationException {
        Collection<Logger> collection = loggers;
        synchronized (collection) {
            if (!enabled) {
                for (Logger logger : loggers) {
                    Logger.enableLogger(logger);
                }
                enabled = true;
            }
        }
    }

    public void debug(Object object) {
        if (this.realLogger != null) {
            this.realLogger.debug((Object)object.toString());
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (this.realLogger != null) {
            this.realLogger.debug((Object)object.toString(), throwable);
        }
    }

    public void error(Object object) {
        if (this.realLogger != null) {
            this.realLogger.error((Object)object.toString());
        }
    }

    public void error(Object object, Throwable throwable) {
        if (this.realLogger != null) {
            this.realLogger.error((Object)object.toString(), throwable);
        }
    }

    public void fatal(Object object) {
        if (this.realLogger != null) {
            this.realLogger.fatal((Object)object.toString());
        }
    }

    public void fatal(Object object, Throwable throwable) {
        if (this.realLogger != null) {
            this.realLogger.fatal((Object)object.toString(), throwable);
        }
    }

    public void info(Object object) {
        if (this.realLogger != null) {
            this.realLogger.info((Object)object.toString());
        }
    }

    public void info(Object object, Throwable throwable) {
        if (this.realLogger != null) {
            this.realLogger.info((Object)object.toString(), throwable);
        }
    }

    public void message(LogLevel logLevel, Object object) {
        switch (logLevel) {
            case DEBUG: {
                this.debug(object);
                break;
            }
            case ERROR: {
                this.error(object);
                break;
            }
            case FATAL: {
                this.fatal(object);
                break;
            }
            case INFO: {
                this.info(object);
                break;
            }
            case TRACE: {
                this.trace(object);
                break;
            }
            case WARNING: {
                this.warn(object);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void message(LogLevel logLevel, Object object, Throwable throwable) {
        switch (logLevel) {
            case DEBUG: {
                this.debug(object, throwable);
                break;
            }
            case ERROR: {
                this.error(object, throwable);
                break;
            }
            case FATAL: {
                this.fatal(object, throwable);
                break;
            }
            case INFO: {
                this.info(object, throwable);
                break;
            }
            case TRACE: {
                this.trace(object, throwable);
                break;
            }
            case WARNING: {
                this.warn(object, throwable);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void trace(Object object) {
        if (this.realLogger != null) {
            this.realLogger.trace((Object)object.toString());
        }
    }

    public void trace(Object object, Throwable throwable) {
        if (this.realLogger != null) {
            this.realLogger.trace((Object)object.toString(), throwable);
        }
    }

    public void warn(Object object) {
        if (this.realLogger != null) {
            this.realLogger.warn((Object)object.toString());
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (this.realLogger != null) {
            this.realLogger.warn((Object)object.toString(), throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.realLogger == null ? false : this.realLogger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.realLogger == null ? false : this.realLogger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.realLogger == null ? false : this.realLogger.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.realLogger == null ? false : this.realLogger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.realLogger == null ? false : this.realLogger.isTraceEnabled();
    }

    public boolean isWarningEnabled() {
        return this.realLogger == null ? false : this.realLogger.isWarnEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enableLogger(Logger logger) throws UnsupportedOperationException {
        Logger logger2 = logger;
        synchronized (logger2) {
            if (logger.realLogger == null) {
                logger.realLogger = LogFactory.getLog((String)logger.className);
            }
        }
    }
}

