/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.mail;

import java.util.Collection;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.clapper.util.mail.EmailException;

public class EmailAddress
implements Cloneable,
Comparable {
    private InternetAddress emailAddress = null;

    EmailAddress(InternetAddress internetAddress) throws EmailException {
        this.emailAddress = internetAddress;
    }

    public EmailAddress(String string) throws EmailException {
        try {
            InternetAddress[] internetAddressArray = InternetAddress.parse((String)string);
            if (internetAddressArray.length != 1) {
                throw new EmailException("\"" + string + "\" is an improperly formed email address");
            }
            this.emailAddress = internetAddressArray[0];
        }
        catch (AddressException addressException) {
            throw new EmailException("\"" + string + "\" is an improperly formed email address", addressException);
        }
    }

    public EmailAddress(EmailAddress emailAddress) throws EmailException {
        this(emailAddress.getInternetAddress());
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getAddress().hashCode();
    }

    public int compareTo(Object object) {
        EmailAddress emailAddress = (EmailAddress)object;
        return this.getAddress().compareToIgnoreCase(emailAddress.getAddress());
    }

    public String getAddress() {
        return this.emailAddress.getAddress();
    }

    public String getPersonalName() {
        return this.emailAddress.getPersonal();
    }

    public static int parse(String string, Collection<EmailAddress> collection) throws EmailException {
        int n = 0;
        try {
            InternetAddress[] internetAddressArray = InternetAddress.parse((String)string, (boolean)true);
            n = internetAddressArray.length;
            for (int i = 0; i < n; ++i) {
                collection.add(new EmailAddress(internetAddressArray[i]));
            }
        }
        catch (AddressException addressException) {
            throw new EmailException("One or more email addresses in the string \"" + string + "\" cannot be parsed.", addressException);
        }
        return n;
    }

    public String toString() {
        return this.emailAddress.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        EmailAddress emailAddress = null;
        try {
            emailAddress = new EmailAddress(this);
        }
        catch (EmailException emailException) {
            emailAddress = null;
        }
        return emailAddress;
    }

    InternetAddress getInternetAddress() {
        return this.emailAddress;
    }
}

