/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.mail;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.clapper.util.io.FileUtil;
import org.clapper.util.logging.Logger;
import org.clapper.util.mail.EmailAddress;
import org.clapper.util.mail.EmailException;
import org.clapper.util.mail.MultipartSubtype;
import org.clapper.util.mail.StringDataSource;
import org.clapper.util.misc.MIMETypeUtil;

public class EmailMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final MultipartSubtype MULTIPART_MIXED = new MultipartSubtype("mixed");
    public static final MultipartSubtype MULTIPART_ALTERNATIVE = new MultipartSubtype("alternative");
    private static final String[] CUSTOM_HEADERS = new String[]{"X-Mailer: " + EmailMessage.class.getName()};
    private static final SimpleDateFormat GENERATED_FILE_NAME_FMT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String DEFAULT_TEXT_MIME_TYPE = "text/plain";
    private EmailAddress sender = null;
    private MimeBodyPart textPart = null;
    private List<String> additionalHeaders = new LinkedList<String>();
    private List<MimeBodyPart> attachments = new ArrayList<MimeBodyPart>();
    private List<EmailAddress> to = new ArrayList<EmailAddress>();
    private List<EmailAddress> cc = new ArrayList<EmailAddress>();
    private List<EmailAddress> bcc = new ArrayList<EmailAddress>();
    private String subject = "";
    private MultipartSubtype multipartSubtype = MULTIPART_MIXED;
    private Collection<File> temporaryFiles = new ArrayList<File>();
    private static final Logger log = new Logger(EmailMessage.class);

    public EmailMessage() {
        this.initAdditionalHeaders();
    }

    public EmailMessage(String string) throws EmailException {
        this();
        this.sender = new EmailAddress(string);
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    public void clear() {
        this.clearTo();
        this.clearBcc();
        this.clearCc();
        this.clearAllAttachments();
        this.clearText();
        this.initAdditionalHeaders();
        this.sender = null;
        this.multipartSubtype = MULTIPART_MIXED;
        Iterator<File> iterator = this.temporaryFiles.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                log.debug("Deleting temporary file \"" + file.getPath() + "\"");
                if (!file.delete()) {
                    log.error("Failed to delete \"" + file.getPath() + "\"");
                }
            }
            catch (Exception exception) {
                log.error("Failed to delete \"" + file.getPath() + "\"", exception);
            }
            iterator.remove();
        }
        assert (this.temporaryFiles.size() == 0);
    }

    public void addHeader(String string, String string2) {
        string = string + ": ";
        Iterator<String> iterator = this.additionalHeaders.iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            if (!string3.startsWith(string)) continue;
            iterator.remove();
        }
        this.additionalHeaders.add(string + string2);
    }

    public void addTo(String string) throws EmailException {
        this.addEmailAddress(new EmailAddress(string), this.to);
    }

    public void addTo(EmailAddress emailAddress) throws EmailException {
        this.addEmailAddress(emailAddress, this.to);
    }

    public void addTo(String[] stringArray) throws EmailException {
        this.addEmailAddresses(stringArray, this.to);
    }

    public void addTo(Collection<?> collection) throws EmailException {
        this.addEmailAddresses(collection, this.to);
    }

    public Collection<EmailAddress> getTo() throws EmailException {
        return this.getEmailAddresses(this.to);
    }

    public void clearTo() {
        this.to.clear();
    }

    public void addCc(String string) throws EmailException {
        this.addEmailAddress(new EmailAddress(string), this.cc);
    }

    public void addCc(EmailAddress emailAddress) throws EmailException {
        this.addEmailAddress(emailAddress, this.cc);
    }

    public void addCc(String[] stringArray) throws EmailException {
        this.addEmailAddresses(stringArray, this.cc);
    }

    public void addCc(Collection<?> collection) throws EmailException {
        this.addEmailAddresses(collection, this.cc);
    }

    public Collection<EmailAddress> getCc() throws EmailException {
        return this.getEmailAddresses(this.cc);
    }

    public void clearCc() {
        this.cc.clear();
    }

    public void addBcc(String string) throws EmailException {
        this.addEmailAddress(new EmailAddress(string), this.bcc);
    }

    public void addBcc(EmailAddress emailAddress) throws EmailException {
        this.addEmailAddress(emailAddress, this.bcc);
    }

    public void addBcc(String[] stringArray) throws EmailException {
        this.addEmailAddresses(stringArray, this.bcc);
    }

    public void addBcc(Collection<?> collection) throws EmailException {
        this.addEmailAddresses(collection, this.bcc);
    }

    public Collection<EmailAddress> getBcc() throws EmailException {
        return this.getEmailAddresses(this.bcc);
    }

    public void clearBcc() {
        this.bcc.clear();
    }

    public void clearAllRecipients() {
        this.clearTo();
        this.clearCc();
        this.clearBcc();
    }

    public void setMultipartSubtype(MultipartSubtype multipartSubtype) throws EmailException {
        if (this.attachments.size() > 0) {
            throw new EmailException("Can't set multipart subtype once message has attachments.");
        }
        this.multipartSubtype = multipartSubtype;
    }

    public MultipartSubtype getMultipartSubtype() {
        return this.multipartSubtype;
    }

    public String getText() throws EmailException {
        String string = null;
        try {
            if (this.textPart != null) {
                int n;
                InputStreamReader inputStreamReader = new InputStreamReader(this.textPart.getInputStream());
                StringWriter stringWriter = new StringWriter();
                while ((n = ((Reader)inputStreamReader).read()) != -1) {
                    stringWriter.write(n);
                }
                string = stringWriter.toString();
            }
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot retrieve text portion of email message", messagingException);
        }
        catch (IOException iOException) {
            throw new EmailException("Cannot retrieve text portion of email message", iOException);
        }
        return string;
    }

    public void setText(String string) throws EmailException {
        this.setText(string, null, DEFAULT_TEXT_MIME_TYPE);
    }

    public void setText(String string, String string2) throws EmailException {
        this.setText(string, string2, DEFAULT_TEXT_MIME_TYPE);
    }

    public void setText(String string, String string2, String string3) throws EmailException {
        try {
            this.textPart = this.makeTextBodyPart(string, string2, string3);
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot set text part of email message", messagingException);
        }
    }

    public void setText(String[] stringArray) throws EmailException {
        this.setText(stringArray, null, DEFAULT_TEXT_MIME_TYPE);
    }

    public void setText(String[] stringArray, String string) throws EmailException {
        this.setText(stringArray, string, DEFAULT_TEXT_MIME_TYPE);
    }

    public void setText(String[] stringArray, String string, String string2) throws EmailException {
        try {
            this.textPart = this.makeTextBodyPart(stringArray, string, string2);
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot set text part of email message", messagingException);
        }
    }

    public void setText(InputStream inputStream) throws EmailException {
        this.setText(inputStream, (String)null, DEFAULT_TEXT_MIME_TYPE);
    }

    public void setText(InputStream inputStream, String string) throws EmailException {
        this.setText(inputStream, string, DEFAULT_TEXT_MIME_TYPE);
    }

    public void setText(InputStream inputStream, String string, String string2) throws EmailException {
        try {
            this.textPart = this.makeBodyPart(inputStream, string, string2);
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot set text part of email message", messagingException);
        }
        catch (IOException iOException) {
            throw new EmailException("Cannot set text part of email message", iOException);
        }
    }

    public void setText(Iterator iterator) throws EmailException {
        this.setText(iterator, null, DEFAULT_TEXT_MIME_TYPE);
    }

    public void setText(Iterator iterator, String string) throws EmailException {
        this.setText(iterator, null, string);
    }

    public void setText(Iterator iterator, String string, String string2) throws EmailException {
        try {
            this.textPart = this.makeTextBodyPart(iterator, string, string2);
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot set text part of email message", messagingException);
        }
    }

    public void setText(File file) throws EmailException {
        this.setText(file, null);
    }

    public void setText(File file, String string) throws EmailException {
        this.setText(file, file.getName(), string);
    }

    public void setText(File file, String string, String string2) throws EmailException {
        try {
            String string3;
            MimeBodyPart mimeBodyPart = this.makeBodyPart(file, string, string2);
            string2 = mimeBodyPart.getContentType();
            int n = string2.indexOf(47);
            if (n == -1) {
                n = string2.length();
            }
            if (!(string3 = string2.substring(0, n)).equals("text")) {
                throw new EmailException("Bad MIME type (\"" + string2 + "\") for text part of email message");
            }
            this.textPart = mimeBodyPart;
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot set text part of email message", messagingException);
        }
    }

    public void clearText() {
        this.textPart = null;
    }

    public InputStream getAttachment(int n) throws ArrayIndexOutOfBoundsException, EmailException {
        MimeBodyPart mimeBodyPart = this.attachments.get(n);
        try {
            return mimeBodyPart.getInputStream();
        }
        catch (IOException iOException) {
            throw new EmailException("Cannot get attachment #" + String.valueOf(n) + " from message", iOException);
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot get attachment #" + String.valueOf(n) + " from message", messagingException);
        }
    }

    public String getAttachmentContentType(int n) throws ArrayIndexOutOfBoundsException, EmailException {
        MimeBodyPart mimeBodyPart = this.attachments.get(n);
        try {
            return mimeBodyPart.getContentType();
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot get attachment #" + String.valueOf(n) + " from message", messagingException);
        }
    }

    public int totalAttachments() {
        return this.attachments.size();
    }

    public void addAttachment(String string) throws EmailException {
        this.addAttachment(string, null, DEFAULT_TEXT_MIME_TYPE);
    }

    public void addAttachment(String string, String string2) throws EmailException {
        this.addAttachment(string, string2, DEFAULT_TEXT_MIME_TYPE);
    }

    public void addAttachment(String string, String string2, String string3) throws EmailException {
        try {
            this.attachments.add(this.makeTextBodyPart(string, string2, string3));
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot add attachment to email message", messagingException);
        }
    }

    public void addAttachment(String[] stringArray) throws EmailException {
        this.addAttachment(stringArray, DEFAULT_TEXT_MIME_TYPE);
    }

    public void addAttachment(String[] stringArray, String string) throws EmailException {
        this.addAttachment(stringArray, null, DEFAULT_TEXT_MIME_TYPE);
    }

    public void addAttachment(String[] stringArray, String string, String string2) throws EmailException {
        try {
            this.attachments.add(this.makeTextBodyPart(stringArray, string, string2));
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot add attachment to email message", messagingException);
        }
    }

    public void addAttachment(InputStream inputStream) throws EmailException {
        this.addAttachment(inputStream, null, "application/octet-stream");
    }

    public void addAttachment(InputStream inputStream, String string) throws EmailException {
        this.addAttachment(inputStream, string, "application/octet-stream");
    }

    public void addAttachment(InputStream inputStream, String string, String string2) throws EmailException {
        try {
            this.attachments.add(this.makeBodyPart(inputStream, string, string2));
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot add attachment to email message", messagingException);
        }
        catch (IOException iOException) {
            throw new EmailException("Cannot add attachment to email message", iOException);
        }
    }

    public void addAttachment(Iterator iterator) throws EmailException {
        this.addAttachment(iterator, null, "application/octet-stream");
    }

    public void addAttachment(Iterator iterator, String string) throws EmailException {
        this.addAttachment(iterator, string, "application/octet-stream");
    }

    public void addAttachment(Iterator iterator, String string, String string2) throws EmailException {
        try {
            this.attachments.add(this.makeTextBodyPart(iterator, string, string2));
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot add attachment to email message", messagingException);
        }
    }

    public void addAttachment(File file) throws EmailException {
        try {
            this.attachments.add(this.makeBodyPart(file, file.getName(), null));
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot add attachment to email message", messagingException);
        }
    }

    public void addAttachment(File file, String string) throws EmailException {
        try {
            this.attachments.add(this.makeBodyPart(file, file.getName(), string));
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot add attachment to email message", messagingException);
        }
    }

    public void addAttachment(File file, String string, String string2) throws EmailException {
        try {
            this.attachments.add(this.makeBodyPart(file, string, string2));
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Cannot add attachment to email message", messagingException);
        }
    }

    public void clearAllAttachments() {
        this.attachments.clear();
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void clearSubject() {
        this.setSubject(null);
    }

    public void setSender(String string) throws EmailException {
        if (string == null) {
            this.sender = null;
        } else {
            this.setSender(new EmailAddress(string));
        }
    }

    public void setSender(EmailAddress emailAddress) throws EmailException {
        this.sender = emailAddress;
    }

    public EmailAddress getSender() throws EmailException {
        EmailAddress emailAddress = null;
        if (this.sender != null) {
            emailAddress = this.sender;
        } else {
            String string = System.getProperty("user.name");
            if (string == null) {
                string = "unknown";
            }
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                emailAddress = new EmailAddress(string + "@" + inetAddress.getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                throw new EmailException("Can't get name of localhost", unknownHostException);
            }
        }
        return emailAddress;
    }

    List getAttachments() {
        return this.attachments;
    }

    Collection<EmailAddress> getToAddresses() {
        return this.to;
    }

    Collection<EmailAddress> getCcAddresses() {
        return this.cc;
    }

    Collection<EmailAddress> getBccAddresses() {
        return this.bcc;
    }

    MimeBodyPart getTextPart() {
        return this.textPart;
    }

    List getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    private void addEmailAddress(EmailAddress emailAddress, Collection<EmailAddress> collection) throws EmailException {
        collection.add(emailAddress);
    }

    private void addEmailAddresses(String[] stringArray, Collection<EmailAddress> collection) throws EmailException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addEmailAddress(new EmailAddress(stringArray[i]), collection);
        }
    }

    private void addEmailAddresses(Collection<?> collection, Collection<EmailAddress> collection2) throws EmailException {
        for (Object obj : collection) {
            if (obj instanceof String) {
                collection2.add(new EmailAddress((String)obj));
                continue;
            }
            if (obj instanceof EmailAddress) {
                collection2.add((EmailAddress)obj);
                continue;
            }
            throw new EmailException("BUG: Expected object of type \"String\" or \"EmailAddress\" in Collection of email addresses, but found object of type \"" + obj.getClass().getName());
        }
    }

    private Collection<EmailAddress> getEmailAddresses(Collection<EmailAddress> collection) throws EmailException {
        ArrayList<EmailAddress> arrayList = new ArrayList<EmailAddress>();
        Iterator<EmailAddress> iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new EmailAddress(iterator.next()));
        }
        return arrayList;
    }

    private void initAdditionalHeaders() {
        this.additionalHeaders.clear();
        for (int i = 0; i < CUSTOM_HEADERS.length; ++i) {
            this.additionalHeaders.add(CUSTOM_HEADERS[i]);
        }
    }

    private MimeBodyPart makeBodyPart(File file, String string, String string2) throws MessagingException, EmailException {
        if (!file.exists()) {
            throw new EmailException("File \"" + file.getAbsolutePath() + "\" does not exist");
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        FileDataSource fileDataSource = new FileDataSource(file);
        class MyFileTypeMap
        extends FileTypeMap {
            private String mimeType = null;

            MyFileTypeMap(String string) {
                this.mimeType = string;
            }

            public String getContentType(File file) {
                String string = this.mimeType;
                if (string == null) {
                    string = MIMETypeUtil.MIMETypeForFile(file);
                }
                return string;
            }

            public String getContentType(String string) {
                String string2 = this.mimeType;
                if (string2 == null) {
                    string2 = MIMETypeUtil.MIMETypeForFileName(string);
                }
                return string2;
            }
        }
        fileDataSource.setFileTypeMap((FileTypeMap)new MyFileTypeMap(string2));
        mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
        if (!this.multipartSubtype.equals(MULTIPART_ALTERNATIVE)) {
            if (string == null) {
                string = file.getName();
            }
            mimeBodyPart.setFileName(string);
        }
        return mimeBodyPart;
    }

    private MimeBodyPart makeBodyPart(InputStream inputStream, String string, String string2) throws EmailException, MessagingException, IOException {
        int n;
        String string3 = null;
        if (string != null) {
            string3 = FileUtil.getFileNameExtension(string);
        }
        if (string3 == null) {
            string3 = MIMETypeUtil.fileExtensionForMIMEType(string2);
        }
        if (string3 == null) {
            string3 = "dat";
        }
        string3 = "." + string3;
        File file = File.createTempFile("mail", string3);
        file.deleteOnExit();
        log.debug("Created temporary file \"" + file.getPath() + "\"");
        this.temporaryFiles.add(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        while ((n = inputStream.read()) != -1) {
            ((OutputStream)bufferedOutputStream).write(n);
        }
        ((OutputStream)bufferedOutputStream).close();
        if (string2 == null) {
            string2 = "application/octet-stream";
        }
        if (string == null) {
            string = file.getName();
        }
        return this.makeBodyPart(file, string, string2);
    }

    private MimeBodyPart makeTextBodyPart(String string, String string2) throws MessagingException {
        return this.makeTextBodyPart(string, string2, DEFAULT_TEXT_MIME_TYPE);
    }

    private MimeBodyPart makeTextBodyPart(String string, String string2, String string3) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        string = this.newlineTerminatedString(string);
        StringDataSource stringDataSource = new StringDataSource(string, string3, null);
        mimeBodyPart.setDataHandler(new DataHandler((DataSource)stringDataSource));
        if (string2 == null) {
            String string4 = MIMETypeUtil.fileExtensionForMIMEType(string3);
            string2 = this.generateFileName(string4);
        }
        mimeBodyPart.setFileName(string2);
        return mimeBodyPart;
    }

    private MimeBodyPart makeTextBodyPart(String[] stringArray, String string) throws MessagingException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.println(stringArray[i]);
        }
        return this.makeTextBodyPart(stringWriter.toString(), string, DEFAULT_TEXT_MIME_TYPE);
    }

    private MimeBodyPart makeTextBodyPart(String[] stringArray, String string, String string2) throws MessagingException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.println(stringArray[i]);
        }
        return this.makeTextBodyPart(stringWriter.toString(), string, string2);
    }

    private MimeBodyPart makeTextBodyPart(Iterator iterator, String string, String string2) throws MessagingException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        while (iterator.hasNext()) {
            printWriter.println((String)iterator.next());
        }
        return this.makeTextBodyPart(stringWriter.toString(), string, string2);
    }

    private String newlineTerminatedString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(string);
        return stringWriter.toString();
    }

    private String generateFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GENERATED_FILE_NAME_FMT.format(new Date()));
        stringBuffer.append('.');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

