/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.mail;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.clapper.util.mail.EmailAddress;
import org.clapper.util.mail.EmailException;
import org.clapper.util.mail.EmailMessage;
import org.clapper.util.mail.EmailTransport;
import org.clapper.util.mail.MultipartSubtype;

public class SMTPEmailTransport
implements EmailTransport {
    private String smtpHost = null;
    private Session session = null;
    private Transport transport = null;

    public SMTPEmailTransport() throws EmailException {
        this("localhost");
    }

    public SMTPEmailTransport(String string) throws EmailException {
        this("localhost", null);
    }

    public SMTPEmailTransport(String string, String string2) throws EmailException {
        this.smtpHost = string;
        try {
            Properties properties = new Properties();
            if (string2 != null) {
                properties.put("mail,smtp.localhost", string2);
            }
            properties.put("mail.smtp.host", string);
            properties.put("mail.smtp.allow8bitmime", "true");
            this.session = Session.getDefaultInstance((Properties)properties, null);
            this.transport = this.session.getTransport("smtp");
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Unable to initialize transport to SMTP host \"" + string + "\"", messagingException);
        }
    }

    @Override
    public void setDebug(boolean bl, PrintStream printStream) {
        this.session.setDebug(bl);
        if (bl) {
            this.session.setDebugOut(printStream);
        }
    }

    @Override
    public void send(EmailMessage emailMessage) throws EmailException {
        try {
            Iterator iterator;
            MimeMessage mimeMessage = new MimeMessage(this.session);
            MimeMultipart mimeMultipart = new MimeMultipart();
            MultipartSubtype multipartSubtype = emailMessage.getMultipartSubtype();
            mimeMultipart.setSubType(multipartSubtype.getSubtypeString());
            EmailAddress emailAddress = emailMessage.getSender();
            mimeMessage.setFrom((Address)emailAddress.getInternetAddress());
            Collection<EmailAddress> collection = emailMessage.getToAddresses();
            Collection<EmailAddress> collection2 = emailMessage.getCcAddresses();
            Collection<EmailAddress> collection3 = emailMessage.getBccAddresses();
            if (collection.size() == 0) {
                throw new EmailException("No \"To:\" addresses in message");
            }
            this.setRecipients(mimeMessage, Message.RecipientType.TO, collection);
            this.setRecipients(mimeMessage, Message.RecipientType.CC, collection2);
            this.setRecipients(mimeMessage, Message.RecipientType.BCC, collection3);
            mimeMessage.setSubject(emailMessage.getSubject());
            List list = emailMessage.getAttachments();
            int n = list.size();
            MimeBodyPart mimeBodyPart = emailMessage.getTextPart();
            if (mimeBodyPart == null && n == 0) {
                emailMessage.setText("");
                mimeBodyPart = emailMessage.getTextPart();
            }
            if (mimeBodyPart != null) {
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            }
            if (n > 0) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    mimeMultipart.addBodyPart((BodyPart)((MimeBodyPart)iterator.next()));
                }
            }
            if (mimeMultipart.getCount() > 0) {
                mimeMessage.setContent((Multipart)mimeMultipart);
            }
            iterator = emailMessage.getAdditionalHeaders().iterator();
            while (iterator.hasNext()) {
                mimeMessage.addHeaderLine((String)iterator.next());
            }
            mimeMessage.setSentDate(new Date());
            this.transport.connect();
            Transport.send((Message)mimeMessage);
            this.transport.close();
        }
        catch (MessagingException messagingException) {
            throw new EmailException("Unable to send message", messagingException);
        }
    }

    private void setRecipients(MimeMessage mimeMessage, Message.RecipientType recipientType, Collection collection) throws MessagingException {
        if (collection.size() > 0) {
            InternetAddress[] internetAddressArray = new InternetAddress[collection.size()];
            int n = 0;
            for (EmailAddress emailAddress : collection) {
                internetAddressArray[n] = emailAddress.getInternetAddress();
                ++n;
            }
            mimeMessage.setRecipients(recipientType, (Address[])internetAddressArray);
        }
    }
}

