/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    private T[] array = null;
    private int nextIndex = 0;

    public ArrayIterator(T[] TArray) {
        this.array = TArray;
    }

    public ArrayIterator(T[] TArray, int n) {
        this.array = TArray;
        this.nextIndex = n;
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    @Override
    public boolean hasNext() {
        return this.array != null && this.nextIndex < this.array.length;
    }

    @Override
    public T next() throws NoSuchElementException {
        T t = null;
        try {
            if (this.array == null) {
                throw new NoSuchElementException();
            }
            t = this.array[this.nextIndex++];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
        return t;
    }

    public T previous() throws NoSuchElementException {
        T t = null;
        try {
            t = this.array[--this.nextIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
        return t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

