/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.clapper.util.misc.XDate;

public class BuildInfo {
    public static final String BUILD_OS_KEY = "build.os";
    public static final String BUILD_VM_KEY = "build.vm";
    public static final String BUILD_COMPILER_KEY = "build.compiler";
    public static final String BUILD_ANT_VERSION_KEY = "build.ant.version";
    public static final String BUILD_DATE_KEY = "build.date";
    public static final String BUILT_BY_KEY = "built.by";
    public static final String BUILD_ID_KEY = "build.id";
    public static final String DATE_FORMAT_STRING = "yyyy/MM/dd HH:mm:ss z";
    public static final String BUILD_ID_DATE_FORMAT_STRING = "yyyyMMdd.HHmmss.SSS";
    private static ResourceBundle buildInfoBundle = null;

    public BuildInfo(String string) {
        this.getBuildInfoBundle(string);
    }

    public String getBuildDate() {
        return BuildInfo.getBundleString(BUILD_DATE_KEY);
    }

    public String getBuildUserID() {
        return BuildInfo.getBundleString(BUILT_BY_KEY);
    }

    public String getBuildOperatingSystem() {
        return BuildInfo.getBundleString(BUILD_OS_KEY);
    }

    public String getBuildID() {
        return BuildInfo.getBundleString(BUILD_ID_KEY);
    }

    public String getBuildJavaVM() {
        return BuildInfo.getBundleString(BUILD_VM_KEY);
    }

    public String getBuildJavaCompiler() {
        return BuildInfo.getBundleString(BUILD_COMPILER_KEY);
    }

    public String getBuildAntVersion() {
        return BuildInfo.getBundleString(BUILD_ANT_VERSION_KEY);
    }

    public static void makeBuildInfoBundle(File file, String string, String string2) throws IOException {
        Object object;
        Properties properties = new Properties();
        String string3 = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")";
        properties.setProperty(BUILD_VM_KEY, string3);
        String string4 = System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")";
        properties.setProperty(BUILD_OS_KEY, string4);
        if (string != null) {
            properties.setProperty(BUILD_COMPILER_KEY, string);
        }
        if (string2 != null) {
            properties.setProperty(BUILD_ANT_VERSION_KEY, string2);
        }
        XDate xDate = new XDate();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
        properties.setProperty(BUILD_DATE_KEY, simpleDateFormat.format(xDate));
        properties.setProperty(BUILD_ID_KEY, xDate.formatInTimeZone(BUILD_ID_DATE_FORMAT_STRING, TimeZone.getTimeZone("UTC")));
        String string5 = System.getProperty("user.name");
        String string6 = "localhost";
        try {
            object = InetAddress.getLocalHost();
            string6 = ((InetAddress)object).getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        properties.setProperty(BUILT_BY_KEY, string5 + " on " + string6);
        object = "Build information. AUTOMATICALLY GENERATED. DO NOT EDIT!";
        System.out.println("Updating " + file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, (String)object);
    }

    public void showBuildInfo(PrintStream printStream) {
        this.showBuildInfo(new PrintWriter(printStream));
    }

    public void showBuildInfo(PrintWriter printWriter) {
        printWriter.println("Build date:     " + this.getBuildDate());
        printWriter.println("Built by:       " + this.getBuildUserID());
        printWriter.println("Built on:       " + this.getBuildOperatingSystem());
        printWriter.println("Build Java VM:  " + this.getBuildJavaVM());
        printWriter.println("Build compiler: " + this.getBuildJavaCompiler());
        printWriter.println("Ant version:    " + this.getBuildAntVersion());
    }

    private synchronized ResourceBundle getBuildInfoBundle(String string) {
        if (buildInfoBundle == null) {
            try {
                buildInfoBundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return buildInfoBundle;
    }

    private static String getBundleString(String string) {
        String string2 = "";
        try {
            if (buildInfoBundle != null) {
                string2 = buildInfoBundle.getString(string);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }
}

