/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.clapper.util.logging.Logger;
import org.clapper.util.misc.FileHashMapEntry;
import org.clapper.util.misc.ObjectExistsException;
import org.clapper.util.misc.VersionMismatchException;

public class FileHashMap<K, V>
extends AbstractMap<K, V> {
    public static final String INDEX_FILE_SUFFIX = ".ix";
    public static final String DATA_FILE_SUFFIX = ".db";
    public static final int NO_CREATE = 1;
    public static final int TRANSIENT = 2;
    public static final int FORCE_OVERWRITE = 4;
    public static final int RECLAIM_FILE_GAPS = 8;
    private static final String VERSION_STAMP = "org.clapper.util.misc.FileHashMap-1.0";
    private static final int ALL_FLAGS_MASK = 15;
    private HashMap<K, FileHashMapEntry<K>> indexMap = null;
    private String filePrefix = null;
    private File indexFilePath = null;
    private File valuesDBPath = null;
    private ValuesFile valuesDB = null;
    private int flags = 0;
    private boolean modified = false;
    private boolean valid = true;
    private EntrySet entrySetResult = null;
    private TreeSet<FileHashMapEntry<K>> fileGaps = null;
    private static final Logger log = new Logger(FileHashMap.class);

    public FileHashMap() throws IOException {
        this(null);
    }

    public FileHashMap(String string) throws IOException {
        this.flags = 2;
        this.filePrefix = string;
        if (this.filePrefix == null) {
            this.filePrefix = "fmh";
        }
        this.valuesDBPath = File.createTempFile(this.filePrefix, DATA_FILE_SUFFIX);
        this.valuesDBPath.deleteOnExit();
        this.createNewMap(this.valuesDBPath);
    }

    public FileHashMap(String string, int n) throws FileNotFoundException, ObjectExistsException, ClassNotFoundException, VersionMismatchException, IOException {
        assert ((0xFFFFFFF0 & n) == 0);
        int n2 = 0;
        this.filePrefix = string;
        this.flags = n;
        this.valuesDBPath = new File(string + DATA_FILE_SUFFIX);
        this.indexFilePath = new File(string + INDEX_FILE_SUFFIX);
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFE;
        }
        if (this.valuesDBPath.exists()) {
            ++n2;
        }
        if (this.indexFilePath.exists()) {
            ++n2;
        }
        if (n2 > 0 && (n & 2) != 0) {
            if ((n & 4) == 0) {
                throw new ObjectExistsException("org.clapper.util.misc.Bundle", "FileHashMap.diskFilesExist", "One or both of the hash table files (\"{0}\" and/or \"{1}\") already exists, but the FileHashMap.FORCE_OVERWRITE constructor flag was not set.", new Object[]{this.valuesDBPath.getName(), this.indexFilePath.getName()});
            }
            this.valuesDBPath.delete();
            this.indexFilePath.delete();
            n2 = 0;
        }
        switch (n2) {
            case 0: {
                if ((n & 1) != 0) {
                    throw new FileNotFoundException("On-disk hash table \"" + string + "\" does not exist, and the FileHashMap.NO_CREATE flag was set.");
                }
                this.createNewMap(this.valuesDBPath);
                break;
            }
            case 1: {
                throw new ObjectExistsException("org.clapper.util.misc.Bundle", "FileHashMap.halfMissing", "One of the hash table files exists (\"{0}\" or \"{1}\") exists, but the other one does not.", new Object[]{this.valuesDBPath.getName(), this.indexFilePath.getName()});
            }
            case 2: {
                this.valuesDB = new ValuesFile(this.valuesDBPath);
                this.loadIndex();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if ((n & 8) != 0) {
            this.findFileGaps();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException iOException) {
            log.error("Error during finalize", iOException);
        }
        super.finalize();
    }

    @Override
    public synchronized void clear() {
        this.checkValidity();
        this.indexMap.clear();
        try {
            this.valuesDB.getFile().getChannel().truncate(0L);
            this.modified = true;
        }
        catch (IOException iOException) {
            log.error("Failed to truncate FileHashMap file \"" + this.valuesDBPath.getPath() + "\"", iOException);
            this.valid = false;
        }
    }

    public synchronized void close() throws NotSerializableException, IOException {
        if (this.valid) {
            if ((this.flags & 2) != 0) {
                if (this.valuesDB != null) {
                    this.valuesDB.close();
                    this.valuesDB = null;
                }
                this.deleteMapFiles();
            } else {
                this.save();
            }
            this.valid = false;
        }
    }

    @Override
    public boolean containsKey(Object object) {
        this.checkValidity();
        return this.indexMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        this.checkValidity();
        return new ValueSet().contains(object);
    }

    public void delete() {
        try {
            this.close();
        }
        catch (NotSerializableException notSerializableException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.deleteMapFiles();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.checkValidity();
        if (this.entrySetResult == null) {
            this.entrySetResult = new EntrySet();
        }
        return this.entrySetResult;
    }

    @Override
    public boolean equals(Object object) {
        this.checkValidity();
        return super.equals(object);
    }

    @Override
    public V get(Object object) {
        this.checkValidity();
        V v = null;
        FileHashMapEntry<K> fileHashMapEntry = this.indexMap.get(object);
        if (fileHashMapEntry != null) {
            v = this.readValueNoError(fileHashMapEntry);
        }
        return v;
    }

    @Override
    public int hashCode() {
        this.checkValidity();
        return super.hashCode();
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Set<K> keySet() {
        this.checkValidity();
        return new KeySet();
    }

    @Override
    public V put(K k, V v) throws ClassCastException, IllegalArgumentException, NullPointerException {
        this.checkValidity();
        V v2 = null;
        if (k == null) {
            throw new NullPointerException("null key parameter");
        }
        if (v == null) {
            throw new NullPointerException("null value parameter");
        }
        if (!(v instanceof Serializable)) {
            throw new IllegalArgumentException("Value is not serializable.");
        }
        try {
            FileHashMapEntry<K> fileHashMapEntry = this.indexMap.get(k);
            if (fileHashMapEntry != null) {
                v2 = this.readValueNoError(fileHashMapEntry);
                this.remove(k);
            }
            FileHashMapEntry<K> fileHashMapEntry2 = this.writeValue(k, v);
            this.indexMap.put(k, fileHashMapEntry2);
            this.modified = true;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error saving value: " + iOException.getMessage());
        }
        return v2;
    }

    @Override
    public V remove(Object object) {
        this.checkValidity();
        V v = null;
        if (this.indexMap.containsKey(object)) {
            FileHashMapEntry<K> fileHashMapEntry = this.indexMap.get(object);
            v = this.readValueNoError(fileHashMapEntry);
            this.indexMap.remove(object);
            this.modified = true;
            if ((this.flags & 8) != 0) {
                log.debug("Removed value for key \"" + object + "\" at pos=" + fileHashMapEntry.getFilePosition() + ", size=" + fileHashMapEntry.getObjectSize() + ". Re-figuring gaps.");
                this.findFileGaps();
            }
        }
        return v;
    }

    public void save() throws IOException, NotSerializableException {
        this.checkValidity();
        if ((this.flags & 2) == 0 && this.modified) {
            this.saveIndex();
        }
    }

    @Override
    public int size() {
        this.checkValidity();
        return this.currentSize();
    }

    @Override
    public Collection<V> values() {
        this.checkValidity();
        return new ValueSet();
    }

    private void checkValidity() {
        if (!this.valid) {
            throw new IllegalStateException("Invalid FileHashMap object");
        }
    }

    private void createNewMap(File file) throws IOException {
        this.valuesDB = new ValuesFile(file);
        this.indexMap = new HashMap();
    }

    private int currentSize() {
        return this.indexMap.size();
    }

    private void findFileGaps() {
        log.debug("Looking for file gaps.");
        if (this.fileGaps == null) {
            this.fileGaps = new TreeSet(new FileHashMapEntryGapComparator());
        } else {
            this.fileGaps.clear();
        }
        if (this.currentSize() > 0) {
            List<FileHashMapEntry<K>> list = this.getSortedEntries();
            FileHashMapEntry<K> fileHashMapEntry = null;
            Iterator<FileHashMapEntry<K>> iterator = list.iterator();
            FileHashMapEntry<K> fileHashMapEntry2 = iterator.next();
            long l = fileHashMapEntry2.getFilePosition();
            int n = fileHashMapEntry2.getObjectSize();
            if (l > 0L) {
                log.debug("First entry is at pos " + l + ", size=" + n);
                n = (int)l;
                log.debug("Gap at position 0 of size " + n);
                this.fileGaps.add(new FileHashMapEntry(0L, n));
            }
            fileHashMapEntry = fileHashMapEntry2;
            while (iterator.hasNext()) {
                fileHashMapEntry2 = iterator.next();
                long l2 = fileHashMapEntry.getFilePosition();
                long l3 = l2 + (long)fileHashMapEntry.getObjectSize();
                l = fileHashMapEntry2.getFilePosition();
                assert (l > l2);
                if (l3 != l) {
                    int n2 = (int)(l - l3);
                    log.debug("Gap at position " + l3 + " of size " + n2);
                    this.fileGaps.add(new FileHashMapEntry(l3, n2));
                }
                fileHashMapEntry = fileHashMapEntry2;
            }
        }
    }

    private List<FileHashMapEntry<K>> getSortedEntries() {
        ArrayList<FileHashMapEntry<K>> arrayList = new ArrayList<FileHashMapEntry<K>>();
        arrayList.addAll(this.indexMap.values());
        Collections.sort(arrayList, new FileHashMapEntryComparator());
        return arrayList;
    }

    private void loadIndex() throws IOException, ClassNotFoundException, VersionMismatchException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.indexFilePath));
        String string = (String)objectInputStream.readObject();
        if (!string.equals(VERSION_STAMP)) {
            throw new VersionMismatchException("org.clapper.util.misc.Bundle", "FileHashMap.versionMismatch", "FileHashMap version mismatch in index file \"{0}\". Expected version \"{1}\", found version \"{2}\"", new Object[]{this.indexFilePath.getName(), VERSION_STAMP, string}, VERSION_STAMP, string);
        }
        this.indexMap = (HashMap)objectInputStream.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V readValue(FileHashMapEntry<K> fileHashMapEntry) throws IOException, ClassNotFoundException, IllegalStateException {
        int n = fileHashMapEntry.getObjectSize();
        byte[] byArray = new byte[n];
        FileHashMap fileHashMap = this;
        synchronized (fileHashMap) {
            RandomAccessFile randomAccessFile = this.valuesDB.getFile();
            randomAccessFile.seek(fileHashMapEntry.getFilePosition());
            int n2 = randomAccessFile.read(byArray);
            if (n2 != n) {
                throw new IOException("Expected to read " + n + "-byte serialized object from  on-disk data file. Got only " + n2 + " bytes.");
            }
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        return (V)objectInputStream.readObject();
    }

    private V readValueNoError(FileHashMapEntry<K> fileHashMapEntry) {
        V v = null;
        try {
            v = this.readValue(fileHashMapEntry);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return v;
    }

    private synchronized void saveIndex() throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.indexFilePath));
        objectOutputStream.writeObject(VERSION_STAMP);
        objectOutputStream.writeObject(this.indexMap);
        if (log.isDebugEnabled()) {
            List<FileHashMapEntry<K>> list = this.getSortedEntries();
            log.debug("Just saved index. Total entries=" + this.currentSize());
            log.debug("Index values follow.");
            for (FileHashMapEntry<K> fileHashMapEntry : list) {
                long l = fileHashMapEntry.getFilePosition();
                int n = fileHashMapEntry.getObjectSize();
                log.debug("    pos=" + l + ", size=" + n);
            }
        }
    }

    private synchronized FileHashMapEntry<K> writeValue(K k, V v) throws IOException, NotSerializableException {
        long l = -1L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(v);
        int n = byteArrayOutputStream.size();
        if ((this.flags & 8) != 0) {
            l = this.findBestFitGap(n);
        }
        RandomAccessFile randomAccessFile = this.valuesDB.getFile();
        if (l == -1L) {
            l = randomAccessFile.length();
        }
        randomAccessFile.seek(l);
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        return new FileHashMapEntry<K>(l, n, k);
    }

    private long findBestFitGap(int n) {
        long l = -1L;
        log.debug("Finding smallest gap for " + n + "-byte object");
        assert (this.fileGaps != null);
        Iterator<FileHashMapEntry<K>> iterator = this.fileGaps.iterator();
        while (iterator.hasNext()) {
            FileHashMapEntry<K> fileHashMapEntry = iterator.next();
            long l2 = fileHashMapEntry.getFilePosition();
            int n2 = fileHashMapEntry.getObjectSize();
            log.debug("Gap: pos=" + l2 + ", size=" + n2);
            if (n2 < n) continue;
            log.debug("Found it.");
            l = l2;
            if (n2 <= n) break;
            log.debug("Gap size is larger than required. Making smaller gap.");
            iterator.remove();
            fileHashMapEntry.setFilePosition(l2 += (long)n);
            fileHashMapEntry.setObjectSize(n2 -= n);
            log.debug("Saving new, smaller gap: pos=" + l2 + ", size=" + n2);
            this.fileGaps.add(fileHashMapEntry);
            break;
        }
        log.debug("findBestFitGap: returning " + l);
        return l;
    }

    private void deleteMapFiles() {
        if (this.valuesDBPath != null) {
            this.valuesDBPath.delete();
            this.valuesDBPath = null;
        }
        if (this.indexFilePath != null) {
            this.indexFilePath.delete();
            this.indexFilePath = null;
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        ArrayList<K> keys = null;

        private KeySet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            return FileHashMap.this.indexMap.containsKey(object);
        }

        @Override
        public boolean containsAll(Collection collection) {
            boolean bl = true;
            Iterator iterator = collection.iterator();
            while (bl && iterator.hasNext()) {
                bl = FileHashMap.this.indexMap.containsKey(iterator.next());
            }
            return bl;
        }

        @Override
        public boolean equals(Object object) {
            Set set = (Set)object;
            boolean bl = false;
            Set set2 = FileHashMap.this.indexMap.keySet();
            if (set.size() == set2.size()) {
                bl = true;
                Iterator iterator = set2.iterator();
                while (bl) {
                    Object k = iterator.next();
                    if (set.contains(k)) continue;
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public int hashCode() {
            return FileHashMap.this.indexMap.keySet().hashCode();
        }

        @Override
        public boolean isEmpty() {
            return FileHashMap.this.indexMap.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return FileHashMap.this.currentSize();
        }

        private synchronized void loadKeyArray() {
            if (this.keys == null) {
                List list = FileHashMap.this.getSortedEntries();
                this.keys = new ArrayList();
                for (FileHashMapEntry fileHashMapEntry : list) {
                    this.keys.add(fileHashMapEntry.getKey());
                }
            }
        }
    }

    private class KeyIterator
    implements Iterator<K> {
        private EntryIterator it;

        KeyIterator() {
            this.it = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public K next() {
            return ((FileHashMapEntry)this.it.next()).getKey();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Map.Entry<K, V> entry) {
            return FileHashMap.this.containsValue(entry.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                EntryIterator it;
                {
                    this.it = new EntryIterator();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new EntrySetEntry(this.it.next());
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = bl = this == object;
            if (!bl) {
                bl = super.equals(object);
            }
            return bl;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        public boolean remove(FileHashMapEntry<K> fileHashMapEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return FileHashMap.this.size();
        }
    }

    private class EntrySetEntry
    implements Map.Entry<K, V> {
        private FileHashMapEntry<K> entry;

        EntrySetEntry(FileHashMapEntry<K> fileHashMapEntry) {
            this.entry = fileHashMapEntry;
        }

        @Override
        public boolean equals(Object object) {
            Map.Entry entry = (Map.Entry)object;
            Object v = this.getValue();
            Object k = this.getKey();
            return (entry.getKey() == null ? k == null : entry.getKey().equals(k)) && (entry.getValue() == null ? v == null : entry.getValue().equals(v));
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return FileHashMap.this.readValueNoError(this.entry);
        }

        @Override
        public int hashCode() {
            Object v = this.getValue();
            Object k = this.getKey();
            return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }

    private class ValueSet
    extends AbstractSet<V> {
        ValuesFile valuesDB;

        private ValueSet() {
            this.valuesDB = FileHashMap.this.valuesDB;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = false;
            this.seekTo(0L);
            ValueIterator valueIterator = new ValueIterator();
            while (valueIterator.hasNext()) {
                Object e = valueIterator.next();
                if (!e.equals(object)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        @Override
        public boolean containsAll(Collection collection) {
            boolean bl = true;
            this.seekTo(0L);
            ValueIterator valueIterator = new ValueIterator();
            while (valueIterator.hasNext()) {
                Object e = valueIterator.next();
                if (collection.contains(e)) continue;
                bl = false;
                break;
            }
            return bl;
        }

        @Override
        public boolean equals(Object object) {
            boolean bl = false;
            Set set = (Set)object;
            if (set.size() == this.size()) {
                bl = this.containsAll((Collection)set);
            }
            return bl;
        }

        @Override
        public int hashCode() {
            int n = 0;
            this.seekTo(0L);
            ValueIterator valueIterator = new ValueIterator();
            while (valueIterator.hasNext()) {
                Object e = valueIterator.next();
                n += e.hashCode();
            }
            return n;
        }

        @Override
        public boolean isEmpty() {
            return FileHashMap.this.indexMap.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean remove(Object object) {
            return FileHashMap.this.remove(object) != null;
        }

        @Override
        public int size() {
            return FileHashMap.this.currentSize();
        }

        private void seekTo(long l) {
            try {
                this.valuesDB.getFile().seek(l);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ValueIterator
    implements Iterator<V> {
        EntryIterator it;

        private ValueIterator() {
            this.it = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public V next() {
            return FileHashMap.this.readValueNoError((FileHashMapEntry)this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    implements Iterator<FileHashMapEntry<K>> {
        List<FileHashMapEntry<K>> entries;
        Iterator<FileHashMapEntry<K>> iterator;
        FileHashMapEntry<K> currentEntry = null;
        private int expectedSize = 0;

        EntryIterator() {
            this.entries = FileHashMap.this.getSortedEntries();
            this.iterator = this.entries.iterator();
            this.expectedSize = this.entries.size();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public FileHashMapEntry<K> next() {
            if (this.expectedSize != FileHashMap.this.indexMap.size()) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                this.currentEntry = null;
                throw new NoSuchElementException();
            }
            this.currentEntry = this.iterator.next();
            return this.currentEntry;
        }

        @Override
        public void remove() {
            Object k;
            Object v;
            if (this.currentEntry != null && this.expectedSize > 0 && (v = FileHashMap.this.remove(k = this.currentEntry.getKey())) != null) {
                this.currentEntry = this.hasNext() ? this.iterator.next() : null;
            }
        }
    }

    private class FileHashMapEntryGapComparator
    implements Comparator<FileHashMapEntry<K>> {
        private FileHashMapEntryGapComparator() {
        }

        @Override
        public int compare(FileHashMapEntry<K> fileHashMapEntry, FileHashMapEntry<K> fileHashMapEntry2) {
            int n = fileHashMapEntry.getObjectSize() - fileHashMapEntry2.getObjectSize();
            if (n == 0) {
                n = (int)(fileHashMapEntry.getFilePosition() - fileHashMapEntry2.getFilePosition());
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return this.getClass().isInstance(object);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private class FileHashMapEntryComparator
    implements Comparator<FileHashMapEntry<K>> {
        private FileHashMapEntryComparator() {
        }

        @Override
        public int compare(FileHashMapEntry<K> fileHashMapEntry, FileHashMapEntry<K> fileHashMapEntry2) {
            return fileHashMapEntry.compareTo(fileHashMapEntry2);
        }

        @Override
        public boolean equals(Object object) {
            return this.getClass().isInstance(object);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class ValuesFile {
        private RandomAccessFile file;

        ValuesFile(File file) throws IOException {
            this.file = new RandomAccessFile(file, "rw");
        }

        RandomAccessFile getFile() throws ConcurrentModificationException {
            return this.file;
        }

        void close() throws IOException {
            this.file.close();
        }
    }
}

