/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.clapper.util.misc.ObjectRemovalEvent;
import org.clapper.util.misc.ObjectRemovalListener;

public class LRUMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final long serialVersionUID = 1L;
    private int maxCapacity;
    private float loadFactor;
    private int initialCapacity;
    private EntryMap hash;
    private LRULinkedList lruQueue;
    private ListenerMap removalListeners = null;

    public LRUMap(int n) {
        this(16, 0.75f, n);
    }

    public LRUMap(int n, int n2) {
        this(n, 0.75f, n2);
    }

    public LRUMap(int n, float f, int n2) {
        assert (n2 > 0);
        assert ((double)f > 0.0);
        assert (n > 0);
        if (n > n2) {
            n = n2;
        }
        this.maxCapacity = n2;
        this.loadFactor = f;
        this.initialCapacity = n;
        this.hash = new EntryMap(n, f);
        this.lruQueue = new LRULinkedList();
    }

    public LRUMap(LRUMap<? extends K, ? extends V> lRUMap) {
        this(lRUMap.initialCapacity, lRUMap.loadFactor, lRUMap.maxCapacity);
        super.doPutAll(lRUMap);
    }

    public synchronized void addRemovalListener(ObjectRemovalListener objectRemovalListener, boolean bl) {
        if (this.removalListeners == null) {
            this.removalListeners = new ListenerMap();
        }
        this.removalListeners.put(objectRemovalListener, new RemovalListenerWrapper(objectRemovalListener, bl));
    }

    public synchronized boolean removeRemovalListener(ObjectRemovalListener objectRemovalListener) {
        boolean bl = false;
        if (this.removalListeners != null && this.removalListeners.remove(objectRemovalListener) != null) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.hash.clear();
        this.lruQueue.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.hash.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        boolean bl = false;
        for (LRULinkedListEntry lRULinkedListEntry : this.hash.values()) {
            if (!lRULinkedListEntry.getValue().equals(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public V get(Object object) {
        V v = null;
        LRULinkedListEntry lRULinkedListEntry = (LRULinkedListEntry)this.hash.get(object);
        if (lRULinkedListEntry != null) {
            assert (lRULinkedListEntry.key.equals(object)) : "entry.key=" + lRULinkedListEntry.key + ", key=" + object;
            this.lruQueue.moveToHead(lRULinkedListEntry);
            v = lRULinkedListEntry.value;
        }
        return v;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public int getMaximumCapacity() {
        return this.maxCapacity;
    }

    @Override
    public boolean isEmpty() {
        return this.hash.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public V put(K k, V v) {
        return this.doPut(k, v);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.doPutAll(map);
    }

    @Override
    public V remove(Object object) {
        V v = null;
        LRULinkedListEntry lRULinkedListEntry = (LRULinkedListEntry)this.hash.remove(object);
        if (lRULinkedListEntry != null) {
            v = lRULinkedListEntry.value;
            this.lruQueue.remove(lRULinkedListEntry);
            this.callRemovalListeners(object, v, false);
        }
        assert (this.hash.size() == this.lruQueue.size);
        return v;
    }

    public int setMaximumCapacity(int n) {
        assert (n > 0);
        int n2 = this.maxCapacity;
        this.clearTo(n);
        this.maxCapacity = n;
        return n2;
    }

    @Override
    public int size() {
        return this.lruQueue.size;
    }

    @Override
    public Collection<V> values() {
        return new ValueSet();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new LRUMap<K, V>(this);
    }

    private LRULinkedListEntry clearTo(int n) {
        assert (this.hash.size() == this.lruQueue.size);
        LRULinkedListEntry lRULinkedListEntry = null;
        while (this.lruQueue.size > n) {
            lRULinkedListEntry = this.lruQueue.removeTail();
            assert (lRULinkedListEntry != null);
            Object k = lRULinkedListEntry.key;
            LRULinkedListEntry lRULinkedListEntry2 = (LRULinkedListEntry)this.hash.remove(k);
            assert (lRULinkedListEntry2 != null);
            assert (lRULinkedListEntry2.key == k);
            this.callRemovalListeners(k, lRULinkedListEntry2.value, true);
        }
        assert (this.lruQueue.size <= n);
        assert (this.hash.size() == this.lruQueue.size);
        return lRULinkedListEntry;
    }

    private synchronized void callRemovalListeners(final Object object, final Object object2, boolean bl) {
        if (this.removalListeners != null) {
            for (RemovalListenerWrapper removalListenerWrapper : this.removalListeners.values()) {
                if (!bl && removalListenerWrapper.automaticOnly) continue;
                Map.Entry entry = new Map.Entry(){

                    @Override
                    public boolean equals(Object object3) {
                        return false;
                    }

                    public Object getKey() {
                        return object;
                    }

                    public Object getValue() {
                        return object2;
                    }

                    @Override
                    public int hashCode() {
                        return object.hashCode();
                    }

                    public Object setValue(Object object3) {
                        return null;
                    }
                };
                removalListenerWrapper.objectRemoved(new ObjectRemovalEvent(entry));
            }
        }
    }

    private void doPutAll(Map<? extends K, ? extends V> map) {
        for (K k : map.keySet()) {
            V v = map.get(k);
            this.doPut(k, v);
        }
    }

    private V doPut(K k, V v) {
        V v2 = null;
        LRULinkedListEntry lRULinkedListEntry = (LRULinkedListEntry)this.hash.get(k);
        if (lRULinkedListEntry == null) {
            lRULinkedListEntry = this.clearTo(this.maxCapacity - 1);
            if (lRULinkedListEntry == null) {
                lRULinkedListEntry = new LRULinkedListEntry(k, v);
            } else {
                lRULinkedListEntry.setKeyValue(k, v);
            }
            this.lruQueue.addToHead(lRULinkedListEntry);
            this.hash.put(k, lRULinkedListEntry);
        } else {
            v2 = lRULinkedListEntry.value;
            lRULinkedListEntry.value = v;
            this.lruQueue.moveToHead(lRULinkedListEntry);
        }
        return v2;
    }

    private class EntryMap
    extends HashMap<K, LRULinkedListEntry> {
        EntryMap(int n, float f) {
            super(n, f);
        }
    }

    private class ListenerMap
    extends HashMap<ObjectRemovalListener, RemovalListenerWrapper> {
        ListenerMap() {
        }
    }

    private static class RemovalListenerWrapper
    implements ObjectRemovalListener {
        boolean automaticOnly;
        ObjectRemovalListener realListener;

        RemovalListenerWrapper(ObjectRemovalListener objectRemovalListener, boolean bl) {
            this.realListener = objectRemovalListener;
            this.automaticOnly = bl;
        }

        @Override
        public void objectRemoved(ObjectRemovalEvent objectRemovalEvent) {
            this.realListener.objectRemoved(objectRemovalEvent);
        }
    }

    private class LRULinkedList {
        LRULinkedListEntry head = null;
        LRULinkedListEntry tail = null;
        int size = 0;

        private LRULinkedList() {
        }

        protected void finalize() throws Throwable {
            this.clear();
            super.finalize();
        }

        void addToTail(LRULinkedListEntry lRULinkedListEntry) {
            lRULinkedListEntry.next = null;
            lRULinkedListEntry.previous = this.tail;
            if (this.head == null) {
                this.head = lRULinkedListEntry;
                this.tail = lRULinkedListEntry;
            } else {
                lRULinkedListEntry.previous = this.tail;
                this.tail.next = lRULinkedListEntry;
            }
            ++this.size;
        }

        void addToHead(LRULinkedListEntry lRULinkedListEntry) {
            lRULinkedListEntry.next = null;
            lRULinkedListEntry.previous = null;
            if (this.head == null) {
                assert (this.tail == null);
                this.head = lRULinkedListEntry;
                this.tail = lRULinkedListEntry;
            } else {
                lRULinkedListEntry.next = this.head;
                this.head.previous = lRULinkedListEntry;
                this.head = lRULinkedListEntry;
            }
            ++this.size;
        }

        void remove(LRULinkedListEntry lRULinkedListEntry) {
            if (lRULinkedListEntry.next != null) {
                lRULinkedListEntry.next.previous = lRULinkedListEntry.previous;
            }
            if (lRULinkedListEntry.previous != null) {
                lRULinkedListEntry.previous.next = lRULinkedListEntry.next;
            }
            if (lRULinkedListEntry == this.head) {
                this.head = lRULinkedListEntry.next;
            }
            if (lRULinkedListEntry == this.tail) {
                this.tail = lRULinkedListEntry.previous;
            }
            lRULinkedListEntry.next = null;
            lRULinkedListEntry.previous = null;
            --this.size;
            assert (this.size >= 0);
        }

        LRULinkedListEntry removeTail() {
            LRULinkedListEntry lRULinkedListEntry = this.tail;
            if (lRULinkedListEntry != null) {
                this.remove(lRULinkedListEntry);
            }
            return lRULinkedListEntry;
        }

        void moveToHead(LRULinkedListEntry lRULinkedListEntry) {
            this.remove(lRULinkedListEntry);
            this.addToHead(lRULinkedListEntry);
        }

        void clear() {
            while (this.head != null) {
                LRULinkedListEntry lRULinkedListEntry = this.head.next;
                this.head.next = null;
                this.head.previous = null;
                this.head.key = null;
                this.head.value = null;
                this.head = lRULinkedListEntry;
            }
            this.tail = null;
            this.size = 0;
        }
    }

    private final class LRULinkedListEntry
    implements Map.Entry<K, V> {
        LRULinkedListEntry previous = null;
        LRULinkedListEntry next = null;
        K key = null;
        V value = null;

        LRULinkedListEntry(K k, V v) {
            this.setKeyValue(k, v);
        }

        @Override
        public boolean equals(Object object) {
            return LRULinkedListEntry.class.isInstance(object);
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        void setKeyValue(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public V setValue(V v) {
            Object v2 = this.value;
            this.value = v;
            return v2;
        }
    }

    private class ValueSetIterator
    implements Iterator<V> {
        private LRULinkedListEntry current;

        ValueSetIterator() {
            this.current = ((LRUMap)LRUMap.this).lruQueue.head;
        }

        @Override
        public V next() {
            LRULinkedListEntry lRULinkedListEntry = this.current;
            this.current = this.current.next;
            return lRULinkedListEntry.value;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ValueSet
    extends AbstractSet<V> {
        private ValueSet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            return LRUMap.this.containsValue(object);
        }

        @Override
        public boolean containsAll(Collection collection) {
            boolean bl = true;
            for (Object e : collection) {
                if (this.contains(e)) continue;
                bl = false;
                break;
            }
            return bl;
        }

        @Override
        public boolean isEmpty() {
            return LRUMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueSetIterator();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return LRUMap.this.size();
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private LRULinkedListEntry current;

        KeySetIterator() {
            this.current = ((LRUMap)LRUMap.this).lruQueue.head;
        }

        @Override
        public K next() {
            LRULinkedListEntry lRULinkedListEntry = this.current;
            this.current = this.current.next;
            return lRULinkedListEntry.key;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean contains(Object object) {
            return LRUMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return LRUMap.this.remove(object) != null;
        }

        @Override
        public int size() {
            return LRUMap.this.size();
        }

        @Override
        public void clear() {
            LRUMap.this.clear();
        }
    }

    private class EntryIterator
    implements Iterator<LRULinkedListEntry> {
        private LRULinkedListEntry current;

        EntryIterator() {
            this.current = ((LRUMap)LRUMap.this).lruQueue.head;
        }

        @Override
        public LRULinkedListEntry next() {
            LRULinkedListEntry lRULinkedListEntry = this.current;
            this.current = this.current.next;
            return lRULinkedListEntry;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                EntryIterator it;
                {
                    this.it = new EntryIterator();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return this.it.next();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = false;
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                bl = LRUMap.this.containsKey(k);
            }
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            return LRUMap.this.remove(object) != null;
        }

        @Override
        public int size() {
            return LRUMap.this.size();
        }

        @Override
        public void clear() {
            LRUMap.this.clear();
        }
    }
}

