/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.clapper.util.io.FileUtil;
import org.clapper.util.logging.Logger;
import org.clapper.util.text.TextUtil;

public class MIMETypeUtil {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final String MIME_MAPPINGS_BUNDLE = "org.clapper.util.misc.MIMETypes";
    private static Map<String, String> mimeTypeToExtensionMap = null;
    private static Map<String, String> extensionToMIMETypeMap = null;
    private static final Logger log = new Logger(MIMETypeUtil.class);

    private MIMETypeUtil() {
    }

    public static String fileExtensionForMIMEType(String string) {
        MIMETypeUtil.loadMappings();
        String string2 = mimeTypeToExtensionMap.get(string);
        if (string2 == null) {
            string2 = "dat";
        }
        return string2;
    }

    public static String MIMETypeForFileExtension(String string) {
        return MIMETypeUtil.MIMETypeForFileExtension(string, DEFAULT_MIME_TYPE);
    }

    public static String MIMETypeForFileExtension(String string, String string2) {
        return MIMETypeUtil.MIMETypeForFileName("test." + string, string2);
    }

    public static String MIMETypeForFile(File file) {
        return MIMETypeUtil.MIMETypeForFileName(file.getName(), DEFAULT_MIME_TYPE);
    }

    public static String MIMETypeForFile(File file, String string) {
        return MIMETypeUtil.MIMETypeForFileName(file.getName(), string);
    }

    public static String MIMETypeForFileName(String string) {
        return MIMETypeUtil.MIMETypeForFileName(string, DEFAULT_MIME_TYPE);
    }

    public static String MIMETypeForFileName(String string, String string2) {
        String string3 = null;
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        MIMETypeUtil.loadMappings();
        String string4 = FileUtil.getFileNameExtension(string);
        string3 = extensionToMIMETypeMap.get(string4);
        if (string3 == null) {
            string3 = fileNameMap.getContentTypeFor(string);
        }
        if (string3 != null) {
            if (string3.equals(DEFAULT_MIME_TYPE) && string2 != null) {
                string3 = string2;
            }
        } else {
            string3 = string2 == null ? DEFAULT_MIME_TYPE : string2;
        }
        return string3;
    }

    public static void parseContentTypeHeader(String string, StringBuffer stringBuffer, Map<String, String> map) {
        if (!(stringBuffer == null && map == null || TextUtil.stringIsEmpty(string))) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (map == null) {
                map = new HashMap<String, String>();
            }
            String[] stringArray = TextUtil.split(string, " ;");
            stringBuffer.setLength(0);
            stringBuffer.append(stringArray[0]);
            map.clear();
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = TextUtil.split(stringArray[i], "=");
                map.put(stringArray2[0], stringArray2.length == 1 ? "" : stringArray2[1]);
            }
        }
    }

    private static synchronized void loadMappings() {
        int n;
        if (mimeTypeToExtensionMap != null) {
            return;
        }
        mimeTypeToExtensionMap = new HashMap<String, String>();
        extensionToMIMETypeMap = new HashMap<String, String>();
        String string = System.getProperty("file.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("user.home"));
        stringBuffer.append(string);
        stringBuffer.append(".mime.types");
        MIMETypeUtil.loadMIMETypesFile(stringBuffer.toString());
        String string2 = System.getProperty("path.separator");
        String string3 = System.getProperty("java.class.path");
        String[] stringArray = TextUtil.split(string3, string2);
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.setLength(0);
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(string);
            stringBuffer.append("mime.types");
            MIMETypeUtil.loadMIMETypesFile(stringBuffer.toString());
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MIME_MAPPINGS_BUNDLE);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string4 = enumeration.nextElement();
            try {
                String[] stringArray2 = TextUtil.split(resourceBundle.getString(string4));
                if (mimeTypeToExtensionMap.get(string4) == null) {
                    log.debug("Internal: " + string4 + " -> \"" + stringArray2[0] + "\"");
                    mimeTypeToExtensionMap.put(string4, stringArray2[0]);
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    if (extensionToMIMETypeMap.get(stringArray2[n]) != null) continue;
                    log.debug("Internal: \"" + stringArray2[n] + "\" -> " + string4);
                    extensionToMIMETypeMap.put(stringArray2[n], string4);
                }
            }
            catch (MissingResourceException missingResourceException) {
                log.error("While reading internal bundle \"org.clapper.util.misc.MIMETypes\", got unexpected error on key \"" + string4 + "\"", missingResourceException);
            }
        }
    }

    private static void loadMIMETypesFile(String string) {
        try {
            File file = new File(string);
            log.debug("Attempting to load MIME types file \"" + string + "\"");
            if (!file.exists() || !file.isFile()) {
                log.debug("Regular file \"" + string + "\" does not exist.");
            } else {
                String string2;
                LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
                while ((string2 = lineNumberReader.readLine()) != null) {
                    String string3;
                    String[] stringArray;
                    if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#") || (stringArray = TextUtil.split(string2)).length < 2) continue;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 1; i < stringArray.length; ++i) {
                        if (stringArray[i].indexOf(61) != -1 || stringArray[i].indexOf(34) != -1) continue;
                        if (stringArray[i].startsWith(".")) {
                            if (stringArray[i].length() == 1) continue;
                            stringArray[i] = stringArray[i].substring(1);
                        }
                        arrayList.add(stringArray[i]);
                    }
                    if (arrayList.size() == 0 || (string3 = stringArray[0]).indexOf(47) == -1) continue;
                    if (mimeTypeToExtensionMap.get(string3) == null) {
                        String string4 = (String)arrayList.get(0);
                        log.debug("File \"" + string + "\": " + string3 + " -> \"" + string4 + "\"");
                        mimeTypeToExtensionMap.put(string3, string4);
                    }
                    for (String string4 : arrayList) {
                        if (extensionToMIMETypeMap.get(string4) != null) continue;
                        log.debug("File \"" + string + "\": \"" + string4 + "\" -> " + string3);
                        extensionToMIMETypeMap.put(string4, string3);
                    }
                }
                lineNumberReader.close();
            }
        }
        catch (IOException iOException) {
            log.debug("Error reading \"" + string + "\"", iOException);
        }
    }
}

