/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.clapper.util.misc.EnumerationIterator;

public class MultiIterator<T>
implements Iterator<T>,
Iterable<T> {
    private Collection<Iterator<T>> aggregation = new ArrayList<Iterator<T>>();
    private Iterator<Iterator<T>> aggregationIterator = null;
    private Iterator<T> it = null;

    public MultiIterator() {
    }

    public MultiIterator(Collection<T>[] collectionArray) {
        for (int i = 0; i < collectionArray.length; ++i) {
            this.aggregation.add(collectionArray[i].iterator());
        }
    }

    public MultiIterator(Collection<Collection<T>> collection) {
        Iterator<Collection<T>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.aggregation.add(iterator.next().iterator());
        }
    }

    public void addCollection(Collection<T> collection) {
        this.aggregation.add(collection.iterator());
    }

    public void addIterator(Iterator<T> iterator) {
        this.aggregation.add(iterator);
    }

    public void addEnumeration(Enumeration<T> enumeration) {
        this.aggregation.add(new EnumerationIterator<T>(enumeration));
    }

    @Override
    public boolean hasNext() {
        boolean bl = false;
        this.checkIterator();
        if (this.it != null) {
            bl = this.it.hasNext();
        }
        return bl;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public T next() throws NoSuchElementException {
        T t = null;
        this.checkIterator();
        if (this.it != null) {
            t = this.it.next();
        }
        return t;
    }

    @Override
    public void remove() {
        if (this.it != null) {
            this.it.remove();
        }
    }

    private synchronized void checkIterator() {
        if (this.aggregationIterator == null) {
            this.it = null;
            this.aggregationIterator = this.aggregation.iterator();
            if (this.aggregationIterator.hasNext()) {
                this.it = this.aggregationIterator.next();
            }
        }
        while (this.it != null && !this.it.hasNext()) {
            if (!this.aggregationIterator.hasNext()) {
                this.it = null;
                continue;
            }
            this.it = this.aggregationIterator.next();
        }
    }
}

