/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class MultiValueMap<K, V>
extends AbstractMap<K, V>
implements Cloneable {
    private Map<K, Collection<V>> map = null;
    private ValuesCollectionAllocator<V> valuesCollectionAllocator = new ValuesCollectionAllocator<V>(){

        @Override
        public Collection<V> newValuesCollection() {
            return new ArrayList();
        }
    };

    public MultiValueMap() {
        this.map = new HashMap<K, Collection<V>>();
    }

    public MultiValueMap(ValuesCollectionAllocator<V> valuesCollectionAllocator) {
        this.map = new HashMap<K, Collection<V>>();
        this.valuesCollectionAllocator = valuesCollectionAllocator;
    }

    public MultiValueMap(int n, float f) {
        this.map = new HashMap<K, Collection<V>>(n, f);
    }

    public MultiValueMap(int n, float f, ValuesCollectionAllocator<V> valuesCollectionAllocator) {
        this.map = new HashMap<K, Collection<V>>(n, f);
        this.valuesCollectionAllocator = valuesCollectionAllocator;
    }

    public MultiValueMap(int n) {
        this.map = new HashMap<K, Collection<V>>(n);
    }

    public MultiValueMap(MultiValueMap<K, V> multiValueMap) {
        super.makeShallowCopyInto(this);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultiValueMap<K, V> multiValueMap = new MultiValueMap<K, V>();
        this.makeShallowCopyInto(multiValueMap);
        return multiValueMap;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        boolean bl = false;
        Iterator<Collection<V>> iterator = this.map.values().iterator();
        while (!bl && iterator.hasNext()) {
            Collection<V> collection = iterator.next();
            if (!collection.contains(object)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean containsKeyValue(K k, V v) {
        boolean bl;
        block1: {
            V v2;
            bl = false;
            Collection<V> collection = this.getCollection(k);
            if (collection == null) break block1;
            Iterator<V> iterator = collection.iterator();
            while (iterator.hasNext() && !(bl = v.equals(v2 = iterator.next()))) {
            }
        }
        return bl;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MultiValueMap) {
            bl = ((MultiValueMap)object).entrySet().equals(this.entrySet());
        }
        return bl;
    }

    public Collection<V> getCollection(K k) {
        Collection<V> collection = this.map.get(k);
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    @Override
    public V get(Object object) {
        V v = null;
        Collection<V> collection = this.map.get(object);
        if (collection != null) {
            v = collection.iterator().next();
        }
        return v;
    }

    public V getFirstValueForKey(K k) {
        Iterator<V> iterator;
        V v = null;
        Collection<V> collection = this.map.get(k);
        if (collection != null && (iterator = collection.iterator()).hasNext()) {
            v = iterator.next();
        }
        return v;
    }

    @Override
    public int hashCode() {
        Set<Map.Entry<K, V>> set = this.entrySet();
        int n = 0;
        for (Map.Entry<K, V> entry : set) {
            n |= entry.hashCode();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K k, V v) {
        Collection<V> collection = this.map.get(k);
        if (collection == null) {
            collection = this.valuesCollectionAllocator.newValuesCollection();
            this.map.put(k, collection);
        }
        collection.add(v);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K k : map.keySet()) {
            V v = map.get(k);
            if (v == null) continue;
            this.put(k, v);
        }
    }

    @Override
    public void putAll(MultiValueMap<K, V> multiValueMap) {
        for (K k : multiValueMap.keySet()) {
            Collection<V> collection = multiValueMap.getCollection(k);
            if (collection == null) continue;
            for (V v : collection) {
                this.put(k, v);
            }
        }
    }

    public void putAll(K k, Collection<V> collection) {
        for (V v : collection) {
            this.put(k, v);
        }
    }

    public Collection<V> delete(K k) {
        return this.map.remove(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object, Object object2) {
        boolean bl = false;
        MultiValueMap multiValueMap = this;
        synchronized (multiValueMap) {
            Collection<V> collection = this.map.get(object);
            if (collection != null) {
                bl = collection.remove(object2);
                if (collection.size() == 0) {
                    this.map.remove(object);
                }
            }
        }
        return bl;
    }

    @Override
    public int size() {
        int n = 0;
        for (K k : this.keySet()) {
            Collection<V> collection = this.map.get(k);
            if (collection == null) continue;
            n += collection.size();
        }
        return n;
    }

    public int totalValuesForKey(K k) {
        int n = 0;
        Collection<V> collection = this.getCollection(k);
        if (collection != null) {
            n = collection.size();
        }
        return n;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> arrayList = new ArrayList<V>();
        for (K k : this.keySet()) {
            arrayList.addAll(this.getCollection(k));
        }
        return arrayList;
    }

    public Collection<V> getValuesForKey(K k) {
        Collection<V> collection = this.getCollection(k);
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public int getValuesForKey(K k, Collection<V> collection) {
        Collection<V> collection2 = this.map.get(k);
        int n = 0;
        if (collection2 != null) {
            collection.addAll(collection2);
            n = collection2.size();
        }
        return n;
    }

    private int keyValueHashCode(Object object, Object object2) {
        if (object2 == null) {
            object2 = "\u0002";
        }
        return new String(object.toString() + "\u0001" + object2.toString()).hashCode();
    }

    private void makeShallowCopyInto(MultiValueMap<K, V> multiValueMap) {
        for (K k : this.map.keySet()) {
            Collection<V> collection = this.map.get(k);
            Collection<V> collection2 = this.valuesCollectionAllocator.newValuesCollection();
            collection2.addAll(collection);
            multiValueMap.map.put(k, collection2);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Map.Entry<K, V> entry) {
            return MultiValueMap.this.containsKeyValue(entry.getKey(), entry.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MultiValueMapEntryIterator();
        }

        @Override
        public boolean remove(Object object) {
            MultiValueMapEntry multiValueMapEntry = (MultiValueMapEntry)object;
            return MultiValueMap.this.remove(multiValueMapEntry.getKey(), multiValueMapEntry.getValue());
        }

        @Override
        public int size() {
            return MultiValueMap.this.size();
        }
    }

    private class MultiValueMapEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<K> keys;
        private Iterator<V> curValues;
        private MultiValueMapEntry lastReturned;

        MultiValueMapEntryIterator() {
            this.keys = MultiValueMap.this.keySet().iterator();
            this.curValues = null;
            this.lastReturned = null;
        }

        @Override
        public boolean hasNext() {
            boolean bl;
            boolean bl2 = bl = this.curValues != null && this.curValues.hasNext();
            if (!bl) {
                bl = this.keys.hasNext();
            }
            return bl;
        }

        @Override
        public Map.Entry<K, V> next() {
            MultiValueMapEntry multiValueMapEntry = null;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.curValues == null || !this.curValues.hasNext()) {
                Object k = this.keys.next();
                this.curValues = MultiValueMap.this.getCollection(k).iterator();
                Object v = this.curValues.next();
                multiValueMapEntry = this.lastReturned = new MultiValueMapEntry(k, v);
            }
            return multiValueMapEntry;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Nothing to remove");
            }
            MultiValueMap.this.remove(this.lastReturned.getKey(), this.lastReturned.getValue());
        }
    }

    private class MultiValueMapEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        MultiValueMapEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                bl = entry.getKey().equals(this.key) && entry.getValue().equals(this.value);
            }
            return bl;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return MultiValueMap.this.keyValueHashCode(this.key, this.value);
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ValuesCollectionAllocator<V> {
        public Collection<V> newValuesCollection();
    }
}

