/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.clapper.util.misc.BundleUtil;

public class NestedException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String resourceBundleName = null;
    private String bundleMessageKey = null;
    private String defaultMessage = null;
    private Object[] messageParams = null;

    public NestedException() {
    }

    public NestedException(Throwable throwable) {
        this(throwable.getMessage(), throwable);
    }

    public NestedException(String string) {
        super(string);
    }

    public NestedException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public NestedException(String string, String string2, String string3) {
        this(string, string2, string3, null, null);
    }

    public NestedException(String string, String string2, String string3, Object[] objectArray) {
        this(string, string2, string3, objectArray, null);
    }

    public NestedException(String string, String string2, String string3, Throwable throwable) {
        this(string, string2, string3, null, throwable);
    }

    public NestedException(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.initCause(throwable);
        this.resourceBundleName = string;
        this.bundleMessageKey = string2;
        this.defaultMessage = string3;
        this.messageParams = objectArray;
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        if (this.resourceBundleName != null && this.bundleMessageKey != null) {
            string = BundleUtil.getMessage(this.resourceBundleName, locale, this.bundleMessageKey, this.defaultMessage, this.messageParams);
        }
        if (string == null && (string = this.defaultMessage) == null) {
            string = super.getMessage();
        }
        if (string != null) {
            stringBuilder.append(string);
        } else {
            Throwable throwable;
            for (throwable = this.getCause(); throwable != null && string == null; throwable = throwable.getCause()) {
                if (throwable instanceof NestedException) {
                    string = ((NestedException)throwable).getMessage(locale);
                    break;
                }
                string = throwable.getMessage();
            }
            if (string != null) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(this.getClass().getName());
                if (throwable != null) {
                    stringBuilder.append(" (contains ");
                    stringBuilder.append(throwable.getClass().getName());
                    stringBuilder.append(")");
                }
            }
        }
        return stringBuilder.toString();
    }

    public String getMessages() {
        return this.getMessages(false);
    }

    public String getMessages(boolean bl) {
        return this.getMessages(bl, null);
    }

    public String getMessages(boolean bl, Locale locale) {
        String string;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Throwable throwable = this;
        StringBuffer stringBuffer = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (bl) {
            stringBuffer = new StringBuffer();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        while (throwable != null) {
            string = throwable instanceof NestedException ? throwable.getMessage(locale) : ((Throwable)throwable).getMessage();
            if (string == null) {
                string = ((Throwable)throwable).toString();
            }
            if (bl) {
                try {
                    String string2;
                    LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
                    String string3 = "";
                    stringBuffer.setLength(0);
                    while ((string2 = lineNumberReader.readLine()) != null) {
                        stringBuffer.append(string3);
                        stringBuffer.append(string2);
                        string3 = " ";
                    }
                    string = stringBuffer.toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!linkedHashSet.contains(string)) {
                linkedHashSet.add(string);
            }
            throwable = throwable.getCause();
        }
        string = "";
        for (String string2 : linkedHashSet) {
            if (bl) {
                printWriter.print(string);
                printWriter.print(string2);
                string = ": ";
                continue;
            }
            printWriter.println(string2);
        }
        return stringWriter.getBuffer().toString();
    }

    public Throwable getNestedException() {
        return this.getCause();
    }

    @Override
    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getMessage();
        return string2 != null ? string + ": " + string2 : string;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(Locale locale) {
        this.printStackTrace(System.err, locale);
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
    }

    public void printStackTrace(PrintWriter printWriter, Locale locale) {
        if (locale == null) {
            super.printStackTrace(printWriter);
        } else {
            Locale locale2 = Locale.getDefault();
            Locale.setDefault(locale);
            super.printStackTrace(printWriter);
            printWriter.flush();
            Locale.setDefault(locale2);
        }
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
    }

    public void printStackTrace(PrintStream printStream, Locale locale) {
        this.printStackTrace(new PrintWriter(printStream), locale);
    }
}

