/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.util.Date;
import org.clapper.util.misc.Semaphore;
import org.clapper.util.misc.SemaphoreException;

public class ObjectLockSemaphore
implements Semaphore {
    private int count = 0;

    public ObjectLockSemaphore(int n) {
        this.count = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire(long l) throws SemaphoreException {
        boolean bl = false;
        ObjectLockSemaphore objectLockSemaphore = this;
        synchronized (objectLockSemaphore) {
            if (this.count > 0) {
                bl = true;
            } else if (l == 0L) {
                this.waitForever();
                bl = true;
            } else if (l > 0L) {
                bl = this.waitOrTimeOut(l);
            }
            if (bl) {
                --this.count;
            }
            this.notifyAll();
        }
        return bl;
    }

    @Override
    public boolean acquire() throws SemaphoreException {
        return this.acquire(0L);
    }

    @Override
    public synchronized void addToCount(int n) throws SemaphoreException {
        this.count += n;
        this.notifyAll();
    }

    @Override
    public synchronized int getValue() throws SemaphoreException {
        return this.count;
    }

    @Override
    public synchronized void release() throws SemaphoreException {
        ++this.count;
        this.notifyAll();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Semaphore[");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append(", value=");
        stringBuilder.append(String.valueOf(this.count));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void waitForever() {
        boolean bl = false;
        while (!bl) {
            try {
                this.wait();
                if (this.count <= 0) continue;
                bl = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean waitOrTimeOut(long l) {
        Date date;
        boolean bl = false;
        Date date2 = new Date();
        for (long i = 0L; !bl && i < l; i += date.getTime() - date2.getTime()) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            date = new Date();
            if (this.count <= 0) continue;
            bl = true;
        }
        return bl;
    }
}

