/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OrderedHashMap<K, V>
extends HashMap<K, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedList<K> keysInOrder = new LinkedList();

    public OrderedHashMap() {
    }

    public OrderedHashMap(int n) {
        super(n);
    }

    public OrderedHashMap(int n, float f) {
        super(n, f);
    }

    public OrderedHashMap(Map<? extends K, ? extends V> map) {
        super(map);
        this.keysInOrder.addAll(map.keySet());
    }

    public OrderedHashMap(OrderedHashMap<? extends K, ? extends V> orderedHashMap) {
        super(orderedHashMap);
        this.keysInOrder.addAll(orderedHashMap.keysInOrder);
    }

    public int getKeysInInsertionOrder(List<? super K> list) {
        list.addAll(this.keysInOrder);
        return this.keysInOrder.size();
    }

    public List<K> keysInInsertionOrder() {
        return new ArrayList<K>(this.keysInOrder);
    }

    @Override
    public Object clone() {
        return new OrderedHashMap<K, V>(this);
    }

    @Override
    public void clear() {
        super.clear();
        this.keysInOrder.clear();
    }

    @Override
    public V put(K k, V v) {
        V v2 = super.put(k, v);
        this.keysInOrder.remove(k);
        this.keysInOrder.add(k);
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (K k : map.keySet()) {
            V v = map.get(k);
            this.put(k, v);
        }
    }

    @Override
    public void putAll(OrderedHashMap<? extends K, ? extends V> orderedHashMap) {
        for (K k : orderedHashMap.keysInInsertionOrder()) {
            Object v = orderedHashMap.get(k);
            this.put(k, v);
        }
    }

    @Override
    public V remove(Object object) {
        Object v = super.remove(object);
        this.keysInOrder.remove(object);
        return v;
    }
}

