/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesMap
extends AbstractMap<String, String>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private EntrySet entrySetResult = null;
    private Properties properties = null;

    public PropertiesMap(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.properties.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.properties.containsValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        PropertiesMap propertiesMap = this;
        synchronized (propertiesMap) {
            if (this.entrySetResult == null) {
                this.entrySetResult = new EntrySet();
            }
        }
        return this.entrySetResult;
    }

    @Override
    public String get(Object object) {
        return this.properties.getProperty((String)object);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new KeySet();
    }

    @Override
    public String put(String string, String string2) {
        String string3 = (String)this.properties.setProperty(string, string2);
        this.entrySetResult = null;
        return string3;
    }

    @Override
    public String remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    private class KeySetIterator
    implements Iterator<String> {
        private Enumeration<?> propertyNames;

        KeySetIterator() {
            this.propertyNames = PropertiesMap.this.properties.propertyNames();
        }

        @Override
        public String next() {
            return (String)this.propertyNames.nextElement();
        }

        @Override
        public boolean hasNext() {
            return this.propertyNames.hasMoreElements();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean contains(Object object) {
            return PropertiesMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return PropertiesMap.this.remove(object) != null;
        }

        @Override
        public int size() {
            return PropertiesMap.this.size();
        }

        @Override
        public void clear() {
            PropertiesMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private Set<PropertiesMapEntry> entrySetResult = new HashSet<PropertiesMapEntry>();

        EntrySet() {
            KeySet keySet = new KeySet();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                this.entrySetResult.add(new PropertiesMapEntry(iterator.next()));
            }
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){
                Iterator<PropertiesMapEntry> it;
                {
                    this.it = EntrySet.this.entrySetResult.iterator();
                }

                @Override
                public Map.Entry<String, String> next() {
                    return this.it.next();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = false;
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                bl = PropertiesMap.this.containsKey(k);
            }
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            return PropertiesMap.this.remove(object) != null;
        }

        @Override
        public int size() {
            return PropertiesMap.this.size();
        }

        @Override
        public void clear() {
            PropertiesMap.this.clear();
        }
    }

    private class PropertiesMapEntry
    implements Map.Entry<String, String> {
        private String key = null;

        PropertiesMapEntry(String string) {
            this.key = string;
        }

        @Override
        public boolean equals(Object object) {
            return PropertiesMapEntry.class.isInstance(object);
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return PropertiesMap.this.get(this.key);
        }

        @Override
        public String setValue(String string) {
            return PropertiesMap.this.put(this.key, string);
        }
    }
}

