/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.util.ArrayList;
import java.util.Collection;

public class SparseArrayList<T>
extends ArrayList<T> {
    public SparseArrayList() {
    }

    public SparseArrayList(int n) {
        super(n);
    }

    public SparseArrayList(Collection<T> collection) {
        super(collection);
    }

    @Override
    public void add(int n, T t) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index " + n + " is negative.");
        }
        if (n >= this.size()) {
            this.set(n, t);
        } else {
            super.add(n, t);
        }
    }

    @Override
    public T set(int n, T t) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index " + n + " is negative.");
        }
        int n2 = this.size();
        if (n >= n2) {
            int n3 = n + 1;
            this.ensureCapacity(n3);
            while (n2++ < n3) {
                super.add(null);
            }
        }
        return super.set(n, t);
    }
}

