/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.clapper.util.misc.BuildInfo;
import org.clapper.util.misc.BundleUtil;

public abstract class VersionBase {
    protected VersionBase() {
    }

    public String getVersion() {
        return BundleUtil.getString(this.getVersionBundleName(), this.getVersionKey(), "?");
    }

    public String getCopyright() {
        return BundleUtil.getString(this.getVersionBundleName(), this.getCopyrightKey(), "?");
    }

    public String getApplicationName() {
        return BundleUtil.getString(this.getVersionBundleName(), this.getApplicationNameKey(), "?");
    }

    public String getVersionDisplay() {
        BuildInfo buildInfo = new BuildInfo(this.getBuildInfoBundleName());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string = this.getVersionBundleName();
        printWriter.print(BundleUtil.getString(string, this.getApplicationNameKey(), "Unknown application"));
        printWriter.print(", version ");
        printWriter.println(this.getVersion());
        printWriter.println(this.getCopyright());
        printWriter.println();
        printWriter.println("Build:          " + buildInfo.getBuildID());
        printWriter.println("Build date:     " + buildInfo.getBuildDate());
        printWriter.println("Built by:       " + buildInfo.getBuildUserID());
        printWriter.println("Built on:       " + buildInfo.getBuildOperatingSystem());
        printWriter.println("Build Java VM:  " + buildInfo.getBuildJavaVM());
        printWriter.println("Build compiler: " + buildInfo.getBuildJavaCompiler());
        printWriter.print("Ant version:    " + buildInfo.getBuildAntVersion());
        return stringWriter.getBuffer().toString();
    }

    protected abstract String getVersionBundleName();

    protected abstract String getBuildInfoBundleName();

    protected abstract String getVersionKey();

    protected abstract String getCopyrightKey();

    protected abstract String getApplicationNameKey();
}

