/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.misc.LRUMap;
import org.clapper.util.regex.RegexException;
import org.clapper.util.text.TextUtil;

public class RegexUtil {
    public static final int DEFAULT_LRU_BUFFER_SIZE = 20;
    private LRUMap<Substitution, Pattern> compiledRegexps = new LRUMap(100);

    public String substitute(String string, String string2) throws RegexException {
        Pattern pattern;
        if (string.length() < 5) {
            throw new RegexException("org.clapper.util.regex.Bundle", "RegexUtil.substitutionCommandTooShort", "Substitution command \"{0}\" is too short.", new Object[]{string});
        }
        if (string.charAt(0) != 's') {
            throw new RegexException("org.clapper.util.regex.Bundle", "RegexUtil.badSubstitutionSyntax", "\"{0}\" is a syntactically incorrect substitution command.", new Object[]{string});
        }
        char c = string.charAt(1);
        if (Character.isWhitespace(c) || Character.isLetter(c)) {
            throw new RegexException("org.clapper.util.regex.Bundle", "RegexUtil.badSubstitutionDelim", "Substitution command \"{0}\" uses alphabetic or white-space delimiter \"{1}\".", new Object[]{string, String.valueOf(c)});
        }
        String[] stringArray = TextUtil.split(string, c, true);
        if (stringArray.length != 3 && stringArray.length != 4) {
            throw new RegexException("org.clapper.util.regex.Bundle", "RegexUtil.badSubstitutionSyntax", "\"{0}\" is a syntactically incorrect substitution command.", new Object[]{string});
        }
        assert (stringArray[0].length() == 1 && stringArray[0].charAt(0) == 's');
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        Substitution substitution = new Substitution(string3);
        if (stringArray.length == 4) {
            this.getSubstitutionFlags(string, stringArray[3], substitution);
        }
        if ((pattern = this.compiledRegexps.get(substitution)) == null) {
            try {
                pattern = Pattern.compile(string3, substitution.flags);
                this.compiledRegexps.put(substitution, pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new RegexException(patternSyntaxException);
            }
        }
        String string5 = string2;
        Matcher matcher = pattern.matcher(string2);
        string5 = substitution.replaceAll ? matcher.replaceAll(string4) : matcher.replaceFirst(string4);
        return string5;
    }

    private void getSubstitutionFlags(String string, String string2, Substitution substitution) throws RegexException {
        char[] cArray = string2.toCharArray();
        block7: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case 'g': {
                    substitution.replaceAll = true;
                    continue block7;
                }
                case 'i': {
                    substitution.flags |= 2;
                    continue block7;
                }
                case 'm': {
                    substitution.flags |= 8;
                    continue block7;
                }
                case 'o': {
                    continue block7;
                }
                case 'x': {
                    substitution.flags |= 4;
                    continue block7;
                }
                default: {
                    throw new RegexException("org.clapper.util.regex.Bundle", "RegexUtil.badSubstitutionModifier", "Substitution command \"{0}\" has unknown modifier character\"{1}\".", new Object[]{string, String.valueOf(c)});
                }
            }
        }
    }

    private class Substitution {
        int flags = 0;
        boolean replaceAll = false;
        String regex = null;
        int hc = -1;

        Substitution(String string) {
            this.regex = string;
        }

        public synchronized int hashCode() {
            if (this.hc == -1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.regex);
                stringBuffer.append(String.valueOf(this.replaceAll));
                stringBuffer.append(String.valueOf(this.flags));
                this.hc = stringBuffer.toString().hashCode();
            }
            return this.hc;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Substitution) {
                bl = this.regex.equals(((Substitution)object).regex) && this.flags == ((Substitution)object).flags && this.replaceAll == ((Substitution)object).replaceAll;
            }
            return bl;
        }
    }
}

