/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.clapper.util.misc.XResourceBundle;
import org.clapper.util.text.TextUtil;

public final class Duration {
    private static final long SECOND_MS = 1000L;
    private static final long MINUTE_MS = 60000L;
    private static final long HOUR_MS = 3600000L;
    private static final long DAY_MS = 86400000L;
    private static final long WEEK_MS = 604800000L;
    private static final String BUNDLE_NAME = Duration.class.getName() + "Bundle";
    private long duration_in_ms = 0L;

    public Duration() {
        this(0L);
    }

    public Duration(long l) {
        this.duration_in_ms = l;
    }

    public Duration(Date date, Date date2) {
        long l = date.getTime();
        long l2 = date2.getTime();
        this.duration_in_ms = Math.abs(l - l2);
    }

    public Duration(String string, Locale locale) throws ParseException {
        this.parse(string, locale);
    }

    public Duration(String string) throws ParseException {
        this.parse(string, Locale.getDefault());
    }

    public long getDuration() {
        return this.duration_in_ms;
    }

    public String format() {
        return this.format(Locale.getDefault());
    }

    public String format(Locale locale) {
        Map<DurationType, DurationForFormat> map = this.getFormatterMap(locale);
        long l = this.duration_in_ms;
        long l2 = l / 86400000L;
        long l3 = (l -= l2 * 86400000L) / 3600000L;
        long l4 = (l -= l3 * 3600000L) / 60000L;
        long l5 = (l -= l4 * 60000L) / 1000L;
        l -= l5 * 1000L;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        if (l2 > 0L) {
            this.formatForDurationUnit(l2, map.get((Object)DurationType.DAY), stringBuilder, string);
            string = ", ";
        }
        if (l3 > 0L) {
            this.formatForDurationUnit(l3, map.get((Object)DurationType.HOUR), stringBuilder, string);
            string = ", ";
        }
        if (l4 > 0L) {
            this.formatForDurationUnit(l4, map.get((Object)DurationType.MINUTE), stringBuilder, string);
            string = ", ";
        }
        if (l5 > 0L) {
            this.formatForDurationUnit(l5, map.get((Object)DurationType.SECOND), stringBuilder, string);
            string = ", ";
        }
        if (l > 0L) {
            this.formatForDurationUnit(l, map.get((Object)DurationType.MILLISECOND), stringBuilder, string);
            string = ", ";
        }
        return stringBuilder.toString();
    }

    public void parse(String string) throws ParseException {
        this.parse(string, Locale.getDefault());
    }

    public void parse(String string, Locale locale) throws ParseException {
        Map<String, DurationType> map = this.getParserMap(locale);
        String[] stringArray = TextUtil.split(string, ", ");
        if (stringArray.length % 2 != 0) {
            throw new ParseException("Malformed duration string \"" + string + "\"", 0);
        }
        this.duration_in_ms = 0L;
        block10: for (int i = 0; i < stringArray.length; i += 2) {
            long l = 0L;
            try {
                l = Long.parseLong(stringArray[i]);
                if (l < 0L) {
                    throw new ParseException("Unexpected negative value in \"" + string + "\"", 0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("In \"" + string + "\", Expected numeric token \"" + stringArray[i] + "\" is not numeric.", 0);
            }
            DurationType durationType = map.get(stringArray[i + 1].toLowerCase());
            if (durationType == null) {
                throw new ParseException("In \"" + string + "\", found unknown duration \"" + stringArray[i + 1] + "\"", 0);
            }
            switch (durationType) {
                case MILLISECOND: {
                    this.duration_in_ms += l;
                    continue block10;
                }
                case SECOND: {
                    this.duration_in_ms += l * 1000L;
                    continue block10;
                }
                case MINUTE: {
                    this.duration_in_ms += l * 60000L;
                    continue block10;
                }
                case HOUR: {
                    this.duration_in_ms += l * 3600000L;
                    continue block10;
                }
                case DAY: {
                    this.duration_in_ms += l * 86400000L;
                    continue block10;
                }
                case WEEK: {
                    this.duration_in_ms += l * 604800000L;
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getDuration());
    }

    private void formatForDurationUnit(long l, DurationForFormat durationForFormat, StringBuilder stringBuilder, String string) {
        if (durationForFormat == null) {
            throw new IllegalStateException("Unexpected null DurationForFormat");
        }
        if (l > 0L) {
            String string2 = l == 1L ? durationForFormat.singular : durationForFormat.plural;
            stringBuilder.append(string);
            stringBuilder.append(String.valueOf(l));
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
    }

    private Map<DurationType, DurationForFormat> getFormatterMap(Locale locale) {
        HashMap<DurationType, DurationForFormat> hashMap = new HashMap<DurationType, DurationForFormat>();
        XResourceBundle xResourceBundle = XResourceBundle.getXResourceBundle(BUNDLE_NAME, locale);
        this.loadBundle(xResourceBundle, null, hashMap);
        return hashMap;
    }

    private Map<String, DurationType> getParserMap(Locale locale) throws IllegalStateException {
        HashMap<String, DurationType> hashMap = new HashMap<String, DurationType>();
        XResourceBundle xResourceBundle = XResourceBundle.getXResourceBundle(BUNDLE_NAME, locale);
        this.loadBundle(xResourceBundle, hashMap, null);
        xResourceBundle = XResourceBundle.getXResourceBundle(BUNDLE_NAME);
        this.loadBundle(xResourceBundle, hashMap, null);
        return hashMap;
    }

    private void loadBundle(XResourceBundle xResourceBundle, Map<String, DurationType> map, Map<DurationType, DurationForFormat> map2) throws IllegalStateException {
        this.parseTokensFor(DurationType.MILLISECOND, xResourceBundle.getString("millisecondTokens", "millisecond/milliseconds/ms"), map, map2);
        this.parseTokensFor(DurationType.SECOND, xResourceBundle.getString("secondTokens", "second/seconds/sec/secs"), map, map2);
        this.parseTokensFor(DurationType.MINUTE, xResourceBundle.getString("minuteTokens", "minute/minutes/min/mins"), map, map2);
        this.parseTokensFor(DurationType.HOUR, xResourceBundle.getString("hourTokens", "hour/hours/hr/hrs"), map, map2);
        this.parseTokensFor(DurationType.DAY, xResourceBundle.getString("dayTokens", "day/days"), map, map2);
        this.parseTokensFor(DurationType.WEEK, xResourceBundle.getString("weekTokens", "week/weeks"), map, map2);
    }

    private void parseTokensFor(DurationType durationType, String string, Map<String, DurationType> map, Map<DurationType, DurationForFormat> map2) throws IllegalStateException {
        String[] stringArray = TextUtil.split(string, '/');
        if (stringArray.length < 2) {
            throw new IllegalStateException("Error in resource bundle: Must have at least two tokens in duration string. \"" + string + "\" only has " + stringArray.length);
        }
        if (map != null) {
            for (String string2 : stringArray) {
                map.put(string2.toLowerCase(), durationType);
            }
        }
        if (map2 != null) {
            map2.put(durationType, new DurationForFormat(stringArray[0].toLowerCase(), stringArray[1].toLowerCase()));
        }
    }

    private static class DurationForFormat {
        final String singular;
        final String plural;

        DurationForFormat(String string, String string2) {
            this.singular = string;
            this.plural = string2;
        }
    }

    private static enum DurationType {
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK;

    }
}

