/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public final class TextUtil {
    public static final char[] HEXADECIMAL_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final RomanNumberTableEntry[] ROMAN_NUMBER_TABLE = new RomanNumberTableEntry[]{new RomanNumberTableEntry("M", 1000), new RomanNumberTableEntry("CM", 900), new RomanNumberTableEntry("D", 500), new RomanNumberTableEntry("CD", 400), new RomanNumberTableEntry("C", 100), new RomanNumberTableEntry("XC", 90), new RomanNumberTableEntry("L", 50), new RomanNumberTableEntry("XL", 40), new RomanNumberTableEntry("X", 10), new RomanNumberTableEntry("IX", 9), new RomanNumberTableEntry("V", 5), new RomanNumberTableEntry("IV", 4), new RomanNumberTableEntry("I", 1)};

    private TextUtil() {
    }

    public static boolean booleanFromString(String string) throws IllegalArgumentException {
        boolean bl;
        if ((string = string.toLowerCase()).equals("true") || string.equals("1") || string.equals("yes") || string.equals("y")) {
            bl = true;
        } else if (string.equals("false") || string.equals("0") || string.equals("no") || string.equals("n")) {
            bl = false;
        } else {
            throw new IllegalArgumentException("Bad boolean string: \"" + string + "\"");
        }
        return bl;
    }

    public static String[] split(String string) {
        return TextUtil.split(string, (String)null);
    }

    public static String[] split(String string, boolean bl) {
        return TextUtil.split(string, (String)null, bl);
    }

    public static int split(String string, Collection<String> collection) {
        return TextUtil.split(string, collection, false);
    }

    public static int split(String string, Collection<String> collection, boolean bl) {
        return TextUtil.split(string, null, collection, bl);
    }

    public static String[] split(String string, char c) {
        return TextUtil.split(string, "" + c, false);
    }

    public static String[] split(String string, char c, boolean bl) {
        return TextUtil.split(string, String.valueOf(c), bl);
    }

    public static String[] split(String string, String string2) {
        return TextUtil.split(string, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] split(String string, String string2, boolean bl) {
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 == null) {
            string2 = " \t\n\r";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, bl);
        boolean bl2 = true;
        while (true) {
            String string3;
            block6: {
                if (!stringTokenizer.hasMoreTokens()) {
                    stringArray = new String[arrayList.size()];
                    arrayList.toArray(stringArray);
                    return stringArray;
                }
                string3 = stringTokenizer.nextToken();
                if (bl && string3.length() == 1 && string2.indexOf(string3.charAt(0)) != -1) {
                    if (bl2) {
                        string3 = "";
                        break block6;
                    } else {
                        bl2 = true;
                        continue;
                    }
                }
                bl2 = false;
            }
            arrayList.add(string3);
        }
    }

    public static int split(String string, char c, Collection<String> collection) {
        return TextUtil.split(string, String.valueOf(c), collection);
    }

    public static int split(String string, char c, Collection<String> collection, boolean bl) {
        return TextUtil.split(string, String.valueOf(c), collection, bl);
    }

    public static int split(String string, String string2, Collection<String> collection) {
        return TextUtil.split(string, string2, collection, false);
    }

    public static int split(String string, String string2, Collection<String> collection, boolean bl) {
        String[] stringArray = TextUtil.split(string, string2, bl);
        for (int i = 0; i < stringArray.length; ++i) {
            collection.add(stringArray[i]);
        }
        return stringArray.length;
    }

    public static String join(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(stringArray[i]);
            string2 = string;
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String ... stringArray) {
        return TextUtil.join(stringArray, string);
    }

    public static String join(String[] stringArray, char c) {
        return TextUtil.join(stringArray, "" + c);
    }

    public static String join(String[] stringArray, int n, int n2, char c) {
        return TextUtil.join(stringArray, n, n2, "" + c);
    }

    public static String join(String[] stringArray, int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        while (n < n2) {
            stringBuilder.append(string2);
            stringBuilder.append(stringArray[n]);
            string2 = string;
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String join(char c, String ... stringArray) {
        return TextUtil.join(stringArray, "" + c);
    }

    public static String join(Collection<? extends Object> collection, String string) {
        String string2 = "";
        if (collection.size() > 0) {
            int n = 0;
            for (Object object : collection) {
                if (object == null) continue;
                ++n;
            }
            String[] stringArray = new String[n];
            n = 0;
            for (Object object : collection) {
                if (object == null) continue;
                stringArray[n++] = object.toString();
            }
            string2 = TextUtil.join(stringArray, string);
        }
        return string2;
    }

    public static String join(Collection<? extends Object> collection, char c) {
        return TextUtil.join(collection, "" + c);
    }

    public static boolean stringIsEmpty(String string) {
        boolean bl = true;
        if (string != null) {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (Character.isWhitespace(cArray[i])) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static String rightJustifyString(String string, int n) {
        return TextUtil.rightJustifyString(string, n, ' ');
    }

    public static String rightJustifyString(String string, int n, char c) {
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = string.length();
        int n3 = n < n2 ? 0 : n - n2;
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String leftJustifyString(String string, int n) {
        return TextUtil.leftJustifyString(string, n, ' ');
    }

    public static String leftJustifyString(String string, int n, char c) {
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = string.length();
        int n3 = n < n2 ? 0 : n - n2;
        stringBuilder.append(string);
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String centerString(String string, int n) {
        return TextUtil.centerString(string, n, ' ');
    }

    public static String centerString(String string, int n, char c) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(n);
        int n3 = string.length();
        int n4 = n < n3 ? 0 : n - n3;
        int n5 = n2 = n4 / 2;
        int n6 = n2 + n4 % 2;
        for (n2 = 0; n2 < n5; ++n2) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        for (n2 = 0; n2 < n6; ++n2) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static StringBuilder hexadecimalForByte(byte by, StringBuilder stringBuilder) {
        int n = by >>> 4 & 0xF;
        stringBuilder.append(HEXADECIMAL_DIGITS[n]);
        n = by & 0xF;
        stringBuilder.append(HEXADECIMAL_DIGITS[n]);
        return stringBuilder;
    }

    public static StringBuilder hexadecimalForByte(int n, StringBuilder stringBuilder) {
        int n2 = n >>> 4 & 0xF;
        stringBuilder.append(HEXADECIMAL_DIGITS[n2]);
        n2 = n & 0xF;
        stringBuilder.append(HEXADECIMAL_DIGITS[n2]);
        return stringBuilder;
    }

    public static StringBuilder hexadecimalForBytes(byte[] byArray, int n, int n2, StringBuilder stringBuilder) {
        for (int i = n; i < n2; ++i) {
            TextUtil.hexadecimalForByte(byArray[i], stringBuilder);
        }
        return stringBuilder;
    }

    public static String hexadecimalForBytes(byte[] byArray) {
        return TextUtil.hexadecimalForBytes(byArray, 0, byArray.length, new StringBuilder()).toString();
    }

    public static StringBuilder hexadecimalForBytes(int[] nArray, int n, int n2, StringBuilder stringBuilder) {
        for (int i = n; i < n2; ++i) {
            TextUtil.hexadecimalForByte(nArray[i], stringBuilder);
        }
        return stringBuilder;
    }

    public static StringBuilder hexadecimalForNumber(int n, StringBuilder stringBuilder) {
        return TextUtil.encodeNumber(n, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, stringBuilder);
    }

    public static String hexadecimalForNumber(int n) {
        return TextUtil.encodeNumber(n, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, new StringBuilder()).toString();
    }

    public static StringBuilder hexadecimalForNumber(long l, StringBuilder stringBuilder) {
        return TextUtil.encodeNumber(l, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, stringBuilder);
    }

    public static String hexadecimalForNumber(long l) {
        return TextUtil.encodeNumber(l, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, new StringBuilder()).toString();
    }

    public static String hexadecimalForNumber(short s) {
        return TextUtil.encodeNumber(s, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, new StringBuilder()).toString();
    }

    public static StringBuilder hexadecimalForNumber(short s, StringBuilder stringBuilder) {
        return TextUtil.encodeNumber(s, HEXADECIMAL_DIGITS.length, HEXADECIMAL_DIGITS, stringBuilder);
    }

    public static StringBuilder encodeNumber(long l, int n, char[] cArray, StringBuilder stringBuilder) {
        char[] cArray2 = new char[64];
        int n2 = 0;
        while (l != 0L) {
            int n3 = (int)(l % (long)n);
            l /= (long)n;
            cArray2[n2++] = cArray[n3];
        }
        if (n2 == 0) {
            cArray2[n2++] = cArray[0];
        }
        while (--n2 >= 0) {
            stringBuilder.append(cArray2[n2]);
        }
        return stringBuilder;
    }

    public static StringBuilder encodeNumber(short s, int n, char[] cArray, StringBuilder stringBuilder) {
        char[] cArray2 = new char[16];
        int n2 = 0;
        while (s != 0) {
            int n3 = s % n;
            s = (short)(s / n);
            cArray2[n2++] = cArray[n3];
        }
        if (n2 == 0) {
            cArray2[n2++] = cArray[0];
        }
        while (--n2 >= 0) {
            stringBuilder.append(cArray2[n2]);
        }
        return stringBuilder;
    }

    public static StringBuilder encodeNumber(int n, int n2, char[] cArray, StringBuilder stringBuilder) {
        char[] cArray2 = new char[32];
        int n3 = 0;
        while (n != 0) {
            int n4 = n % n2;
            n /= n2;
            cArray2[n3++] = cArray[n4];
        }
        if (n3 == 0) {
            cArray2[n3++] = cArray[0];
        }
        while (--n3 >= 0) {
            stringBuilder.append(cArray2[n3]);
        }
        return stringBuilder;
    }

    public static byte[] bytesForHexadecimal(String string) throws NumberFormatException {
        byte[] byArray = null;
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuilder.append(stringTokenizer.nextToken());
        }
        int n = stringBuilder.length();
        if (n % 2 != 0) {
            throw new NumberFormatException("Hex string \"" + string + "\" does not have an even number of hex digits.");
        }
        string = stringBuilder.toString();
        byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            String string2 = string.substring(n2, n2 + 2);
            byArray[n3] = (byte)(Integer.parseInt(string2, 16) & 0xFF);
            n2 += 2;
            ++n3;
        }
        return byArray;
    }

    public static String romanNumeralsForNumber(int n) {
        assert (n > 0);
        StringBuilder stringBuilder = new StringBuilder();
        for (RomanNumberTableEntry romanNumberTableEntry : ROMAN_NUMBER_TABLE) {
            while (n >= romanNumberTableEntry.quantity) {
                stringBuilder.append(romanNumberTableEntry.romanString);
                n -= romanNumberTableEntry.quantity;
            }
        }
        return stringBuilder.toString();
    }

    public static String charToUnicodeEscape(char c, StringBuilder stringBuilder) {
        String string = Integer.toHexString(c);
        stringBuilder.append("\\u");
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String charToUnicodeEscape(char c) {
        return TextUtil.charToUnicodeEscape(c, new StringBuilder());
    }

    public static boolean isPrintable(char c) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        if (unicodeBlock == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_A) {
            int n = Character.getType(c);
            switch (n) {
                case 1: 
                case 2: 
                case 9: 
                case 12: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private static class RomanNumberTableEntry {
        final String romanString;
        final int quantity;

        RomanNumberTableEntry(String string, int n) {
            this.romanString = string;
            this.quantity = n;
        }
    }
}

