/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text;

import org.clapper.util.text.AbstractVariableSubstituter;
import org.clapper.util.text.UndefinedVariableException;
import org.clapper.util.text.VariableDereferencer;
import org.clapper.util.text.VariableNameChecker;
import org.clapper.util.text.VariableSubstitutionException;
import org.clapper.util.text.VariableSyntaxException;

public class UnixShellVariableSubstituter
extends AbstractVariableSubstituter {
    private static final char VAR_START = '$';
    private static final char VAR_OPEN_BRACE = '{';
    private static final char VAR_CLOSE_BRACE = '}';
    private static final char VAR_IF_EXISTS_OP = '?';
    public static final String VARIABLE_METACHARACTERS = new String(new char[]{'$', '{', '}', '?'});
    private boolean honorEscapes = false;

    public boolean getHonorEscapes() {
        return this.honorEscapes;
    }

    public void setHonorEscapes(boolean bl) {
        this.honorEscapes = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String substitute(String string, VariableDereferencer variableDereferencer, VariableNameChecker variableNameChecker, Object object, boolean bl) throws VariableSyntaxException, UndefinedVariableException, VariableSubstitutionException {
        boolean bl2 = this.getHonorEscapes();
        this.setHonorEscapes(bl);
        try {
            String string2 = this.substitute(string, variableDereferencer, variableNameChecker, object);
            return string2;
        }
        finally {
            this.setHonorEscapes(bl2);
        }
    }

    @Override
    public String substitute(String string, VariableDereferencer variableDereferencer, VariableNameChecker variableNameChecker, Object object) throws VariableSyntaxException, UndefinedVariableException, VariableSubstitutionException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        ParseState parseState = ParseState.NOT_IN_VAR;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (variableNameChecker == null) {
            variableNameChecker = this;
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < n && !bl3) {
            char c = cArray[n2++];
            if (bl2) {
                stringBuilder.append(c);
                bl2 = false;
                continue;
            }
            if (parseState == ParseState.NOT_IN_VAR) {
                if (c == '$') {
                    parseState = ParseState.IN_VAR;
                    continue;
                }
                if (this.honorEscapes && c == '\\') {
                    bl2 = true;
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (parseState == ParseState.IN_DEFAULT_VALUE) {
                if (c == '}') {
                    parseState = ParseState.IN_VAR;
                    --n2;
                    continue;
                }
                stringBuilder3.append(c);
                continue;
            }
            if (stringBuilder2.length() == 0 && c == '{') {
                bl = true;
                continue;
            }
            if (bl && c == '?') {
                parseState = ParseState.IN_DEFAULT_VALUE;
                continue;
            }
            if (variableNameChecker.legalVariableCharacter(c)) {
                stringBuilder2.append(c);
                continue;
            }
            String string2 = stringBuilder2.toString();
            parseState = ParseState.NOT_IN_VAR;
            if (bl) {
                if (c == '}') {
                    stringBuilder.append(this.dereference(string2, stringBuilder3.toString(), object, variableDereferencer));
                } else {
                    stringBuilder.append('$');
                    stringBuilder.append('{');
                    stringBuilder.append(stringBuilder2.toString());
                    --n2;
                    bl3 = true;
                }
                bl = false;
            } else if (stringBuilder2.length() == 0) {
                stringBuilder.append('$');
                --n2;
                bl3 = true;
            } else {
                stringBuilder.append(this.dereference(string2, stringBuilder3.toString(), object, variableDereferencer));
                --n2;
            }
            stringBuilder2.setLength(0);
        }
        if (parseState == ParseState.IN_VAR) {
            if (bl) {
                stringBuilder.append('$');
                stringBuilder.append('{');
                stringBuilder.append(stringBuilder2.toString());
                bl3 = true;
            } else if (stringBuilder2.length() == 0) {
                stringBuilder.append('$');
            } else {
                stringBuilder.append(this.dereference(stringBuilder2.toString(), stringBuilder3.toString(), object, variableDereferencer));
            }
        }
        if (bl3 && this.getAbortOnSyntaxError()) {
            throw new VariableSyntaxException("Syntax error in reference to variable \"" + stringBuilder2.toString() + "\"");
        }
        return stringBuilder.toString();
    }

    public static boolean isVariableMetacharacter(char c) {
        boolean bl = false;
        char[] cArray = VARIABLE_METACHARACTERS.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String dereference(String string, String string2, Object object, VariableDereferencer variableDereferencer) throws VariableSubstitutionException {
        String string3 = variableDereferencer.getVariableValue(string, object);
        if (string3 == null || string3.length() == 0) {
            if (string2.length() == 0 && this.getAbortOnUndefinedVariable()) {
                throw new UndefinedVariableException("Variable \"" + string + "\" is undefined.");
            }
            string3 = string2;
        }
        return string3;
    }

    private static enum ParseState {
        NOT_IN_VAR,
        IN_VAR,
        IN_DEFAULT_VALUE;

    }
}

