/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Collection;
import org.clapper.util.text.TextUtil;

public abstract class XStringBufBase
implements CharSequence,
Appendable {
    public static final char METACHAR_SEQUENCE_START = '\\';

    XStringBufBase() {
    }

    public abstract void getChars(int var1, int var2, char[] var3, int var4) throws IndexOutOfBoundsException;

    protected abstract Appendable getBufferAsAppendable();

    protected abstract CharSequence getBufferAsCharSequence();

    protected abstract CharSequence newBufferAsCharSequence();

    protected abstract void deleteCharacters(int var1, int var2) throws IndexOutOfBoundsException;

    protected abstract void insertCharacter(int var1, char var2);

    protected abstract void insertCharacters(int var1, char[] var2, int var3, int var4);

    protected abstract void replaceString(int var1, int var2, String var3) throws IndexOutOfBoundsException;

    public XStringBufBase append(boolean bl) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(bl));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public XStringBufBase append(char c) {
        try {
            this.getBufferAsAppendable().append(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.append(cArray[i]);
        }
        return this;
    }

    public XStringBufBase append(char[] cArray, int n, int n2) {
        Appendable appendable = this.getBufferAsAppendable();
        while (n < n2) {
            try {
                appendable.append(cArray[n++]);
            }
            catch (IOException iOException) {}
        }
        return this;
    }

    public XStringBufBase append(double d) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(d));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(float f) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(f));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(int n) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(n));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(long l) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(l));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(Object object) {
        try {
            this.getBufferAsAppendable().append(object.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(short s) {
        try {
            this.getBufferAsAppendable().append(String.valueOf(s));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public XStringBufBase append(String string) {
        try {
            this.getBufferAsAppendable().append(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public XStringBufBase append(CharSequence charSequence) {
        try {
            this.getBufferAsAppendable().append(charSequence);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public XStringBufBase append(CharSequence charSequence, int n, int n2) {
        try {
            this.getBufferAsAppendable().append(charSequence, n, n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public char charAt(int n) throws IndexOutOfBoundsException {
        return this.getBufferAsCharSequence().charAt(n);
    }

    public boolean delete(String string) {
        boolean bl = false;
        int n = this.indexOf(string);
        if (n > -1) {
            this.deleteCharacters(n, n + string.length());
            bl = true;
        }
        return bl;
    }

    public void clear() {
        this.delete(0, this.length());
    }

    public XStringBufBase delete(int n, int n2) throws IndexOutOfBoundsException {
        this.deleteCharacters(n, n2);
        return this;
    }

    public void encodeMetacharacters(int n, int n2) throws IndexOutOfBoundsException, IOException {
        char[] cArray = this.toString().toCharArray();
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        this.clear();
        try {
            while (n3 < n) {
                this.append(cArray[n3++]);
            }
            while (n3 < n2) {
                this.append(XStringBufBase.encodeOneMetacharacter(cArray[n3++], stringBuilder));
            }
            while (n3 < cArray.length) {
                this.append(cArray[n3++]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new StringIndexOutOfBoundsException(String.valueOf(n3));
        }
    }

    public void encodeMetacharacters() {
        try {
            this.encodeMetacharacters(0, this.length());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void decodeMetacharacters(int n, int n2) throws StringIndexOutOfBoundsException {
        char[] cArray = this.toString().toCharArray();
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n4;
            while (n3 < n) {
                stringBuilder.append(cArray[n3++]);
            }
            String string = new String(cArray, n3, n2 - n3);
            StringReader stringReader = new StringReader(string);
            PushbackReader pushbackReader = new PushbackReader(stringReader, 5);
            while ((n4 = pushbackReader.read()) != -1) {
                if (n4 == 92) {
                    n4 = pushbackReader.read();
                    if (n4 == -1) {
                        stringBuilder.append((char)n4);
                        continue;
                    }
                    if ((n4 = this.decodeMetacharacter(n4, pushbackReader)) == -1) break;
                    if (n4 == -2) {
                        stringBuilder.append('\\');
                        continue;
                    }
                    stringBuilder.append((char)n4);
                    continue;
                }
                stringBuilder.append((char)n4);
            }
            n3 = n2;
            while (n3 < cArray.length) {
                stringBuilder.append(cArray[n3++]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new StringIndexOutOfBoundsException(String.valueOf(n3));
        }
        catch (IOException iOException) {
            throw new StringIndexOutOfBoundsException();
        }
        this.clear();
        this.append(stringBuilder.toString());
    }

    public void decodeMetacharacters() {
        try {
            this.decodeMetacharacters(0, this.length());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int indexOf(int n) {
        return this.toString().indexOf(n);
    }

    public int indexOf(String string) {
        return this.toString().indexOf(string);
    }

    public int indexOf(String string, int n) {
        return this.toString().indexOf(string, n);
    }

    public XStringBufBase insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public XStringBufBase insert(int n, char c) {
        this.insertCharacter(n, c);
        return this;
    }

    public XStringBufBase insert(int n, char[] cArray) {
        this.insertCharacters(n, cArray, 0, cArray.length);
        return this;
    }

    public XStringBufBase insert(int n, char[] cArray, int n2, int n3) {
        this.insertCharacters(n, cArray, n2, n3);
        return this;
    }

    public XStringBufBase insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public XStringBufBase insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public XStringBufBase insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public XStringBufBase insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public XStringBufBase insert(int n, short s) {
        return this.insert(n, String.valueOf(s));
    }

    public XStringBufBase insert(int n, Object object) {
        return this.insert(n, object.toString());
    }

    public XStringBufBase insert(int n, String string) {
        this.insertCharacters(n, string.toCharArray(), 0, string.length());
        return this;
    }

    @Override
    public int length() {
        return this.getBufferAsCharSequence().length();
    }

    public XStringBufBase replace(int n, int n2, String string) throws StringIndexOutOfBoundsException {
        this.replaceString(n, n2, string);
        return this;
    }

    public boolean replace(String string, String string2) {
        boolean bl = false;
        int n = this.indexOf(string);
        if (n > -1) {
            this.replaceString(n, n + string.length(), string2);
            bl = true;
        }
        return bl;
    }

    public boolean replace(String string, char c) {
        boolean bl = false;
        int n = this.indexOf(string);
        if (n > -1) {
            this.deleteCharacters(n, n + string.length());
            this.insert(n, c);
            bl = true;
        }
        return bl;
    }

    public int replaceAll(String string, String string2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(this.getBufferAsCharSequence());
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringBuilder.length() && (n = stringBuilder.toString().indexOf(string, n3)) >= 0) {
            stringBuilder.replace(n, n + string.length(), string2);
            ++n2;
            n3 = n + string2.length();
        }
        this.clear();
        this.append(stringBuilder.toString());
        return n2;
    }

    public int replaceAll(char c, char c2) {
        int n = this.length();
        char[] cArray = new char[n];
        int n2 = 0;
        this.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            cArray[i] = c2;
            ++n2;
        }
        if (n2 > 0) {
            this.clear();
            this.append(cArray);
        }
        return n2;
    }

    public int replaceAll(char c, String string) {
        return this.replaceAll("" + c, string);
    }

    public void reset(String string) {
        this.clear();
        this.append(string);
    }

    public String[] split() {
        return TextUtil.split(this.toString());
    }

    public String[] split(char c) {
        return TextUtil.split(this.toString(), c);
    }

    public String[] split(String string) {
        return TextUtil.split(this.toString(), string);
    }

    public int split(char c, Collection<String> collection) {
        return TextUtil.split(this.toString(), c, collection);
    }

    public int split(String string, Collection<String> collection) {
        return TextUtil.split(this.toString(), string, collection);
    }

    public String substring(int n) throws StringIndexOutOfBoundsException {
        return this.substring(n, this.length());
    }

    public String substring(int n, int n2) throws StringIndexOutOfBoundsException {
        return this.subSequence(n, n2).toString();
    }

    @Override
    public CharSequence subSequence(int n, int n2) throws IndexOutOfBoundsException {
        return this.getBufferAsCharSequence().subSequence(n, n2);
    }

    @Override
    public String toString() {
        return this.getBufferAsCharSequence().toString();
    }

    private static String encodeOneMetacharacter(char c, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder();
        if (TextUtil.isPrintable(c)) {
            if (c == '\\') {
                stringBuilder2.append('\\');
                stringBuilder2.append('\\');
            } else {
                stringBuilder2.append(c);
            }
        } else {
            switch (c) {
                case '\r': {
                    stringBuilder2.append("\\r");
                    break;
                }
                case '\n': {
                    stringBuilder2.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuilder2.append("\\t");
                    break;
                }
                case '\f': {
                    stringBuilder2.append("\\f");
                    break;
                }
                default: {
                    stringBuilder2.append(XStringBufBase.toUnicodeEscape(c, stringBuilder));
                }
            }
        }
        return stringBuilder2.toString();
    }

    private static String toUnicodeEscape(char c, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        return TextUtil.charToUnicodeEscape(c, stringBuilder);
    }

    private int decodeMetacharacter(int n, PushbackReader pushbackReader) throws IOException {
        switch (n) {
            case 116: {
                n = 9;
                break;
            }
            case 110: {
                n = 10;
                break;
            }
            case 114: {
                n = 13;
                break;
            }
            case 92: {
                n = 92;
                break;
            }
            case 117: {
                n = this.decodeUnicodeSequence(pushbackReader);
                if (n != -2) break;
                pushbackReader.unread(117);
                n = 92;
                break;
            }
        }
        return n;
    }

    private int decodeUnicodeSequence(PushbackReader pushbackReader) throws IOException {
        int n;
        int n2 = -1;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < 4; ++n) {
            n2 = pushbackReader.read();
            if (n2 == -1) {
                bl = true;
                break;
            }
            stringBuilder.append((char)n2);
        }
        if (bl) {
            this.unread(stringBuilder.toString(), pushbackReader);
        } else {
            n = 0;
            boolean bl2 = false;
            try {
                n = Integer.parseInt(stringBuilder.toString(), 16);
                if (n < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.unread(stringBuilder.toString(), pushbackReader);
                bl2 = true;
            }
            if (!Character.isDefined((char)n)) {
                this.unread(stringBuilder.toString(), pushbackReader);
                bl2 = true;
            }
            n2 = (char)(bl2 ? -2 : (char)n);
        }
        return n2;
    }

    private void unread(String string, PushbackReader pushbackReader) throws IOException {
        for (int i = string.length() - 1; i >= 0; --i) {
            pushbackReader.unread(string.charAt(i));
        }
    }
}

