/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.util.ArrayByteIterator;
import org.classdump.luna.util.ByteIterator;

class ArrayByteString
extends ByteString {
    static final ArrayByteString EMPTY_INSTANCE = new ArrayByteString(new byte[0]);
    private final byte[] bytes;
    private int hashCode;

    ArrayByteString(byte[] bytes) {
        this.bytes = Objects.requireNonNull(bytes);
    }

    @Override
    protected boolean equalsByteString(ByteString that) {
        if (this.length() != that.length()) {
            return false;
        }
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (this.byteAt(i) == that.byteAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hc = this.hashCode;
        if (hc == 0 && this.bytes.length > 0) {
            for (byte b : this.bytes) {
                hc = hc * 31 + (b & 0xFF);
            }
            this.hashCode = hc;
        }
        return hc;
    }

    @Override
    int maybeHashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.decode();
    }

    @Override
    public String toRawString() {
        char[] chars = new char[this.bytes.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(this.bytes[i] & 0xFF);
        }
        return String.valueOf(chars);
    }

    @Override
    public int length() {
        return this.bytes.length;
    }

    @Override
    int maybeLength() {
        return this.bytes.length;
    }

    @Override
    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    @Override
    public byte byteAt(int index) {
        return this.bytes[index];
    }

    @Override
    public ByteIterator byteIterator() {
        return new ArrayByteIterator(this.bytes);
    }

    @Override
    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    private static void checkSubstringBounds(int start, int end, int len) {
        if (start > end) {
            throw new IndexOutOfBoundsException("start > end (" + start + " > " + end + ")");
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("start < 0 (" + start + " < 0)");
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException("end < 0 (" + end + " < 0)");
        }
        if (end > len) {
            throw new IndexOutOfBoundsException("end > length (" + start + " > " + len + ")");
        }
    }

    @Override
    public ByteString substring(int start, int end) {
        ArrayByteString.checkSubstringBounds(start, end, this.bytes.length);
        return new ArrayByteString(Arrays.copyOfRange(this.bytes, start, end));
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    @Override
    public void putTo(ByteBuffer buffer) {
        buffer.put(this.bytes);
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        stream.write(this.getBytes());
    }

    @Override
    public boolean startsWith(byte b) {
        return this.bytes.length > 0 && this.bytes[0] == b;
    }
}

