/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.ByteString;

public final class LuaFormat {
    public static final ByteString NIL = ByteString.constOf("nil");
    public static final ByteString TRUE = ByteString.constOf("true");
    public static final ByteString FALSE = ByteString.constOf("false");
    public static final ByteString INF = ByteString.constOf("inf");
    public static final ByteString NAN = ByteString.constOf("nan");
    public static final ByteString TYPENAME_NIL = NIL;
    public static final ByteString TYPENAME_BOOLEAN = ByteString.constOf("boolean");
    public static final ByteString TYPENAME_NUMBER = ByteString.constOf("number");
    public static final ByteString TYPENAME_STRING = ByteString.constOf("string");
    public static final ByteString TYPENAME_TABLE = ByteString.constOf("table");
    public static final ByteString TYPENAME_FUNCTION = ByteString.constOf("function");
    public static final ByteString TYPENAME_USERDATA = ByteString.constOf("userdata");
    public static final ByteString TYPENAME_THREAD = ByteString.constOf("thread");
    private static final ByteString NEG_INF = ByteString.constOf("-" + INF);
    public static final char CHAR_BELL = '\u0007';
    public static final char CHAR_VERTICAL_TAB = '\u000b';
    private static final Set<String> keywords;

    private LuaFormat() {
    }

    public static String toString(boolean b) {
        return LuaFormat.toByteString(b).toString();
    }

    public static ByteString toByteString(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static String toString(long l) {
        return Long.toString(l);
    }

    public static ByteString toByteString(long l) {
        return ByteString.of(LuaFormat.toString(l));
    }

    public static String toString(double f) {
        return LuaFormat.toByteString(f).toString();
    }

    private static ByteString finiteDoubleToByteString(double f) {
        String s = Double.toString(f).toLowerCase();
        return ByteString.of(s);
    }

    public static ByteString toByteString(double f) {
        if (Double.isNaN(f)) {
            return NAN;
        }
        if (Double.isInfinite(f)) {
            return f > 0.0 ? INF : NEG_INF;
        }
        return LuaFormat.finiteDoubleToByteString(f);
    }

    private static int hexValue(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 97 && c <= 102) {
            return 10 + c - 97;
        }
        if (c >= 65 && c <= 70) {
            return 10 + c - 65;
        }
        return -1;
    }

    public static long parseInteger(String s) throws NumberFormatException {
        if ((s = s.trim()).startsWith("0x") || s.startsWith("0X")) {
            int idx;
            long l = 0L;
            int from = Math.max(2, s.length() - 16);
            for (idx = 2; idx < from; ++idx) {
                if (LuaFormat.hexValue(s.charAt(idx)) >= 0) continue;
                throw new NumberFormatException("Illegal character #" + idx + " in \"" + s + "\"");
            }
            for (idx = Math.max(2, s.length() - 16); idx < s.length(); ++idx) {
                int hex = LuaFormat.hexValue(s.charAt(idx));
                if (hex < 0) {
                    throw new NumberFormatException("Illegal character #" + idx + " in \"" + s + "\"");
                }
                l = l << 4 | (long)hex;
            }
            return l;
        }
        return Long.parseLong(s);
    }

    public static double parseFloat(String s) throws NumberFormatException {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e0) {
            try {
                return Double.parseDouble(s.trim() + "p0");
            }
            catch (NumberFormatException e1) {
                throw new NumberFormatException("Not a number: " + s);
            }
        }
    }

    public static Long tryParseInteger(String s) {
        try {
            return LuaFormat.parseInteger(s);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static Double tryParseFloat(String s) {
        try {
            return LuaFormat.parseFloat(s);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static Number tryParseNumeral(String s) {
        Long l = LuaFormat.tryParseInteger(s);
        return l != null ? (Number)l : (Number)LuaFormat.tryParseFloat(s);
    }

    private static boolean isASCIIPrintable(char c) {
        return c >= ' ' && c < '\u007f';
    }

    private static int shortEscape(char c) {
        switch (c) {
            case '\u0007': {
                return 97;
            }
            case '\b': {
                return 98;
            }
            case '\f': {
                return 102;
            }
            case '\n': {
                return 110;
            }
            case '\r': {
                return 114;
            }
            case '\t': {
                return 116;
            }
            case '\u000b': {
                return 118;
            }
            case '\"': {
                return 34;
            }
        }
        return -1;
    }

    private static char toHex(int i) {
        return i < 10 ? (char)(48 + i) : (char)(97 + i - 10);
    }

    public static String escape(CharSequence s) {
        Objects.requireNonNull(s);
        StringBuilder bld = new StringBuilder();
        bld.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '\"' && LuaFormat.isASCIIPrintable(c)) {
                bld.append(c);
                continue;
            }
            bld.append('\\');
            int esc = LuaFormat.shortEscape(c);
            if (esc != -1) {
                bld.append((char)esc);
                continue;
            }
            if (c <= '\u00ff') {
                bld.append('x');
                bld.append(LuaFormat.toHex(c >>> 8 & 0xF));
                bld.append(LuaFormat.toHex(c & 0xF));
                continue;
            }
            bld.append(Integer.toString(c));
        }
        bld.append('\"');
        return bld.toString();
    }

    public static String escape(ByteString byteString) {
        return LuaFormat.escape(byteString.toRawString());
    }

    public static boolean isKeyword(String s) {
        return s != null && keywords.contains(s);
    }

    public static boolean isValidName(String s) {
        if (s == null || s.isEmpty() || LuaFormat.isKeyword(s)) {
            return false;
        }
        char c = s.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_')) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        HashSet ks = new HashSet();
        Collections.addAll(ks, "and", "break", "do", "else", "elseif", "end", "false", "for", "function", "goto", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while");
        keywords = Collections.unmodifiableSet(ks);
    }
}

