/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import org.classdump.luna.ArrayByteString;
import org.classdump.luna.ByteString;
import org.classdump.luna.util.ByteIterator;
import org.classdump.luna.util.CharsetEncoderByteIterator;

class StringByteString
extends ByteString {
    private final String string;
    private final Charset charset;
    private int byteHashCode;
    private int byteLength;

    StringByteString(String s, Charset charset) {
        this.string = Objects.requireNonNull(s);
        this.charset = Objects.requireNonNull(charset);
        if (!charset.canEncode()) {
            throw new IllegalArgumentException("Charset cannot encode: " + charset.name());
        }
        this.byteHashCode = 0;
        this.byteLength = this.string.isEmpty() ? 0 : -1;
    }

    @Override
    protected boolean equalsByteString(ByteString that) {
        if (this.isEmpty() && that.isEmpty()) {
            return true;
        }
        int thisHash = this.maybeHashCode();
        int thatHash = that.maybeHashCode();
        if (thisHash != 0 && thatHash != 0 && thisHash != thatHash) {
            return false;
        }
        int thisLength = this.maybeLength();
        int thatLength = that.maybeLength();
        if (thisLength >= 0 && thatLength >= 0 && thisLength != thatLength) {
            return false;
        }
        ByteIterator thisIterator = this.byteIterator();
        ByteIterator thatIterator = that.byteIterator();
        while (thisIterator.hasNext() && thatIterator.hasNext()) {
            byte thatByte;
            byte thisByte = thisIterator.nextByte();
            if (thisByte == (thatByte = thatIterator.nextByte())) continue;
            return false;
        }
        return thisIterator.hasNext() == thatIterator.hasNext();
    }

    private int computeHashCode() {
        int hc = 0;
        CharsetEncoderByteIterator it = new CharsetEncoderByteIterator(this.string, this.charset);
        while (it.hasNext()) {
            hc = hc * 31 + (it.nextByte() & 0xFF);
        }
        return hc;
    }

    @Override
    public int hashCode() {
        int hc = this.byteHashCode;
        if (hc == 0 && !this.string.isEmpty()) {
            this.byteHashCode = hc = this.computeHashCode();
        }
        return hc;
    }

    @Override
    int maybeHashCode() {
        return this.byteHashCode;
    }

    private int computeLength() {
        int len = 0;
        CharsetEncoderByteIterator it = new CharsetEncoderByteIterator(this.string, this.charset);
        while (it.hasNext()) {
            it.nextByte();
            ++len;
        }
        return len;
    }

    @Override
    public int length() {
        int len = this.byteLength;
        if (len < 0) {
            this.byteLength = len = this.computeLength();
        }
        return len;
    }

    @Override
    int maybeLength() {
        return this.byteLength;
    }

    @Override
    public boolean isEmpty() {
        return this.string.isEmpty();
    }

    private byte[] toBytes() {
        return this.string.getBytes(this.charset);
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = this.toBytes();
        return Arrays.copyOf(bytes, bytes.length);
    }

    @Override
    public byte byteAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.toBytes()[index];
    }

    @Override
    public ByteIterator byteIterator() {
        return new CharsetEncoderByteIterator(this.string, this.charset);
    }

    private static void checkSubstringBounds(int start, int end, int len) {
        if (start > end) {
            throw new IndexOutOfBoundsException("start > end (" + start + " > " + end + ")");
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("start < 0 (" + start + " < 0)");
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException("end < 0 (" + end + " < 0)");
        }
        if (end > len) {
            throw new IndexOutOfBoundsException("end > length (" + start + " > " + len + ")");
        }
    }

    @Override
    public ByteString substring(int start, int end) {
        byte[] bytes = this.toBytes();
        StringByteString.checkSubstringBounds(start, end, bytes.length);
        return new ArrayByteString(Arrays.copyOfRange(bytes, start, end));
    }

    @Override
    public String toString() {
        return this.string;
    }

    @Override
    public String decode(Charset charset) {
        if (this.charset.equals(charset)) {
            return this.string;
        }
        return super.decode(charset);
    }

    @Override
    public String toRawString() {
        byte[] bytes = this.toBytes();
        char[] chars = new char[bytes.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return String.valueOf(chars);
    }

    @Override
    public void putTo(ByteBuffer buffer) {
        buffer.put(this.toBytes());
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        stream.write(this.getBytes());
    }

    @Override
    public ByteString concat(ByteString other) {
        if (other instanceof StringByteString) {
            StringByteString that = (StringByteString)other;
            if (this.charset.equals(that.charset)) {
                return ByteString.of(this.string.concat(that.string));
            }
        }
        return super.concat(other);
    }

    @Override
    public boolean startsWith(byte b) {
        if (this.string.isEmpty()) {
            return false;
        }
        CharsetEncoderByteIterator it = new CharsetEncoderByteIterator(this.string, this.charset);
        return it.hasNext() && it.nextByte() == b;
    }
}

