/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler;

import java.util.Objects;
import org.classdump.luna.Variable;
import org.classdump.luna.compiler.CompiledModule;
import org.classdump.luna.compiler.CompilerSettings;
import org.classdump.luna.compiler.LuaCompiler;
import org.classdump.luna.load.ChunkClassLoader;
import org.classdump.luna.load.ChunkLoader;
import org.classdump.luna.load.LoaderException;
import org.classdump.luna.parser.ParseException;
import org.classdump.luna.parser.TokenMgrError;
import org.classdump.luna.runtime.LuaFunction;

public class CompilerChunkLoader
implements ChunkLoader {
    private final ChunkClassLoader chunkClassLoader;
    private final String rootClassPrefix;
    private final LuaCompiler compiler;
    private int idx;

    CompilerChunkLoader(ClassLoader classLoader, LuaCompiler compiler, String rootClassPrefix) {
        this.chunkClassLoader = new ChunkClassLoader(Objects.requireNonNull(classLoader));
        this.compiler = Objects.requireNonNull(compiler);
        this.rootClassPrefix = Objects.requireNonNull(rootClassPrefix);
        this.idx = 0;
    }

    public static CompilerChunkLoader of(ClassLoader classLoader, LuaCompiler compiler, String rootClassPrefix) {
        return new CompilerChunkLoader(classLoader, compiler, rootClassPrefix);
    }

    public static CompilerChunkLoader of(ClassLoader classLoader, CompilerSettings compilerSettings, String rootClassPrefix) {
        return new CompilerChunkLoader(classLoader, new LuaCompiler(compilerSettings), rootClassPrefix);
    }

    public static CompilerChunkLoader of(ClassLoader classLoader, String rootClassPrefix) {
        return CompilerChunkLoader.of(classLoader, CompilerSettings.defaultSettings(), rootClassPrefix);
    }

    public static CompilerChunkLoader of(LuaCompiler compiler, String rootClassPrefix) {
        return CompilerChunkLoader.of(CompilerChunkLoader.class.getClassLoader(), compiler, rootClassPrefix);
    }

    public static CompilerChunkLoader of(CompilerSettings compilerSettings, String rootClassPrefix) {
        return CompilerChunkLoader.of(new LuaCompiler(compilerSettings), rootClassPrefix);
    }

    public static CompilerChunkLoader of(String rootClassPrefix) {
        return CompilerChunkLoader.of(CompilerSettings.defaultSettings(), rootClassPrefix);
    }

    public ChunkClassLoader getChunkClassLoader() {
        return this.chunkClassLoader;
    }

    @Override
    public LuaFunction loadTextChunk(Variable env, String chunkName, String sourceText) throws LoaderException {
        Objects.requireNonNull(env);
        Objects.requireNonNull(chunkName);
        Objects.requireNonNull(sourceText);
        CompilerChunkLoader compilerChunkLoader = this;
        synchronized (compilerChunkLoader) {
            String rootClassName = this.rootClassPrefix + this.idx++;
            try {
                CompiledModule result = this.compiler.compile(sourceText, chunkName, rootClassName);
                String mainClassName = this.chunkClassLoader.install(result);
                Class<?> clazz = this.chunkClassLoader.loadClass(mainClassName);
                return (LuaFunction)clazz.getConstructor(Variable.class).newInstance(env);
            }
            catch (TokenMgrError ex) {
                String msg = ex.getMessage();
                int line = 0;
                boolean partial = msg != null && msg.contains("Encountered: <EOF>");
                throw new LoaderException(ex, chunkName, line, partial);
            }
            catch (ParseException ex) {
                boolean partial = ex.currentToken != null && ex.currentToken.next != null && ex.currentToken.next.kind == 0;
                int line = ex.currentToken != null ? ex.currentToken.beginLine : 0;
                throw new LoaderException(ex, chunkName, line, partial);
            }
            catch (LinkageError | ReflectiveOperationException | RuntimeException ex) {
                throw new LoaderException(ex, chunkName, 0, false);
            }
        }
    }
}

