/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.classdump.luna.compiler.FunctionId;
import org.classdump.luna.compiler.IRFunc;
import org.classdump.luna.compiler.ModuleBuilder;
import org.classdump.luna.compiler.TranslationUtils;
import org.classdump.luna.compiler.ir.AbstractVal;
import org.classdump.luna.compiler.ir.AbstractVar;
import org.classdump.luna.compiler.ir.BinOp;
import org.classdump.luna.compiler.ir.Branch;
import org.classdump.luna.compiler.ir.Call;
import org.classdump.luna.compiler.ir.Closure;
import org.classdump.luna.compiler.ir.CodeBuilder;
import org.classdump.luna.compiler.ir.Jmp;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.LoadConst;
import org.classdump.luna.compiler.ir.MultiGet;
import org.classdump.luna.compiler.ir.MultiVal;
import org.classdump.luna.compiler.ir.PhiLoad;
import org.classdump.luna.compiler.ir.PhiStore;
import org.classdump.luna.compiler.ir.PhiVal;
import org.classdump.luna.compiler.ir.RegProvider;
import org.classdump.luna.compiler.ir.Ret;
import org.classdump.luna.compiler.ir.TCall;
import org.classdump.luna.compiler.ir.TabGet;
import org.classdump.luna.compiler.ir.TabNew;
import org.classdump.luna.compiler.ir.TabRawAppendMulti;
import org.classdump.luna.compiler.ir.TabRawSet;
import org.classdump.luna.compiler.ir.TabRawSetInt;
import org.classdump.luna.compiler.ir.TabSet;
import org.classdump.luna.compiler.ir.ToNumber;
import org.classdump.luna.compiler.ir.UnOp;
import org.classdump.luna.compiler.ir.UpLoad;
import org.classdump.luna.compiler.ir.UpStore;
import org.classdump.luna.compiler.ir.UpVar;
import org.classdump.luna.compiler.ir.VList;
import org.classdump.luna.compiler.ir.Val;
import org.classdump.luna.compiler.ir.Var;
import org.classdump.luna.compiler.ir.VarInit;
import org.classdump.luna.compiler.ir.VarLoad;
import org.classdump.luna.compiler.ir.VarStore;
import org.classdump.luna.compiler.ir.Vararg;
import org.classdump.luna.parser.analysis.FunctionVarInfo;
import org.classdump.luna.parser.analysis.ResolvedLabel;
import org.classdump.luna.parser.analysis.ResolvedVariable;
import org.classdump.luna.parser.analysis.VarMapping;
import org.classdump.luna.parser.analysis.Variable;
import org.classdump.luna.parser.ast.AssignStatement;
import org.classdump.luna.parser.ast.BinaryOperationExpr;
import org.classdump.luna.parser.ast.Block;
import org.classdump.luna.parser.ast.BodyStatement;
import org.classdump.luna.parser.ast.BooleanLiteral;
import org.classdump.luna.parser.ast.BreakStatement;
import org.classdump.luna.parser.ast.CallExpr;
import org.classdump.luna.parser.ast.CallStatement;
import org.classdump.luna.parser.ast.Chunk;
import org.classdump.luna.parser.ast.ConditionalBlock;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.FunctionDefExpr;
import org.classdump.luna.parser.ast.GenericForStatement;
import org.classdump.luna.parser.ast.GotoStatement;
import org.classdump.luna.parser.ast.IfStatement;
import org.classdump.luna.parser.ast.IndexExpr;
import org.classdump.luna.parser.ast.LValueExpr;
import org.classdump.luna.parser.ast.LabelStatement;
import org.classdump.luna.parser.ast.Literal;
import org.classdump.luna.parser.ast.LiteralExpr;
import org.classdump.luna.parser.ast.LocalDeclStatement;
import org.classdump.luna.parser.ast.MultiExpr;
import org.classdump.luna.parser.ast.NilLiteral;
import org.classdump.luna.parser.ast.Numeral;
import org.classdump.luna.parser.ast.NumericForStatement;
import org.classdump.luna.parser.ast.Operator;
import org.classdump.luna.parser.ast.ParenExpr;
import org.classdump.luna.parser.ast.RepeatUntilStatement;
import org.classdump.luna.parser.ast.ReturnStatement;
import org.classdump.luna.parser.ast.StringLiteral;
import org.classdump.luna.parser.ast.TableConstructorExpr;
import org.classdump.luna.parser.ast.Transformer;
import org.classdump.luna.parser.ast.UnaryOperationExpr;
import org.classdump.luna.parser.ast.VarExpr;
import org.classdump.luna.parser.ast.VarargsExpr;
import org.classdump.luna.parser.ast.WhileStatement;
import org.classdump.luna.parser.ast.util.AttributeUtils;

class IRTranslatorTransformer
extends Transformer {
    private final ModuleBuilder moduleBuilder;
    private final FunctionId id;
    private final CodeBuilder insns;
    private final RegProvider provider;
    private final Deque<AbstractVal> vals;
    private final Deque<MultiVal> multis;
    private final Deque<Label> breakLabels;
    private final Map<ResolvedLabel, Label> userLabels;
    private boolean assigning;
    private final Map<Variable, Var> vars;
    private final Map<Variable.Ref, UpVar> uvs;
    private final List<Var> params;
    private boolean vararg;
    private final List<UpVar> upvals;
    private int nextNestedFnIdx;

    private IRTranslatorTransformer(ModuleBuilder moduleBuilder, FunctionId id) {
        this.moduleBuilder = Objects.requireNonNull(moduleBuilder);
        this.id = Objects.requireNonNull(id);
        this.provider = new RegProvider();
        this.insns = new CodeBuilder();
        this.vals = new ArrayDeque<AbstractVal>();
        this.multis = new ArrayDeque<MultiVal>();
        this.assigning = false;
        this.breakLabels = new ArrayDeque<Label>();
        this.userLabels = new HashMap<ResolvedLabel, Label>();
        this.vars = new HashMap<Variable, Var>();
        this.uvs = new HashMap<Variable.Ref, UpVar>();
        this.params = new ArrayList<Var>();
        this.vararg = false;
        this.upvals = new ArrayList<UpVar>();
        this.nextNestedFnIdx = 0;
    }

    public IRTranslatorTransformer(ModuleBuilder moduleBuilder) {
        this(moduleBuilder, FunctionId.root());
    }

    private IRFunc result() {
        return new IRFunc(this.id, Collections.unmodifiableList(this.params), this.vararg, Collections.unmodifiableList(this.upvals), this.insns.build());
    }

    private boolean onStack() {
        return !this.multis.isEmpty();
    }

    private Val popVal() {
        if (!this.vals.isEmpty()) {
            AbstractVal aval = this.vals.pop();
            if (aval instanceof PhiVal) {
                Val v = this.provider.newVal();
                this.insns.add(new PhiLoad(v, (PhiVal)aval));
                return v;
            }
            if (aval instanceof Val) {
                return (Val)aval;
            }
            throw new UnsupportedOperationException("Unknown abstract value: " + aval);
        }
        if (!this.multis.isEmpty()) {
            Val v = this.provider.newVal();
            MultiVal mv = this.multis.pop();
            this.insns.add(new MultiGet(v, mv, 0));
            return v;
        }
        throw new IllegalStateException("no value on stack");
    }

    private Var var(Variable v) {
        Var w = this.vars.get(v);
        if (w != null) {
            return w;
        }
        w = this.provider.newVar();
        this.vars.put(v, w);
        return w;
    }

    private UpVar upVar(Variable.Ref v) {
        UpVar w = this.uvs.get(v);
        if (w != null) {
            return w;
        }
        w = this.provider.newUpVar(v.var().name());
        this.uvs.put(v, w);
        return w;
    }

    private Label userLabel(ResolvedLabel rl) {
        Label l = this.userLabels.get(rl);
        if (l != null) {
            return l;
        }
        l = this.insns.newLabel();
        this.userLabels.put(rl, l);
        return l;
    }

    private void endStatement() {
        this.multis.clear();
        this.vals.clear();
    }

    @Override
    public LValueExpr transform(VarExpr e) {
        ResolvedVariable rv = TranslationUtils.resolved(e);
        this.insns.atLine(e.line());
        if (rv.isUpvalue()) {
            Variable.Ref ref = rv.variable().ref();
            if (this.assigning) {
                Val src = this.popVal();
                this.insns.add(new UpStore(this.upVar(ref), src));
            } else {
                Val dest = this.provider.newVal();
                this.vals.push(dest);
                this.insns.add(new UpLoad(dest, this.upVar(ref)));
            }
        } else {
            Variable var = rv.variable();
            if (this.assigning) {
                Val src = this.popVal();
                this.insns.add(new VarStore(this.var(var), src));
            } else {
                Val dest = this.provider.newVal();
                this.vals.push(dest);
                this.insns.add(new VarLoad(dest, this.var(var)));
            }
        }
        return e;
    }

    @Override
    public LValueExpr transform(IndexExpr e) {
        boolean as = this.assigning;
        this.assigning = false;
        e.object().accept(this);
        Val obj = this.popVal();
        e.key().accept(this);
        Val key = this.popVal();
        this.assigning = as;
        this.insns.atLine(e.line());
        if (this.assigning) {
            Val value = this.popVal();
            this.insns.add(new TabSet(obj, key, value));
        } else {
            Val dest = this.provider.newVal();
            this.vals.push(dest);
            this.insns.add(new TabGet(dest, obj, key));
        }
        return e;
    }

    @Override
    public Expr transform(LiteralExpr e) {
        this.insns.atLine(e.line());
        return super.transform(e);
    }

    @Override
    public Literal transform(NilLiteral l) {
        Val dest = this.provider.newVal();
        this.vals.push(dest);
        this.insns.add(new LoadConst.Nil(dest));
        return l;
    }

    @Override
    public Literal transform(BooleanLiteral l) {
        Val dest = this.provider.newVal();
        this.vals.push(dest);
        this.insns.add(new LoadConst.Bool(dest, l.value()));
        return l;
    }

    @Override
    public Literal transform(Numeral.IntegerNumeral l) {
        Val dest = this.provider.newVal();
        this.vals.push(dest);
        this.insns.add(new LoadConst.Int(dest, l.value()));
        return l;
    }

    @Override
    public Literal transform(Numeral.FloatNumeral l) {
        Val dest = this.provider.newVal();
        this.vals.push(dest);
        this.insns.add(new LoadConst.Flt(dest, l.value()));
        return l;
    }

    @Override
    public Literal transform(StringLiteral l) {
        Val dest = this.provider.newVal();
        this.vals.push(dest);
        this.insns.add(new LoadConst.Str(dest, l.value()));
        return l;
    }

    private void and(Expr left, Expr right) {
        PhiVal dest = this.provider.newPhiVal();
        Label l_false = this.insns.newLabel();
        Label l_done = this.insns.newLabel();
        left.accept(this);
        Val l = this.popVal();
        this.insns.addBranch(new Branch.Condition.Bool(l, false), l_false);
        right.accept(this);
        Val r = this.popVal();
        this.insns.add(new PhiStore(dest, r));
        this.insns.add(new Jmp(l_done));
        this.insns.add(l_false);
        this.insns.add(new PhiStore(dest, l));
        this.insns.add(l_done);
        this.vals.push(dest);
    }

    private void or(Expr left, Expr right) {
        PhiVal dest = this.provider.newPhiVal();
        Label l_true = this.insns.newLabel();
        Label l_done = this.insns.newLabel();
        left.accept(this);
        Val l = this.popVal();
        this.insns.addBranch(new Branch.Condition.Bool(l, true), l_true);
        right.accept(this);
        Val r = this.popVal();
        this.insns.add(new PhiStore(dest, r));
        this.insns.add(new Jmp(l_done));
        this.insns.add(l_true);
        this.insns.add(new PhiStore(dest, l));
        this.insns.add(l_done);
        this.vals.push(dest);
    }

    private void eagerBinOp(Operator.Binary op, Expr left, Expr right) {
        BinOp.Op bop = TranslationUtils.bop(op);
        boolean swap = false;
        if (bop == null) {
            bop = TranslationUtils.bop(op.swap());
            swap = true;
        }
        if (bop == null) {
            throw new UnsupportedOperationException("Binary operator not supported: " + op);
        }
        left.accept(this);
        Val l = this.popVal();
        right.accept(this);
        Val r = this.popVal();
        Val dest = this.provider.newVal();
        this.vals.push(dest);
        this.insns.add(new BinOp(bop, dest, swap ? r : l, swap ? l : r));
    }

    @Override
    public Expr transform(BinaryOperationExpr e) {
        switch (e.op()) {
            case AND: {
                this.and(e.left(), e.right());
                break;
            }
            case OR: {
                this.or(e.left(), e.right());
                break;
            }
            default: {
                this.eagerBinOp(e.op(), e.left(), e.right());
            }
        }
        return e;
    }

    @Override
    public Expr transform(UnaryOperationExpr e) {
        e.arg().accept(this);
        Val arg = this.popVal();
        Val dest = this.provider.newVal();
        this.vals.push(dest);
        this.insns.atLine(e.line());
        this.insns.add(new UnOp(TranslationUtils.uop(e.op()), dest, arg));
        return e;
    }

    @Override
    public Expr transform(VarargsExpr e) {
        this.insns.atLine(e.line());
        MultiVal mv = this.provider.newMultiVal();
        this.insns.add(new Vararg(mv));
        this.multis.push(mv);
        return e;
    }

    @Override
    public Expr transform(ParenExpr e) {
        e.multiExpr().accept(this);
        if (this.multis.isEmpty()) {
            throw new IllegalStateException("empty multival stack");
        }
        Val dest = this.provider.newVal();
        MultiVal mv = this.multis.pop();
        this.insns.add(new MultiGet(dest, mv, 0));
        this.vals.push(dest);
        return e;
    }

    private VList vlist(Val prefix, List<Expr> exprs) {
        ArrayList<Val> as = new ArrayList<Val>();
        if (prefix != null) {
            as.add(prefix);
        }
        MultiVal multi = null;
        Iterator<Expr> it = exprs.iterator();
        while (it.hasNext()) {
            Expr e = it.next();
            e.accept(this);
            if (e instanceof MultiExpr && !it.hasNext() && this.onStack()) {
                MultiVal mv = this.multis.pop();
                this.multis.clear();
                multi = mv;
                continue;
            }
            as.add(this.popVal());
        }
        return new VList(Collections.unmodifiableList(as), multi);
    }

    private VList vlist(List<Expr> exprs) {
        return this.vlist(null, exprs);
    }

    private Call call(CallExpr.FunctionCallExpr e) {
        e.fn().accept(this);
        Val fn = this.popVal();
        VList vl = this.vlist(e.args());
        MultiVal result = this.provider.newMultiVal();
        return new Call(result, fn, vl);
    }

    private Call call(CallExpr.MethodCallExpr e) {
        e.target().accept(this);
        Val obj = this.popVal();
        this.transform(StringLiteral.fromName(e.methodName()));
        Val method = this.popVal();
        Val fn = this.provider.newVal();
        this.insns.add(new TabGet(fn, obj, method));
        VList vl = this.vlist(obj, e.args());
        MultiVal result = this.provider.newMultiVal();
        return new Call(result, fn, vl);
    }

    @Override
    public Expr transform(CallExpr.FunctionCallExpr e) {
        Call c = this.call(e);
        this.insns.atLine(e.line());
        this.insns.add(c);
        this.multis.push(c.dest());
        return e;
    }

    @Override
    public Expr transform(CallExpr.MethodCallExpr e) {
        Call c = this.call(e);
        this.insns.atLine(e.line());
        this.insns.add(c);
        this.multis.push(c.dest());
        return e;
    }

    private FunctionId nestedFunc(FunctionVarInfo fi, int idx, Block b) {
        IRTranslatorTransformer visitor = new IRTranslatorTransformer(this.moduleBuilder, this.id.child(idx));
        visitor.addParamsAndUpvals(fi);
        visitor.mainBlock(b);
        IRFunc result = visitor.result();
        this.moduleBuilder.add(result);
        return result.id();
    }

    @Override
    public Expr transform(FunctionDefExpr e) {
        FunctionVarInfo info = TranslationUtils.funcVarInfo(e);
        FunctionId id = this.nestedFunc(info, this.nextNestedFnIdx++, e.block());
        Val dest = this.provider.newVal();
        ArrayList<AbstractVar> args = new ArrayList<AbstractVar>();
        for (Variable.Ref uv : info.upvalues()) {
            if (this.uvs.containsKey(uv)) {
                args.add(this.uvs.get(uv));
                continue;
            }
            if (this.vars.containsKey(uv.var())) {
                args.add(this.vars.get(uv.var()));
                continue;
            }
            throw new IllegalStateException("Illegal upvalue: " + uv);
        }
        this.insns.atLine(e.line());
        this.insns.add(new Closure(dest, id, Collections.unmodifiableList(args)));
        this.vals.push(dest);
        return e;
    }

    @Override
    public Expr transform(TableConstructorExpr e) {
        int array = 0;
        int hash = 0;
        Val dest = this.provider.newVal();
        for (TableConstructorExpr.FieldInitialiser fi : e.fields()) {
            if (fi.key() == null) {
                ++array;
                continue;
            }
            ++hash;
        }
        this.insns.atLine(e.line());
        this.insns.add(new TabNew(dest, array, hash));
        for (TableConstructorExpr.FieldInitialiser fi : e.fields()) {
            if (fi.key() == null) continue;
            fi.key().accept(this);
            Val k = this.popVal();
            fi.value().accept(this);
            Val v = this.popVal();
            this.insns.add(new TabRawSet(dest, k, v));
        }
        int i = 1;
        Iterator<TableConstructorExpr.FieldInitialiser> it = e.fields().iterator();
        while (it.hasNext()) {
            TableConstructorExpr.FieldInitialiser fi = it.next();
            if (fi.key() != null) continue;
            Expr ve = fi.value();
            ve.accept(this);
            if (ve instanceof MultiExpr && !it.hasNext() && this.onStack()) {
                MultiVal mv = this.multis.pop();
                this.insns.add(new TabRawAppendMulti(dest, i, mv));
                continue;
            }
            Val v = this.popVal();
            this.insns.add(new TabRawSetInt(dest, i++, v));
        }
        this.vals.push(dest);
        return e;
    }

    private void nestedBlock(Block b) {
        for (BodyStatement bs : b.statements()) {
            bs.accept(this);
        }
        if (b.returnStatement() != null) {
            b.returnStatement().accept(this);
        }
    }

    private void mainBlock(Block b) {
        this.nestedBlock(b);
        if (b.returnStatement() == null) {
            this.insns.add(new Ret(this.vlist(Collections.emptyList())));
        }
    }

    private void addParamsAndUpvals(FunctionVarInfo fi) {
        for (Variable v : fi.params()) {
            Var w = this.var(v);
            this.params.add(w);
        }
        this.vararg = fi.isVararg();
        for (Variable.Ref uv : fi.upvalues()) {
            UpVar u = this.upVar(uv);
            this.upvals.add(u);
        }
    }

    @Override
    public Chunk transform(Chunk chunk) {
        this.addParamsAndUpvals(TranslationUtils.funcVarInfo(chunk));
        this.mainBlock(chunk.block());
        this.moduleBuilder.add(this.result());
        return chunk;
    }

    @Override
    public ReturnStatement transform(ReturnStatement node) {
        if (node.exprs().size() == 1 && node.exprs().get(0) instanceof CallExpr) {
            Call c;
            CallExpr ce = (CallExpr)node.exprs().get(0);
            if (ce instanceof CallExpr.FunctionCallExpr) {
                c = this.call((CallExpr.FunctionCallExpr)ce);
            } else if (ce instanceof CallExpr.MethodCallExpr) {
                c = this.call((CallExpr.MethodCallExpr)ce);
            } else {
                throw new IllegalStateException("Illegal call expression: " + ce);
            }
            this.insns.atLine(node.line());
            this.insns.add(new TCall(c.fn(), c.args()));
        } else {
            VList args = this.vlist(node.exprs());
            this.insns.atLine(node.line());
            this.insns.add(new Ret(args));
        }
        this.endStatement();
        return node;
    }

    @Override
    public BodyStatement transform(AssignStatement node) {
        ArrayList<Val> ts = new ArrayList<Val>();
        Iterator<Expr> eit = node.exprs().iterator();
        while (eit.hasNext()) {
            Expr e = eit.next();
            e.accept(this);
            if (e instanceof MultiExpr && !eit.hasNext() && this.onStack()) continue;
            ts.add(this.popVal());
        }
        Iterator it = ts.iterator();
        this.vals.clear();
        int i = 0;
        for (LValueExpr lv : node.vars()) {
            Val src;
            if (it.hasNext()) {
                src = (Val)it.next();
            } else {
                src = this.provider.newVal();
                if (this.onStack()) {
                    this.insns.add(new MultiGet(src, this.multis.peek(), i++));
                } else {
                    this.insns.add(new LoadConst.Nil(src));
                }
            }
            this.vals.push(src);
            this.assigning = true;
            lv.accept(this);
            this.assigning = false;
        }
        this.endStatement();
        return node;
    }

    @Override
    public BodyStatement transform(LocalDeclStatement node) {
        ArrayList<Val> ts = new ArrayList<Val>();
        Iterator<Expr> eit = node.initialisers().iterator();
        while (eit.hasNext()) {
            Expr e = eit.next();
            e.accept(this);
            if (e instanceof MultiExpr && !eit.hasNext() && this.onStack()) continue;
            ts.add(this.popVal());
        }
        Iterator it = ts.iterator();
        int i = 0;
        for (Variable w : TranslationUtils.varMapping(node).vars()) {
            Val src;
            Var v = this.var(w);
            if (it.hasNext()) {
                src = (Val)it.next();
            } else {
                src = this.provider.newVal();
                if (this.onStack()) {
                    this.insns.add(new MultiGet(src, this.multis.peek(), i++));
                } else {
                    this.insns.add(new LoadConst.Nil(src));
                }
            }
            this.insns.add(new VarInit(v, src));
        }
        this.endStatement();
        return node;
    }

    private void condBlock(ConditionalBlock cb, Label l_else, Label l_done) {
        Objects.requireNonNull(l_done);
        this.insns.atLine(cb.condition().line());
        cb.condition().accept(this);
        Val c = this.popVal();
        this.insns.addBranch(new Branch.Condition.Bool(c, false), l_else != null ? l_else : l_done);
        this.nestedBlock(cb.block());
        if (l_else != null && this.insns.isInBlock()) {
            this.insns.add(new Jmp(l_done));
        }
    }

    private Label nextLabel(Iterator<Label> ls) {
        return ls.hasNext() ? ls.next() : null;
    }

    @Override
    public BodyStatement transform(IfStatement node) {
        Label l_done = this.insns.newLabel();
        ArrayList<Label> nexts = new ArrayList<Label>();
        for (ConditionalBlock cb : node.elifs()) {
            nexts.add(this.insns.newLabel());
        }
        if (node.elseBlock() != null) {
            nexts.add(this.insns.newLabel());
        }
        Iterator<Label> ls = nexts.iterator();
        Label l_next = this.nextLabel(ls);
        this.condBlock(node.main(), l_next, l_done);
        for (ConditionalBlock cb : node.elifs()) {
            assert (l_next != null);
            this.insns.add(l_next);
            l_next = this.nextLabel(ls);
            this.condBlock(cb, l_next, l_done);
        }
        if (node.elseBlock() != null) {
            assert (l_next != null);
            this.insns.add(l_next);
            this.nestedBlock(node.elseBlock());
        }
        this.insns.add(l_done);
        this.endStatement();
        return node;
    }

    private Val toNumber(Val addr, String desc) {
        Val t = this.provider.newVal();
        this.insns.add(new ToNumber(t, addr, desc));
        return t;
    }

    private Val loadConst(int i) {
        Val t = this.provider.newVal();
        this.insns.add(new LoadConst.Int(t, i));
        return t;
    }

    @Override
    public BodyStatement transform(NumericForStatement node) {
        Val t_step;
        Label l_top = this.insns.newLabel();
        Label l_done = this.insns.newLabel();
        this.insns.atLine(node.line());
        node.limit().accept(this);
        Val t_limit = this.toNumber(this.popVal(), "'for' limit");
        if (node.step() != null) {
            node.step().accept(this);
            t_step = this.toNumber(this.popVal(), "'for' step");
        } else {
            t_step = this.loadConst(1);
        }
        node.init().accept(this);
        Val t_var0 = this.toNumber(this.popVal(), "'for' initial value");
        Val t_var1 = this.provider.newVal();
        this.insns.add(new BinOp(BinOp.Op.SUB, t_var1, t_var0, t_step));
        Var v_var = this.var(new Variable(node.name()));
        this.insns.add(new VarInit(v_var, t_var1));
        this.insns.add(l_top);
        Val t_var2 = this.provider.newVal();
        this.insns.add(new VarLoad(t_var2, v_var));
        Val t_var3 = this.provider.newVal();
        this.insns.add(new BinOp(BinOp.Op.ADD, t_var3, t_var2, t_step));
        this.insns.addBranch(new Branch.Condition.NumLoopEnd(t_var3, t_limit, t_step), l_done);
        this.insns.add(new VarStore(v_var, t_var3));
        VarMapping vm = TranslationUtils.varMapping(node);
        Var v_v = this.var(vm.get());
        this.insns.add(new VarInit(v_v, t_var3));
        this.breakLabels.push(l_done);
        this.nestedBlock(node.block());
        this.breakLabels.pop();
        this.insns.add(new Jmp(l_top));
        this.insns.add(l_done);
        this.endStatement();
        return node;
    }

    @Override
    public BodyStatement transform(GenericForStatement node) {
        MultiVal mv;
        Label l_top = this.insns.newLabel();
        Label l_done = this.insns.newLabel();
        this.insns.atLine(node.line());
        VarMapping vm = TranslationUtils.varMapping(node);
        Val t_f = this.provider.newVal();
        Val t_s = this.provider.newVal();
        Val t_var0 = this.provider.newVal();
        Var v_var = this.provider.newVar();
        int i = 0;
        Iterator<Expr> eit = node.exprs().iterator();
        while (eit.hasNext()) {
            Expr e = eit.next();
            e.accept(this);
            if (e instanceof MultiExpr && !eit.hasNext() && this.onStack()) continue;
            switch (i) {
                case 0: {
                    t_f = this.popVal();
                    break;
                }
                case 1: {
                    t_s = this.popVal();
                    break;
                }
                case 2: {
                    t_var0 = this.popVal();
                    break;
                }
                default: {
                    this.popVal();
                }
            }
            ++i;
        }
        if (this.onStack()) {
            mv = this.multis.pop();
            switch (i) {
                case 0: {
                    this.insns.add(new MultiGet(t_f, mv, 0));
                }
                case 1: {
                    this.insns.add(new MultiGet(t_s, mv, 1));
                }
                case 2: {
                    this.insns.add(new MultiGet(t_var0, mv, 2));
                }
            }
        } else {
            switch (i) {
                case 0: {
                    this.insns.add(new LoadConst.Nil(t_f));
                }
                case 1: {
                    this.insns.add(new LoadConst.Nil(t_s));
                }
                case 2: {
                    this.insns.add(new LoadConst.Nil(t_var0));
                }
            }
        }
        this.multis.clear();
        this.insns.add(new VarInit(v_var, t_var0));
        this.insns.add(l_top);
        Val t_var1 = this.provider.newVal();
        this.insns.add(new VarLoad(t_var1, v_var));
        ArrayList<Val> ts = new ArrayList<Val>();
        ts.add(t_s);
        ts.add(t_var1);
        mv = this.provider.newMultiVal();
        this.insns.add(new Call(mv, t_f, new VList(Collections.unmodifiableList(ts), null)));
        for (int i2 = 0; i2 < node.names().size(); ++i2) {
            Var v = this.var(vm.get(i2));
            Val t = this.provider.newVal();
            this.insns.add(new MultiGet(t, mv, i2));
            this.insns.add(new VarInit(v, t));
        }
        Val t_v1 = this.provider.newVal();
        this.insns.add(new VarLoad(t_v1, this.var(vm.get(0))));
        this.insns.addBranch(new Branch.Condition.Nil(t_v1), l_done);
        this.insns.add(new VarStore(v_var, t_v1));
        this.breakLabels.push(l_done);
        this.nestedBlock(node.block());
        this.breakLabels.pop();
        this.insns.add(new Jmp(l_top));
        this.insns.add(l_done);
        this.endStatement();
        return node;
    }

    @Override
    public BodyStatement transform(WhileStatement node) {
        Label l_test = this.insns.newLabel();
        Label l_done = this.insns.newLabel();
        this.insns.atLine(node.line());
        this.insns.add(l_test);
        node.condition().accept(this);
        Val c = this.popVal();
        this.insns.addBranch(new Branch.Condition.Bool(c, false), l_done);
        this.breakLabels.push(l_done);
        this.nestedBlock(node.block());
        this.breakLabels.pop();
        this.insns.add(new Jmp(l_test));
        this.insns.add(l_done);
        this.endStatement();
        return node;
    }

    @Override
    public BodyStatement transform(RepeatUntilStatement node) {
        Label l_body = this.insns.newLabel();
        Label l_done = this.insns.newLabel();
        this.insns.atLine(node.line());
        this.insns.add(l_body);
        this.breakLabels.push(l_done);
        this.nestedBlock(node.block());
        this.breakLabels.pop();
        node.condition().accept(this);
        Val c = this.popVal();
        this.insns.addBranch(new Branch.Condition.Bool(c, true), l_done);
        this.insns.add(new Jmp(l_body));
        this.insns.add(l_done);
        this.endStatement();
        return node;
    }

    @Override
    public BodyStatement transform(LabelStatement node) {
        ResolvedLabel rl = TranslationUtils.resolvedLabel(node);
        this.insns.add(this.userLabel(rl));
        this.insns.atLine(node.line());
        this.endStatement();
        return node;
    }

    @Override
    public BodyStatement transform(GotoStatement node) {
        ResolvedLabel rl = TranslationUtils.resolvedLabel(node);
        this.insns.atLine(node.line());
        this.insns.add(new Jmp(this.userLabel(rl)));
        this.endStatement();
        return node;
    }

    @Override
    public BodyStatement transform(BreakStatement node) {
        this.insns.atLine(node.line());
        if (this.breakLabels.isEmpty()) {
            throw new IllegalStateException("<break> at " + AttributeUtils.sourceInfoString(node) + " not inside a loop");
        }
        Label l = this.breakLabels.peek();
        this.insns.add(new Jmp(l));
        this.endStatement();
        return node;
    }

    @Override
    public BodyStatement transform(CallStatement node) {
        this.insns.atLine(node.line());
        node.callExpr().accept(this);
        this.endStatement();
        return node;
    }
}

