/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis;

import org.classdump.luna.compiler.ir.AbstractVar;
import org.classdump.luna.compiler.ir.BinOp;
import org.classdump.luna.compiler.ir.Branch;
import org.classdump.luna.compiler.ir.Call;
import org.classdump.luna.compiler.ir.Closure;
import org.classdump.luna.compiler.ir.IRVisitor;
import org.classdump.luna.compiler.ir.Jmp;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.LoadConst;
import org.classdump.luna.compiler.ir.MultiGet;
import org.classdump.luna.compiler.ir.MultiVal;
import org.classdump.luna.compiler.ir.PhiLoad;
import org.classdump.luna.compiler.ir.PhiStore;
import org.classdump.luna.compiler.ir.PhiVal;
import org.classdump.luna.compiler.ir.Ret;
import org.classdump.luna.compiler.ir.TCall;
import org.classdump.luna.compiler.ir.TabGet;
import org.classdump.luna.compiler.ir.TabNew;
import org.classdump.luna.compiler.ir.TabRawAppendMulti;
import org.classdump.luna.compiler.ir.TabRawSet;
import org.classdump.luna.compiler.ir.TabRawSetInt;
import org.classdump.luna.compiler.ir.TabSet;
import org.classdump.luna.compiler.ir.ToNext;
import org.classdump.luna.compiler.ir.ToNumber;
import org.classdump.luna.compiler.ir.UnOp;
import org.classdump.luna.compiler.ir.UpLoad;
import org.classdump.luna.compiler.ir.UpStore;
import org.classdump.luna.compiler.ir.UpVar;
import org.classdump.luna.compiler.ir.VList;
import org.classdump.luna.compiler.ir.Val;
import org.classdump.luna.compiler.ir.Var;
import org.classdump.luna.compiler.ir.VarInit;
import org.classdump.luna.compiler.ir.VarLoad;
import org.classdump.luna.compiler.ir.VarStore;
import org.classdump.luna.compiler.ir.Vararg;

abstract class AbstractUseDefVisitor
extends IRVisitor {
    AbstractUseDefVisitor() {
    }

    protected abstract void def(Val var1);

    protected abstract void use(Val var1);

    protected abstract void def(PhiVal var1);

    protected abstract void use(PhiVal var1);

    protected abstract void def(MultiVal var1);

    protected abstract void use(MultiVal var1);

    protected abstract void def(Var var1);

    protected abstract void use(Var var1);

    protected abstract void def(UpVar var1);

    protected abstract void use(UpVar var1);

    @Override
    public void visit(LoadConst.Nil node) {
        this.def(node.dest());
    }

    @Override
    public void visit(LoadConst.Bool node) {
        this.def(node.dest());
    }

    @Override
    public void visit(LoadConst.Int node) {
        this.def(node.dest());
    }

    @Override
    public void visit(LoadConst.Flt node) {
        this.def(node.dest());
    }

    @Override
    public void visit(LoadConst.Str node) {
        this.def(node.dest());
    }

    @Override
    public void visit(BinOp node) {
        this.use(node.left());
        this.use(node.right());
        this.def(node.dest());
    }

    @Override
    public void visit(UnOp node) {
        this.use(node.arg());
        this.def(node.dest());
    }

    @Override
    public void visit(TabNew node) {
        this.def(node.dest());
    }

    @Override
    public void visit(TabGet node) {
        this.use(node.obj());
        this.use(node.key());
        this.def(node.dest());
    }

    @Override
    public void visit(TabSet node) {
        this.use(node.obj());
        this.use(node.key());
        this.use(node.value());
    }

    @Override
    public void visit(TabRawSet node) {
        this.use(node.obj());
        this.use(node.key());
        this.use(node.value());
    }

    @Override
    public void visit(TabRawSetInt node) {
        this.use(node.obj());
        this.use(node.value());
    }

    @Override
    public void visit(TabRawAppendMulti node) {
        this.use(node.obj());
        this.use(node.src());
    }

    @Override
    public void visit(VarInit node) {
        this.use(node.src());
        this.def(node.var());
    }

    @Override
    public void visit(VarLoad node) {
        this.use(node.var());
        this.def(node.dest());
    }

    @Override
    public void visit(VarStore node) {
        this.use(node.src());
        this.def(node.var());
    }

    @Override
    public void visit(UpLoad node) {
        this.use(node.upval());
        this.def(node.dest());
    }

    @Override
    public void visit(UpStore node) {
        this.use(node.src());
        this.def(node.upval());
    }

    @Override
    public void visit(Vararg node) {
        this.def(node.dest());
    }

    protected void use(VList vlist) {
        for (Val v : vlist.addrs()) {
            this.use(v);
        }
        if (vlist.suffix() != null) {
            this.use(vlist.suffix());
        }
    }

    @Override
    public void visit(Ret node) {
        this.use(node.args());
    }

    @Override
    public void visit(TCall node) {
        this.use(node.target());
        this.use(node.args());
    }

    @Override
    public void visit(Call node) {
        this.use(node.fn());
        this.use(node.args());
        this.def(node.dest());
    }

    @Override
    public void visit(MultiGet node) {
        this.use(node.src());
        this.def(node.dest());
    }

    @Override
    public void visit(PhiStore node) {
        this.use(node.src());
        this.def(node.dest());
    }

    @Override
    public void visit(PhiLoad node) {
        this.use(node.src());
        this.def(node.dest());
    }

    @Override
    public void visit(Label node) {
    }

    @Override
    public void visit(Jmp node) {
    }

    @Override
    public void visit(Closure node) {
        for (AbstractVar v : node.args()) {
            if (v instanceof Var) {
                this.use((Var)v);
                continue;
            }
            if (v instanceof UpVar) {
                this.use((UpVar)v);
                continue;
            }
            throw new IllegalStateException("Illegal abstract var: " + v);
        }
        this.def(node.dest());
    }

    @Override
    public void visit(ToNumber node) {
        this.use(node.src());
        this.def(node.dest());
    }

    @Override
    public void visit(ToNext node) {
    }

    @Override
    public void visit(Branch branch) {
        branch.condition().accept(this);
    }

    @Override
    public void visit(Branch.Condition.Nil cond) {
        this.use(cond.addr());
    }

    @Override
    public void visit(Branch.Condition.Bool cond) {
        this.use(cond.addr());
    }

    @Override
    public void visit(Branch.Condition.NumLoopEnd cond) {
        this.use(cond.var());
        this.use(cond.limit());
        this.use(cond.step());
    }
}

