/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.classdump.luna.compiler.IRFunc;
import org.classdump.luna.compiler.analysis.AbstractUseDefVisitor;
import org.classdump.luna.compiler.analysis.LivenessAnalyser;
import org.classdump.luna.compiler.analysis.LivenessInfo;
import org.classdump.luna.compiler.analysis.SlotAllocInfo;
import org.classdump.luna.compiler.ir.AbstractVal;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.IRNode;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.MultiVal;
import org.classdump.luna.compiler.ir.PhiVal;
import org.classdump.luna.compiler.ir.UpVar;
import org.classdump.luna.compiler.ir.Val;
import org.classdump.luna.compiler.ir.Var;

public class SlotAllocator {
    private final IRFunc fn;
    private final Map<AbstractVal, Integer> valSlots;
    private final Map<Var, Integer> varSlots;
    private IRNode currentNode;

    public SlotAllocator(IRFunc fn) {
        this.fn = Objects.requireNonNull(fn);
        this.valSlots = new HashMap<AbstractVal, Integer>();
        this.varSlots = new HashMap<Var, Integer>();
    }

    public static SlotAllocInfo allocateSlots(IRFunc fn) {
        SlotAllocator allocator = new SlotAllocator(fn);
        return allocator.process();
    }

    private IRNode node() {
        if (this.currentNode == null) {
            throw new IllegalStateException("Current node is null");
        }
        return this.currentNode;
    }

    private boolean hasSlot(Var v) {
        return this.varSlots.get(Objects.requireNonNull(v)) != null;
    }

    private boolean hasSlot(AbstractVal v) {
        return this.valSlots.get(Objects.requireNonNull(v)) != null;
    }

    private int slotOf(Var v) {
        Objects.requireNonNull(v);
        Integer idx = this.varSlots.get(v);
        if (idx == null) {
            throw new NoSuchElementException("Slot not defined for variable " + v);
        }
        return idx;
    }

    private int slotOf(AbstractVal v) {
        Objects.requireNonNull(v);
        Integer idx = this.valSlots.get(v);
        if (idx == null) {
            throw new NoSuchElementException("Slot not defined for value " + v);
        }
        return idx;
    }

    private BitSet occupiedSlots(LivenessInfo liveness, IRNode node) {
        int idx;
        BitSet occupied = new BitSet();
        LivenessInfo.Entry e = liveness.entry(node);
        for (Var var : e.inVar()) {
            idx = this.slotOf(var);
            if (occupied.get(idx)) {
                throw new IllegalStateException("Slot " + idx + " already occupied");
            }
            if (!e.outVar().contains(var)) continue;
            occupied.set(this.slotOf(var));
        }
        for (AbstractVal abstractVal : e.inVal()) {
            idx = this.slotOf(abstractVal);
            if (occupied.get(idx)) {
                throw new IllegalStateException("Slot " + idx + " already occupied");
            }
            if (!e.outVal().contains(abstractVal)) continue;
            occupied.set(this.slotOf(abstractVal));
        }
        return occupied;
    }

    private int findFreeSlot(LivenessInfo liveness, IRNode node) {
        BitSet occupied = this.occupiedSlots(liveness, node);
        int idx = 0;
        while (occupied.get(idx)) {
            ++idx;
        }
        assert (!occupied.get(idx));
        return idx;
    }

    private void assignParamSlots(List<Var> params) {
        int idx = 0;
        for (Var v : params) {
            this.varSlots.put(v, idx++);
        }
    }

    private void assignSlot(Var v, LivenessInfo liveness, IRNode node) {
        if (this.hasSlot(v)) {
            throw new IllegalStateException("Slot already assigned for variable " + v);
        }
        this.varSlots.put(v, this.findFreeSlot(liveness, node));
    }

    private void assignSlot(AbstractVal v, LivenessInfo liveness, IRNode node) {
        if (this.hasSlot(v)) {
            throw new IllegalStateException("Slot already assigned for value " + v);
        }
        this.valSlots.put(v, this.findFreeSlot(liveness, node));
    }

    public SlotAllocInfo process() {
        LivenessInfo liveness = LivenessAnalyser.computeLiveness(this.fn);
        HashSet<Label> visited = new HashSet<Label>();
        ArrayDeque<Label> open = new ArrayDeque<Label>();
        open.push(this.fn.code().entryLabel());
        AllocatorVisitor visitor = new AllocatorVisitor(liveness);
        this.assignParamSlots(this.fn.params());
        while (!open.isEmpty()) {
            Label l = (Label)open.pop();
            if (!visited.add(l)) continue;
            BasicBlock b = this.fn.code().block(l);
            this.assignSlots(b, visitor);
            for (Label n : b.end().nextLabels()) {
                open.push(n);
            }
        }
        return new SlotAllocInfo(Collections.unmodifiableMap(this.valSlots), Collections.unmodifiableMap(this.varSlots));
    }

    private void assignSlots(BasicBlock b, AllocatorVisitor visitor) {
        for (BodyNode n : b.body()) {
            this.currentNode = n;
            n.accept(visitor);
            this.currentNode = null;
        }
        this.currentNode = b.end();
        b.end().accept(visitor);
        this.currentNode = null;
    }

    private class AllocatorVisitor
    extends AbstractUseDefVisitor {
        private final LivenessInfo liveness;

        AllocatorVisitor(LivenessInfo liveness) {
            this.liveness = Objects.requireNonNull(liveness);
        }

        @Override
        protected void def(Val v) {
            if (SlotAllocator.this.hasSlot(v)) {
                throw new IllegalStateException("Value " + v + " already assigned to a slot");
            }
            SlotAllocator.this.assignSlot(v, this.liveness, SlotAllocator.this.node());
        }

        @Override
        protected void use(Val v) {
            if (!SlotAllocator.this.hasSlot(v)) {
                throw new IllegalStateException("Value " + v + " not assigned to a slot");
            }
        }

        @Override
        protected void def(PhiVal pv) {
            if (!SlotAllocator.this.hasSlot(pv)) {
                SlotAllocator.this.assignSlot(pv, this.liveness, SlotAllocator.this.node());
            }
        }

        @Override
        protected void use(PhiVal pv) {
            if (!SlotAllocator.this.hasSlot(pv)) {
                throw new IllegalStateException("Value " + pv + " not assigned to a slot");
            }
        }

        @Override
        protected void def(MultiVal mv) {
        }

        @Override
        protected void use(MultiVal mv) {
        }

        @Override
        protected void def(Var v) {
            if (!SlotAllocator.this.hasSlot(v)) {
                SlotAllocator.this.assignSlot(v, this.liveness, SlotAllocator.this.node());
            }
        }

        @Override
        protected void use(Var v) {
            if (!SlotAllocator.this.hasSlot(v)) {
                throw new IllegalStateException("No slot assigned to variable " + v);
            }
        }

        @Override
        protected void def(UpVar uv) {
        }

        @Override
        protected void use(UpVar uv) {
        }
    }
}

