/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.analysis;

import org.classdump.luna.ByteString;
import org.classdump.luna.Conversions;
import org.classdump.luna.LuaMathOperators;
import org.classdump.luna.Ordering;
import org.classdump.luna.compiler.IRFunc;
import org.classdump.luna.compiler.analysis.TypeInfo;
import org.classdump.luna.compiler.analysis.TyperVisitor;
import org.classdump.luna.compiler.analysis.types.LiteralType;
import org.classdump.luna.compiler.analysis.types.LuaTypes;
import org.classdump.luna.compiler.analysis.types.Type;
import org.classdump.luna.compiler.ir.BinOp;
import org.classdump.luna.compiler.ir.UnOp;
import org.classdump.luna.runtime.Dispatch;

public class Typer {
    private static Object literalValue(Type t) {
        return t instanceof LiteralType ? ((LiteralType)t).value() : null;
    }

    private static LiteralType<?> objectToLiteralType(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            if (n instanceof Double || n instanceof Float) {
                return LuaTypes.NUMBER_FLOAT.newLiteralType(n.doubleValue());
            }
            return LuaTypes.NUMBER_INTEGER.newLiteralType(n.longValue());
        }
        if (o instanceof ByteString) {
            return LuaTypes.STRING.newLiteralType((ByteString)o);
        }
        if (o instanceof Boolean) {
            return LuaTypes.BOOLEAN.newLiteralType((Boolean)o);
        }
        return null;
    }

    private static Object tryEmulateArithmeticOperation(BinOp.Op op, Object l, Object r) {
        Number nl = Conversions.arithmeticValueOf(l);
        Number nr = Conversions.arithmeticValueOf(r);
        if (nl == null || nr == null) {
            return null;
        }
        try {
            switch (op) {
                case ADD: {
                    return Dispatch.add(nl, nr);
                }
                case SUB: {
                    return Dispatch.sub(nl, nr);
                }
                case MUL: {
                    return Dispatch.mul(nl, nr);
                }
                case DIV: {
                    return Dispatch.div(nl, nr);
                }
                case MOD: {
                    return Dispatch.mod(nl, nr);
                }
                case IDIV: {
                    return Dispatch.idiv(nl, nr);
                }
                case POW: {
                    return Dispatch.pow(nl, nr);
                }
            }
            throw new IllegalArgumentException("Illegal operation: " + (Object)((Object)op));
        }
        catch (ArithmeticException ex) {
            return null;
        }
    }

    private static Object tryEmulateBitwiseOperation(BinOp.Op op, Object l, Object r) {
        Long il = Conversions.integerValueOf(l);
        Long ir = Conversions.integerValueOf(r);
        if (il == null || ir == null) {
            return null;
        }
        switch (op) {
            case BAND: {
                return LuaMathOperators.band(il, ir);
            }
            case BOR: {
                return LuaMathOperators.bor(il, ir);
            }
            case BXOR: {
                return LuaMathOperators.bxor(il, ir);
            }
            case SHL: {
                return LuaMathOperators.shl(il, ir);
            }
            case SHR: {
                return LuaMathOperators.shr(il, ir);
            }
        }
        throw new IllegalArgumentException("Illegal operation: " + (Object)((Object)op));
    }

    private static ByteString tryEmulateConcatOperation(Object l, Object r) {
        ByteString sl = Conversions.stringValueOf(l);
        ByteString sr = Conversions.stringValueOf(r);
        if (sl == null || sr == null) {
            return null;
        }
        return sl.concat(sr);
    }

    private static Object tryEmulateComparisonOperation(BinOp.Op op, Object l, Object r) {
        if (l == null || r == null) {
            return null;
        }
        Ordering<Object> c = Ordering.of(l, r);
        if (c == null) {
            return null;
        }
        switch (op) {
            case EQ: {
                return c.eq(l, r);
            }
            case NEQ: {
                return !c.eq(l, r);
            }
            case LT: {
                return c.lt(l, r);
            }
            case LE: {
                return c.le(l, r);
            }
        }
        throw new IllegalArgumentException("Illegal operation: " + (Object)((Object)op));
    }

    private static Object tryEmulateOperation(BinOp.Op op, Object l, Object r) {
        if (l == null || r == null) {
            return null;
        }
        switch (op) {
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: 
            case IDIV: 
            case POW: {
                return Typer.tryEmulateArithmeticOperation(op, l, r);
            }
            case BAND: 
            case BOR: 
            case BXOR: 
            case SHL: 
            case SHR: {
                return Typer.tryEmulateBitwiseOperation(op, l, r);
            }
            case CONCAT: {
                return Typer.tryEmulateConcatOperation(l, r);
            }
            case EQ: 
            case NEQ: 
            case LT: 
            case LE: {
                return Typer.tryEmulateComparisonOperation(op, l, r);
            }
        }
        throw new IllegalArgumentException("Illegal operation: " + (Object)((Object)op));
    }

    private static Object tryEmulateOperation(UnOp.Op op, Object arg) {
        if (arg == null) {
            return null;
        }
        switch (op) {
            case UNM: {
                Number n = Conversions.arithmeticValueOf(arg);
                return n != null ? (Number)Dispatch.unm(n) : (Number)null;
            }
            case BNOT: {
                Long l = Conversions.integerValueOf(arg);
                return l != null ? Long.valueOf(LuaMathOperators.bnot(l)) : null;
            }
            case NOT: {
                return arg.equals(Boolean.FALSE);
            }
            case LEN: {
                if (arg instanceof String) {
                    return Dispatch.len((String)arg);
                }
                if (arg instanceof ByteString) {
                    return (long)((ByteString)arg).length();
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Illegal operation: " + (Object)((Object)op));
    }

    static LiteralType<?> emulateOp(BinOp.Op op, Type l, Type r) {
        Object result = Typer.tryEmulateOperation(op, Typer.literalValue(l), Typer.literalValue(r));
        return result != null ? Typer.objectToLiteralType(result) : null;
    }

    static LiteralType<?> emulateOp(UnOp.Op op, Type t) {
        Object result = Typer.tryEmulateOperation(op, Typer.literalValue(t));
        return result != null ? Typer.objectToLiteralType(result) : null;
    }

    public static TypeInfo analyseTypes(IRFunc fn) {
        TyperVisitor visitor = new TyperVisitor();
        visitor.visit(fn);
        return visitor.valTypes();
    }
}

