/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.Code;
import org.classdump.luna.compiler.ir.Label;

public class SegmentedCode {
    private final List<List<BasicBlock>> segments;
    private final Map<Label, LabelEntry> index;

    private SegmentedCode(List<List<BasicBlock>> segments, Map<Label, LabelEntry> index) {
        this.segments = Objects.requireNonNull(segments);
        this.index = Objects.requireNonNull(index);
    }

    public static SegmentedCode singleton(Code code) {
        ArrayList<List<BasicBlock>> blocks = new ArrayList<List<BasicBlock>>();
        ArrayList<BasicBlock> blks = new ArrayList<BasicBlock>();
        Iterator<BasicBlock> bit = code.blockIterator();
        while (bit.hasNext()) {
            blks.add(bit.next());
        }
        blocks.add(Collections.unmodifiableList(blks));
        return SegmentedCode.of(blocks);
    }

    public static SegmentedCode of(List<List<BasicBlock>> segments) {
        List<List<BasicBlock>> segs = Collections.unmodifiableList(segments);
        HashMap<Label, LabelEntry> index = new HashMap<Label, LabelEntry>();
        for (int i = 0; i < segs.size(); ++i) {
            int j = 0;
            for (BasicBlock blk : segs.get(i)) {
                index.put(blk.label(), new LabelEntry(blk.label(), i, j));
                ++j;
            }
        }
        return new SegmentedCode(segs, Collections.unmodifiableMap(index));
    }

    public List<List<BasicBlock>> segments() {
        return this.segments;
    }

    public LabelEntry labelEntry(Label l) {
        LabelEntry le = this.index.get(Objects.requireNonNull(l));
        if (le == null) {
            throw new IllegalStateException("Label not found: " + l);
        }
        return le;
    }

    public boolean isSingleton() {
        return this.segments.size() == 1;
    }

    public static class LabelEntry {
        public final Label label;
        public final int segmentIdx;
        public final int idx;

        public LabelEntry(Label label, int segmentIdx, int idx) {
            this.label = Objects.requireNonNull(label);
            this.segmentIdx = segmentIdx;
            this.idx = idx;
        }
    }
}

