/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.Table;
import org.classdump.luna.Variable;
import org.classdump.luna.compiler.CompilerSettings;
import org.classdump.luna.compiler.FunctionId;
import org.classdump.luna.compiler.analysis.SlotAllocInfo;
import org.classdump.luna.compiler.analysis.TypeInfo;
import org.classdump.luna.compiler.gen.ClassNameTranslator;
import org.classdump.luna.compiler.gen.asm.ASMBytecodeEmitter;
import org.classdump.luna.compiler.gen.asm.RunMethod;
import org.classdump.luna.compiler.gen.asm.helpers.ASMUtils;
import org.classdump.luna.compiler.gen.asm.helpers.BoxedPrimitivesMethods;
import org.classdump.luna.compiler.gen.asm.helpers.ConversionMethods;
import org.classdump.luna.compiler.gen.asm.helpers.DispatchMethods;
import org.classdump.luna.compiler.gen.asm.helpers.ExecutionContextMethods;
import org.classdump.luna.compiler.gen.asm.helpers.ReturnBufferMethods;
import org.classdump.luna.compiler.gen.asm.helpers.TableMethods;
import org.classdump.luna.compiler.gen.asm.helpers.VariableMethods;
import org.classdump.luna.compiler.ir.AbstractVal;
import org.classdump.luna.compiler.ir.AbstractVar;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.BinOp;
import org.classdump.luna.compiler.ir.Branch;
import org.classdump.luna.compiler.ir.CPUWithdraw;
import org.classdump.luna.compiler.ir.Call;
import org.classdump.luna.compiler.ir.Closure;
import org.classdump.luna.compiler.ir.CodeVisitor;
import org.classdump.luna.compiler.ir.Jmp;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.Line;
import org.classdump.luna.compiler.ir.LoadConst;
import org.classdump.luna.compiler.ir.MultiGet;
import org.classdump.luna.compiler.ir.PhiLoad;
import org.classdump.luna.compiler.ir.PhiStore;
import org.classdump.luna.compiler.ir.Ret;
import org.classdump.luna.compiler.ir.TCall;
import org.classdump.luna.compiler.ir.TabGet;
import org.classdump.luna.compiler.ir.TabNew;
import org.classdump.luna.compiler.ir.TabRawAppendMulti;
import org.classdump.luna.compiler.ir.TabRawSet;
import org.classdump.luna.compiler.ir.TabRawSetInt;
import org.classdump.luna.compiler.ir.TabSet;
import org.classdump.luna.compiler.ir.ToNext;
import org.classdump.luna.compiler.ir.ToNumber;
import org.classdump.luna.compiler.ir.UnOp;
import org.classdump.luna.compiler.ir.UpLoad;
import org.classdump.luna.compiler.ir.UpStore;
import org.classdump.luna.compiler.ir.UpVar;
import org.classdump.luna.compiler.ir.VList;
import org.classdump.luna.compiler.ir.Val;
import org.classdump.luna.compiler.ir.Var;
import org.classdump.luna.compiler.ir.VarInit;
import org.classdump.luna.compiler.ir.VarLoad;
import org.classdump.luna.compiler.ir.VarStore;
import org.classdump.luna.compiler.ir.Vararg;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.ReturnBuffer;
import org.classdump.luna.shaded.org.objectweb.asm.Opcodes;
import org.classdump.luna.shaded.org.objectweb.asm.Type;
import org.classdump.luna.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FieldInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FieldNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FrameNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.IincInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnList;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.JumpInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LabelNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LdcInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LineNumberNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LocalVariableNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.TypeInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.VarInsnNode;

class BytecodeEmitVisitor
extends CodeVisitor {
    private final ASMBytecodeEmitter context;
    private final RunMethod runMethod;
    private final SlotAllocInfo slots;
    private final TypeInfo types;
    private final int segmentIdx;
    private final RunMethod.LabelResolver resolver;
    final Map<Object, LabelNode> labels;
    private final ArrayList<LabelNode> resumptionPoints;
    private final InsnList il;
    private final List<LocalVariableNode> locals;
    private final List<RunMethod.ClosureFieldInstance> instanceLevelClosures;
    private final List<RunMethod.ConstFieldInstance> constFields;
    private Label destLabel;

    public BytecodeEmitVisitor(ASMBytecodeEmitter context, RunMethod runMethod, SlotAllocInfo slots, TypeInfo types, List<RunMethod.ClosureFieldInstance> instanceLevelClosures, List<RunMethod.ConstFieldInstance> constFields, int segmentIdx, RunMethod.LabelResolver resolver) {
        this.context = Objects.requireNonNull(context);
        this.runMethod = Objects.requireNonNull(runMethod);
        this.slots = Objects.requireNonNull(slots);
        this.types = Objects.requireNonNull(types);
        this.segmentIdx = segmentIdx;
        this.resolver = Objects.requireNonNull(resolver);
        this.labels = new HashMap<Object, LabelNode>();
        this.resumptionPoints = new ArrayList();
        this.il = new InsnList();
        this.locals = new ArrayList<LocalVariableNode>();
        this.instanceLevelClosures = Objects.requireNonNull(instanceLevelClosures);
        this.constFields = Objects.requireNonNull(constFields);
    }

    private boolean isSub() {
        return this.segmentIdx >= 0;
    }

    public InsnList instructions() {
        return this.il;
    }

    public List<LocalVariableNode> locals() {
        return this.locals;
    }

    public List<RunMethod.ClosureFieldInstance> instanceLevelClosures() {
        return this.instanceLevelClosures;
    }

    public List<RunMethod.ConstFieldInstance> constFields() {
        return this.constFields;
    }

    protected int slot(AbstractVal v) {
        return this.runMethod.slotOffset() + this.slots.slotOf(v);
    }

    protected int slot(Var v) {
        return this.runMethod.slotOffset() + this.slots.slotOf(v);
    }

    protected int nextLocalVariableIndex() {
        return this.runMethod.slotOffset() + this.slots.numSlots();
    }

    private LabelNode l(Object o) {
        LabelNode l = this.labels.get(o);
        if (l != null) {
            return l;
        }
        LabelNode nl = new LabelNode();
        this.labels.put(o, nl);
        return nl;
    }

    private RunMethod.ConstFieldInstance newConstFieldInstance(final Object constValue, int idx) {
        Objects.requireNonNull(constValue);
        String fieldName = "_k_" + idx;
        if (constValue instanceof Double || constValue instanceof Long) {
            Type t = Type.getType(constValue.getClass());
            return new RunMethod.ConstFieldInstance(constValue, fieldName, this.context.thisClassType(), t){

                @Override
                public void doInstantiate(InsnList il) {
                    il.add(BoxedPrimitivesMethods.loadBoxedConstant(constValue));
                }
            };
        }
        if (constValue instanceof ByteString) {
            Type t = Type.getType(constValue.getClass());
            return new RunMethod.ConstFieldInstance(constValue, fieldName, this.context.thisClassType(), Type.getType(ByteString.class)){

                @Override
                public void doInstantiate(InsnList il) {
                    il.add(BytecodeEmitVisitor.newByteString((ByteString)constValue));
                }
            };
        }
        throw new UnsupportedOperationException("Illegal constant: " + constValue);
    }

    private static InsnList newByteString(ByteString value) {
        InsnList il = new InsnList();
        il.add(new LdcInsnNode(value.toRawString()));
        il.add(new MethodInsnNode(184, Type.getInternalName(ByteString.class), "fromRaw", Type.getMethodDescriptor(Type.getType(ByteString.class), Type.getType(String.class)), false));
        return il;
    }

    private InsnList loadCachedConst(Object constValue) {
        for (RunMethod.ConstFieldInstance cfi : this.constFields) {
            if (!cfi.value().equals(constValue)) continue;
            return cfi.accessInsns();
        }
        RunMethod.ConstFieldInstance cfi = this.newConstFieldInstance(constValue, this.constFields.size());
        this.constFields.add(cfi);
        return cfi.accessInsns();
    }

    public AbstractInsnNode loadExecutionContext() {
        return new VarInsnNode(25, this.runMethod.LV_CONTEXT);
    }

    static AbstractInsnNode loadReturnBuffer() {
        return new MethodInsnNode(185, Type.getInternalName(ExecutionContext.class), "getReturnBuffer", Type.getMethodDescriptor(Type.getType(ReturnBuffer.class), new Type[0]), true);
    }

    public InsnList retrieve_0() {
        InsnList il = new InsnList();
        il.add(this.loadExecutionContext());
        il.add(BytecodeEmitVisitor.loadReturnBuffer());
        il.add(ReturnBufferMethods.get(0));
        return il;
    }

    public InsnList loadUpvalueRef(UpVar uv) {
        InsnList il = new InsnList();
        il.add(new VarInsnNode(25, 0));
        il.add(new FieldInsnNode(180, this.context.thisClassType().getInternalName(), this.context.getUpvalueFieldName(uv), Type.getDescriptor(Variable.class)));
        return il;
    }

    private InsnList saveState(int state) {
        InsnList il = new InsnList();
        il.add(ASMUtils.loadInt(state));
        il.add(new VarInsnNode(54, this.runMethod.LV_RESUME));
        return il;
    }

    public void visitBlocks(List<BasicBlock> blocks) {
        for (BasicBlock b : blocks) {
            this.visit(b);
        }
    }

    protected ResumptionPoint newResumptionPoint() {
        int idx = this.resumptionPoints.size();
        ResumptionPoint rp = new ResumptionPoint(idx);
        this.resumptionPoints.add(rp.label());
        return rp;
    }

    public boolean isResumable() {
        return this.isSub() || this.resumptionPoints.size() > 0;
    }

    public List<LabelNode> resumptionLabels() {
        return this.resumptionPoints;
    }

    private InsnList _return() {
        InsnList il = new InsnList();
        if (!this.isSub()) {
            il.add(new InsnNode(177));
        } else {
            il.add(new InsnNode(1));
            il.add(new InsnNode(176));
        }
        return il;
    }

    private InsnList _nonLocalGoto(Label label) {
        InsnList il = new InsnList();
        int st = this.resolver.labelStateIndex(label);
        il.add(this.saveState(st));
        il.add(this.runMethod.createSnapshot());
        il.add(new InsnNode(176));
        return il;
    }

    private InsnList _goto(Label label) {
        InsnList il = new InsnList();
        if (!this.isSub() || this.resolver.isLocalLabel(label)) {
            il.add(new JumpInsnNode(167, this.l(label)));
        } else {
            il.add(this._nonLocalGoto(label));
        }
        return il;
    }

    private InsnList _next(Label label) {
        InsnList il = new InsnList();
        if (this.isSub() && !this.resolver.isLocalLabel(label)) {
            il.add(this._nonLocalGoto(label));
        }
        return il;
    }

    @Override
    public void visit(PhiStore node) {
        this.il.add(new VarInsnNode(25, this.slot(node.src())));
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(PhiLoad node) {
        this.il.add(new VarInsnNode(25, this.slot(node.src())));
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(VarInit node) {
        if (this.types.isReified(node.var())) {
            this.il.add(new TypeInsnNode(187, Type.getInternalName(Variable.class)));
            this.il.add(new InsnNode(89));
            this.il.add(new VarInsnNode(25, this.slot(node.src())));
            this.il.add(VariableMethods.constructor());
            this.il.add(new VarInsnNode(58, this.slot(node.var())));
        } else {
            this.il.add(new VarInsnNode(25, this.slot(node.src())));
            this.il.add(new VarInsnNode(58, this.slot(node.var())));
        }
    }

    @Override
    public void visit(VarStore node) {
        if (this.types.isReified(node.var())) {
            this.il.add(new VarInsnNode(25, this.slot(node.var())));
            this.il.add(new TypeInsnNode(192, Type.getInternalName(Variable.class)));
            this.il.add(new VarInsnNode(25, this.slot(node.src())));
            this.il.add(VariableMethods.set());
        } else {
            this.il.add(new VarInsnNode(25, this.slot(node.src())));
            this.il.add(new VarInsnNode(58, this.slot(node.var())));
        }
    }

    @Override
    public void visit(VarLoad node) {
        if (this.types.isReified(node.var())) {
            this.il.add(new VarInsnNode(25, this.slot(node.var())));
            this.il.add(new TypeInsnNode(192, Type.getInternalName(Variable.class)));
            this.il.add(VariableMethods.get());
        } else {
            this.il.add(new VarInsnNode(25, this.slot(node.var())));
        }
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(UpLoad node) {
        this.il.add(this.loadUpvalueRef(node.upval()));
        this.il.add(VariableMethods.get());
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(UpStore node) {
        this.il.add(this.loadUpvalueRef(node.upval()));
        this.il.add(new VarInsnNode(25, this.slot(node.src())));
        this.il.add(VariableMethods.set());
    }

    @Override
    public void visit(LoadConst.Nil node) {
        this.il.add(new InsnNode(1));
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(LoadConst.Bool node) {
        this.il.add(BoxedPrimitivesMethods.loadBoxedBoolean(node.value()));
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(LoadConst.Int node) {
        if (this.context.compilerSettings.constCaching()) {
            this.il.add(this.loadCachedConst(node.value()));
        } else {
            this.il.add(ASMUtils.loadLong(node.value()));
            this.il.add(BoxedPrimitivesMethods.box(Type.LONG_TYPE, Type.getType(Long.class)));
        }
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(LoadConst.Flt node) {
        if (this.context.compilerSettings.constCaching()) {
            this.il.add(this.loadCachedConst(node.value()));
        } else {
            this.il.add(ASMUtils.loadDouble(node.value()));
            this.il.add(BoxedPrimitivesMethods.box(Type.DOUBLE_TYPE, Type.getType(Double.class)));
        }
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(LoadConst.Str node) {
        if (this.context.compilerSettings.byteStrings()) {
            if (this.context.compilerSettings.constCaching()) {
                this.il.add(this.loadCachedConst(node.value()));
            } else {
                this.il.add(BytecodeEmitVisitor.newByteString(node.value()));
            }
        } else {
            this.il.add(new LdcInsnNode(node.value()));
        }
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    private static String dispatchMethodName(BinOp.Op op) {
        switch (op) {
            case ADD: {
                return "add";
            }
            case SUB: {
                return "sub";
            }
            case MUL: {
                return "mul";
            }
            case MOD: {
                return "mod";
            }
            case POW: {
                return "pow";
            }
            case DIV: {
                return "div";
            }
            case IDIV: {
                return "idiv";
            }
            case BAND: {
                return "band";
            }
            case BOR: {
                return "bor";
            }
            case BXOR: {
                return "bxor";
            }
            case SHL: {
                return "shl";
            }
            case SHR: {
                return "shr";
            }
            case CONCAT: {
                return "concat";
            }
            case EQ: {
                return "eq";
            }
            case NEQ: {
                return "neq";
            }
            case LT: {
                return "lt";
            }
            case LE: {
                return "le";
            }
        }
        throw new IllegalArgumentException("Illegal binary operation: " + (Object)((Object)op));
    }

    private static String dispatchMethodName(UnOp.Op op) {
        switch (op) {
            case UNM: {
                return "unm";
            }
            case BNOT: {
                return "bnot";
            }
            case LEN: {
                return "len";
            }
        }
        throw new IllegalArgumentException("Illegal unary operation: " + (Object)((Object)op));
    }

    @Override
    public void visit(BinOp node) {
        ResumptionPoint rp = this.newResumptionPoint();
        this.il.add(rp.save());
        this.il.add(this.loadExecutionContext());
        this.il.add(new VarInsnNode(25, this.slot(node.left())));
        this.il.add(new VarInsnNode(25, this.slot(node.right())));
        this.il.add(DispatchMethods.dynamic(BytecodeEmitVisitor.dispatchMethodName(node.op()), 2));
        this.il.add(rp.resume());
        this.il.add(this.retrieve_0());
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(UnOp node) {
        if (node.op() == UnOp.Op.NOT) {
            this.il.add(new VarInsnNode(25, this.slot(node.arg())));
            this.il.add(ConversionMethods.booleanValueOf());
            this.il.add(new InsnNode(4));
            this.il.add(new InsnNode(130));
            this.il.add(BoxedPrimitivesMethods.box(Type.BOOLEAN_TYPE, Type.getType(Boolean.class)));
        } else {
            ResumptionPoint rp = this.newResumptionPoint();
            this.il.add(rp.save());
            this.il.add(this.loadExecutionContext());
            this.il.add(new VarInsnNode(25, this.slot(node.arg())));
            this.il.add(DispatchMethods.dynamic(BytecodeEmitVisitor.dispatchMethodName(node.op()), 1));
            this.il.add(rp.resume());
            this.il.add(this.retrieve_0());
        }
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(TabNew node) {
        this.il.add(this.loadExecutionContext());
        this.il.add(ExecutionContextMethods.newTable(node.array(), node.hash()));
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(TabGet node) {
        ResumptionPoint rp = this.newResumptionPoint();
        this.il.add(rp.save());
        this.il.add(this.loadExecutionContext());
        this.il.add(new VarInsnNode(25, this.slot(node.obj())));
        this.il.add(new VarInsnNode(25, this.slot(node.key())));
        this.il.add(DispatchMethods.index());
        this.il.add(rp.resume());
        this.il.add(this.retrieve_0());
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(TabSet node) {
        ResumptionPoint rp = this.newResumptionPoint();
        this.il.add(rp.save());
        this.il.add(this.loadExecutionContext());
        this.il.add(new VarInsnNode(25, this.slot(node.obj())));
        this.il.add(new VarInsnNode(25, this.slot(node.key())));
        this.il.add(new VarInsnNode(25, this.slot(node.value())));
        this.il.add(DispatchMethods.setindex());
        this.il.add(rp.resume());
    }

    @Override
    public void visit(TabRawSet node) {
        this.il.add(new VarInsnNode(25, this.slot(node.obj())));
        this.il.add(new TypeInsnNode(192, Type.getInternalName(Table.class)));
        this.il.add(new VarInsnNode(25, this.slot(node.key())));
        this.il.add(new VarInsnNode(25, this.slot(node.value())));
        this.il.add(TableMethods.rawset());
    }

    @Override
    public void visit(TabRawSetInt node) {
        this.il.add(new VarInsnNode(25, this.slot(node.obj())));
        this.il.add(new TypeInsnNode(192, Type.getInternalName(Table.class)));
        this.il.add(ASMUtils.loadLong(node.idx()));
        this.il.add(new VarInsnNode(25, this.slot(node.value())));
        this.il.add(TableMethods.rawset_int());
    }

    @Override
    public void visit(TabRawAppendMulti node) {
        LabelNode begin = new LabelNode();
        LabelNode end = new LabelNode();
        LabelNode top = new LabelNode();
        int lv_idx_tab = this.nextLocalVariableIndex();
        int lv_idx_stack = this.nextLocalVariableIndex() + 1;
        int lv_idx_i = this.nextLocalVariableIndex() + 2;
        this.locals.add(new LocalVariableNode("tab", Type.getDescriptor(Table.class), null, begin, end, lv_idx_tab));
        this.locals.add(new LocalVariableNode("rbuf", Type.getDescriptor(ReturnBuffer.class), null, begin, end, lv_idx_stack));
        this.locals.add(new LocalVariableNode("i", Type.INT_TYPE.getDescriptor(), null, begin, end, lv_idx_i));
        this.il.add(begin);
        this.il.add(new VarInsnNode(25, this.slot(node.obj())));
        this.il.add(new TypeInsnNode(192, Type.getInternalName(Table.class)));
        this.il.add(new VarInsnNode(58, lv_idx_tab));
        this.il.add(this.loadExecutionContext());
        this.il.add(BytecodeEmitVisitor.loadReturnBuffer());
        this.il.add(new VarInsnNode(58, lv_idx_stack));
        this.il.add(ASMUtils.loadInt(0));
        this.il.add(new VarInsnNode(54, lv_idx_i));
        if (this.countingTicks()) {
            this.il.add(this.loadExecutionContext());
            this.il.add(new VarInsnNode(25, lv_idx_stack));
            this.il.add(ReturnBufferMethods.size());
            this.il.add(ExecutionContextMethods.registerTicks());
        }
        this.il.add(top);
        this.il.add(new FrameNode(1, 3, new Object[]{Type.getInternalName(Table.class), Type.getInternalName(ReturnBuffer.class), Opcodes.INTEGER}, 0, null));
        this.il.add(new VarInsnNode(21, lv_idx_i));
        this.il.add(new VarInsnNode(25, lv_idx_stack));
        this.il.add(ReturnBufferMethods.size());
        this.il.add(new JumpInsnNode(162, end));
        this.il.add(new VarInsnNode(25, lv_idx_tab));
        this.il.add(ASMUtils.loadLong(node.firstIdx()));
        this.il.add(new VarInsnNode(21, lv_idx_i));
        this.il.add(new InsnNode(133));
        this.il.add(new InsnNode(97));
        this.il.add(new VarInsnNode(25, lv_idx_stack));
        this.il.add(new VarInsnNode(21, lv_idx_i));
        this.il.add(ReturnBufferMethods.get());
        this.il.add(TableMethods.rawset_int());
        this.il.add(new IincInsnNode(lv_idx_i, 1));
        this.il.add(new JumpInsnNode(167, top));
        this.il.add(end);
        this.il.add(new FrameNode(2, 3, null, 0, null));
    }

    @Override
    public void visit(Vararg node) {
        this.il.add(this.loadExecutionContext());
        this.il.add(BytecodeEmitVisitor.loadReturnBuffer());
        this.il.add(new VarInsnNode(25, this.runMethod.LV_VARARGS));
        this.il.add(ReturnBufferMethods.setTo(0));
    }

    private int loadVList(VList vl, int maxKind) {
        if (vl.isMulti()) {
            if (vl.addrs().size() == 0) {
                this.il.add(this.loadExecutionContext());
                this.il.add(BytecodeEmitVisitor.loadReturnBuffer());
                this.il.add(ReturnBufferMethods.toArray());
                return 0;
            }
            LabelNode begin = new LabelNode();
            LabelNode end = new LabelNode();
            int lv_idx_stack = this.nextLocalVariableIndex();
            int lv_idx_args = this.nextLocalVariableIndex() + 1;
            Type arrayType = ASMUtils.arrayTypeFor(Object.class);
            this.locals.add(new LocalVariableNode("stack", arrayType.getDescriptor(), null, begin, end, lv_idx_stack));
            this.locals.add(new LocalVariableNode("args", arrayType.getDescriptor(), null, begin, end, lv_idx_args));
            this.il.add(begin);
            this.il.add(this.loadExecutionContext());
            this.il.add(BytecodeEmitVisitor.loadReturnBuffer());
            this.il.add(ReturnBufferMethods.toArray());
            this.il.add(new VarInsnNode(58, lv_idx_stack));
            this.il.add(new VarInsnNode(25, lv_idx_stack));
            this.il.add(new InsnNode(190));
            this.il.add(ASMUtils.loadInt(vl.addrs().size()));
            this.il.add(new InsnNode(96));
            this.il.add(new TypeInsnNode(189, Type.getInternalName(Object.class)));
            this.il.add(new VarInsnNode(58, lv_idx_args));
            int idx = 0;
            for (Val v : vl.addrs()) {
                this.il.add(new VarInsnNode(25, lv_idx_args));
                this.il.add(ASMUtils.loadInt(idx++));
                this.il.add(new VarInsnNode(25, this.slot(v)));
                this.il.add(new InsnNode(83));
            }
            this.il.add(new VarInsnNode(25, lv_idx_stack));
            this.il.add(ASMUtils.loadInt(0));
            this.il.add(new VarInsnNode(25, lv_idx_args));
            this.il.add(ASMUtils.loadInt(vl.addrs().size()));
            this.il.add(new VarInsnNode(25, lv_idx_stack));
            this.il.add(new InsnNode(190));
            this.il.add(new MethodInsnNode(184, Type.getInternalName(System.class), "arraycopy", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Object.class), Type.INT_TYPE, Type.getType(Object.class), Type.INT_TYPE, Type.INT_TYPE), false));
            this.il.add(new VarInsnNode(25, lv_idx_args));
            this.il.add(end);
            return 0;
        }
        int k = vl.addrs().size() + 1;
        if (k <= maxKind) {
            for (Val v : vl.addrs()) {
                this.il.add(new VarInsnNode(25, this.slot(v)));
            }
            return k;
        }
        this.il.add(ASMUtils.loadInt(vl.addrs().size()));
        this.il.add(new TypeInsnNode(189, Type.getInternalName(Object.class)));
        int idx = 0;
        for (Val v : vl.addrs()) {
            this.il.add(new InsnNode(89));
            this.il.add(ASMUtils.loadInt(idx++));
            this.il.add(new VarInsnNode(25, this.slot(v)));
            this.il.add(new InsnNode(83));
        }
        return 0;
    }

    @Override
    public void visit(Ret node) {
        this.il.add(this.loadExecutionContext());
        this.il.add(BytecodeEmitVisitor.loadReturnBuffer());
        int kind = this.loadVList(node.args(), ReturnBufferMethods.MAX_SETTO_KIND);
        this.il.add(ReturnBufferMethods.setTo(kind));
        this.il.add(this._return());
    }

    @Override
    public void visit(TCall node) {
        this.il.add(this.loadExecutionContext());
        this.il.add(BytecodeEmitVisitor.loadReturnBuffer());
        this.il.add(new VarInsnNode(25, this.slot(node.target())));
        int kind = this.loadVList(node.args(), ReturnBufferMethods.MAX_TAILCALL_KIND);
        this.il.add(ReturnBufferMethods.tailCall(kind));
        this.il.add(this._return());
    }

    @Override
    public void visit(Call node) {
        ResumptionPoint rp = this.newResumptionPoint();
        this.il.add(rp.save());
        this.il.add(this.loadExecutionContext());
        this.il.add(new VarInsnNode(25, this.slot(node.fn())));
        int kind = this.loadVList(node.args(), DispatchMethods.MAX_CALL_KIND);
        this.il.add(DispatchMethods.call(kind));
        this.il.add(rp.resume());
    }

    @Override
    public void visit(MultiGet node) {
        this.il.add(this.loadExecutionContext());
        this.il.add(BytecodeEmitVisitor.loadReturnBuffer());
        this.il.add(ReturnBufferMethods.get(node.idx()));
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(Label node) {
        this.il.add(this.l(node));
        this.il.add(ASMUtils.frameSame());
    }

    @Override
    public void visit(Jmp node) {
        this.il.add(this._goto(node.jmpDest()));
    }

    @Override
    public void visit(Closure node) {
        ClosureUse cu = new ClosureUse(node.id(), node.args(), this.instanceLevelClosures.size());
        if (cu.isClosed() && !cu.isPure()) {
            this.instanceLevelClosures.add(cu.toClosureFieldInstance());
        }
        this.il.add(cu.fetchInstanceInsns());
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(ToNumber node) {
        this.il.add(new VarInsnNode(25, this.slot(node.src())));
        this.il.add(ConversionMethods.toNumericalValue(node.desc()));
        this.il.add(new VarInsnNode(58, this.slot(node.dest())));
    }

    @Override
    public void visit(ToNext node) {
        this.il.add(this._next(node.label()));
    }

    @Override
    public void visit(Branch branch) {
        assert (this.destLabel == null);
        try {
            this.destLabel = branch.jmpDest();
            branch.condition().accept(this);
            this.il.add(this._next(branch.next()));
        }
        finally {
            this.destLabel = null;
        }
    }

    @Override
    public void visit(Branch.Condition.Nil cond) {
        assert (this.destLabel != null);
        this.il.add(new VarInsnNode(25, this.slot(cond.addr())));
        if (!this.isSub() || this.resolver.isLocalLabel(this.destLabel)) {
            this.il.add(new JumpInsnNode(198, this.l(this.destLabel)));
        } else {
            LabelNode l_nojump = new LabelNode();
            this.il.add(new JumpInsnNode(199, l_nojump));
            this.il.add(this._nonLocalGoto(this.destLabel));
            this.il.add(l_nojump);
            this.il.add(new FrameNode(3, 0, null, 0, null));
        }
    }

    @Override
    public void visit(Branch.Condition.Bool cond) {
        assert (this.destLabel != null);
        this.il.add(new VarInsnNode(25, this.slot(cond.addr())));
        this.il.add(ConversionMethods.booleanValueOf());
        if (!this.isSub() || this.resolver.isLocalLabel(this.destLabel)) {
            this.il.add(new JumpInsnNode(cond.expected() ? 154 : 153, this.l(this.destLabel)));
        } else {
            LabelNode l_nojump = new LabelNode();
            this.il.add(new JumpInsnNode(cond.expected() ? 153 : 154, l_nojump));
            this.il.add(this._nonLocalGoto(this.destLabel));
            this.il.add(l_nojump);
            this.il.add(new FrameNode(3, 0, null, 0, null));
        }
    }

    @Override
    public void visit(Branch.Condition.NumLoopEnd cond) {
        assert (this.destLabel != null);
        this.il.add(new VarInsnNode(25, this.slot(cond.var())));
        this.il.add(new TypeInsnNode(192, Type.getInternalName(Number.class)));
        this.il.add(new VarInsnNode(25, this.slot(cond.limit())));
        this.il.add(new TypeInsnNode(192, Type.getInternalName(Number.class)));
        this.il.add(new VarInsnNode(25, this.slot(cond.step())));
        this.il.add(new TypeInsnNode(192, Type.getInternalName(Number.class)));
        this.il.add(DispatchMethods.continueLoop());
        if (!this.isSub() || this.resolver.isLocalLabel(this.destLabel)) {
            this.il.add(new JumpInsnNode(153, this.l(this.destLabel)));
        } else {
            LabelNode l_nojump = new LabelNode();
            this.il.add(new JumpInsnNode(154, l_nojump));
            this.il.add(this._nonLocalGoto(this.destLabel));
            this.il.add(l_nojump);
            this.il.add(new FrameNode(3, 0, null, 0, null));
        }
    }

    private void staticCpuWithdraw(int cost) {
        switch (this.context.compilerSettings.cpuAccountingMode()) {
            case NO_CPU_ACCOUNTING: {
                break;
            }
            case IN_EVERY_BASIC_BLOCK: {
                ResumptionPoint rp = this.newResumptionPoint();
                this.il.add(rp.save());
                this.il.add(this.loadExecutionContext());
                this.il.add(new InsnNode(89));
                this.il.add(ASMUtils.loadInt(cost));
                this.il.add(ExecutionContextMethods.registerTicks());
                this.il.add(ExecutionContextMethods.checkCallYield());
                this.il.add(rp.resume());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported CPU accounting mode: " + (Object)((Object)this.context.compilerSettings.cpuAccountingMode()));
            }
        }
    }

    private boolean countingTicks() {
        return this.context.compilerSettings.cpuAccountingMode() != CompilerSettings.CPUAccountingMode.NO_CPU_ACCOUNTING;
    }

    @Override
    public void visit(CPUWithdraw node) {
        this.staticCpuWithdraw(node.cost());
    }

    @Override
    public void visit(Line node) {
        LabelNode l = new LabelNode();
        this.il.add(l);
        this.il.add(new LineNumberNode(node.lineNumber(), l));
    }

    private class ClosureUse {
        private final FunctionId id;
        private final List<AbstractVar> upvals;
        private final String fieldName;

        private ClosureUse(FunctionId id, List<AbstractVar> upvals, int idx) {
            this.id = Objects.requireNonNull(id);
            this.upvals = Objects.requireNonNull(upvals);
            this.fieldName = this.isClosed() && !this.isPure() ? BytecodeEmitVisitor.this.context.addFieldName("c_" + idx) : null;
        }

        public boolean isClosed() {
            for (AbstractVar uv : this.upvals) {
                if (!(uv instanceof Var)) continue;
                return false;
            }
            return true;
        }

        public boolean isPure() {
            return this.upvals.isEmpty();
        }

        public RunMethod.ClosureFieldInstance toClosureFieldInstance() {
            assert (this.isClosed());
            FieldNode fieldNode = this.instanceFieldNode();
            InsnList il = new InsnList();
            il.add(new VarInsnNode(25, 0));
            il.add(this.instantiationInsns());
            il.add(new FieldInsnNode(181, BytecodeEmitVisitor.this.context.thisClassType().getInternalName(), this.instanceFieldName(), this.instanceType().getDescriptor()));
            return new RunMethod.ClosureFieldInstance(this.instanceFieldNode(), il);
        }

        private InsnList instantiationInsns() {
            InsnList il = new InsnList();
            ClassNameTranslator tr = ((BytecodeEmitVisitor)BytecodeEmitVisitor.this).context.classNameTranslator;
            Type fnType = ASMUtils.typeForClassName(this.id.toClassName(tr));
            il.add(new TypeInsnNode(187, fnType.getInternalName()));
            il.add(new InsnNode(89));
            for (AbstractVar var : this.upvals) {
                if (var instanceof UpVar) {
                    il.add(BytecodeEmitVisitor.this.loadUpvalueRef((UpVar)var));
                    continue;
                }
                Var v = (Var)var;
                assert (((BytecodeEmitVisitor)BytecodeEmitVisitor.this).context.types.isReified(v));
                il.add(new VarInsnNode(25, BytecodeEmitVisitor.this.slot(v)));
                il.add(new TypeInsnNode(192, Type.getInternalName(Variable.class)));
            }
            Object[] ctorArgTypes = new Type[this.upvals.size()];
            Arrays.fill(ctorArgTypes, Type.getType(Variable.class));
            il.add(ASMUtils.ctor(fnType, (Type[])ctorArgTypes));
            return il;
        }

        private String instanceFieldName() {
            return this.fieldName;
        }

        private Type instanceType() {
            return ASMUtils.typeForClassName(this.id.toClassName(((BytecodeEmitVisitor)BytecodeEmitVisitor.this).context.classNameTranslator));
        }

        private FieldNode instanceFieldNode() {
            return new FieldNode(18, this.instanceFieldName(), this.instanceType().getDescriptor(), null, null);
        }

        private InsnList fetchInstanceInsns() {
            InsnList il = new InsnList();
            if (this.isClosed()) {
                if (this.isPure()) {
                    il.add(new FieldInsnNode(178, this.instanceType().getInternalName(), ASMBytecodeEmitter.instanceFieldName(), this.instanceType().getDescriptor()));
                } else {
                    il.add(new VarInsnNode(25, 0));
                    il.add(new FieldInsnNode(180, BytecodeEmitVisitor.this.context.thisClassType().getInternalName(), this.instanceFieldName(), this.instanceType().getDescriptor()));
                }
            } else {
                il.add(this.instantiationInsns());
            }
            return il;
        }
    }

    class ResumptionPoint {
        public final int index;

        private ResumptionPoint(int index) {
            this.index = index;
        }

        public LabelNode label() {
            return BytecodeEmitVisitor.this.l(this);
        }

        public InsnList save() {
            int st = !BytecodeEmitVisitor.this.isSub() ? this.index + 1 : BytecodeEmitVisitor.this.segmentIdx << 24 | this.index + 1;
            return BytecodeEmitVisitor.this.saveState(st);
        }

        public InsnList resume() {
            InsnList il = new InsnList();
            il.add(this.label());
            il.add(ASMUtils.frameSame());
            return il;
        }
    }
}

